/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.forge.commands.BaseCommand;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.storage.WorldInfo;

public class WeatherCommand
extends BaseCommand {
    WeatherCommand() {
        this.name = "weather";
        this.usage = "weather <rain/clear/thunder> [time in seconds]";
        this.description = "Sets weather in the current dimension.";
        this.needsOp = true;
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        int time;
        if (args.size() == 0 || args.size() > 2) {
            return false;
        }
        if (args.size() == 1) {
            time = 0;
        } else {
            try {
                time = Integer.parseInt(args.get(1)) * 50;
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(args.get(1) + " is not a number"));
                return true;
            }
        }
        WorldInfo info = sender.func_130014_f_().func_72912_H();
        switch (args.get(0).toLowerCase()) {
            case "clear": {
                info.func_76084_b(false);
                info.func_76069_a(false);
                if (time <= 0) break;
                info.func_176142_i(time);
                break;
            }
            case "rain": {
                info.func_76084_b(true);
                info.func_76069_a(false);
                if (time <= 0) break;
                info.func_76080_g(time);
                break;
            }
            case "thunder": {
                info.func_76084_b(true);
                info.func_76069_a(true);
                if (time <= 0) break;
                info.func_76090_f(time);
                break;
            }
            default: {
                return false;
            }
        }
        String msg = "Weather set to " + args.get(0);
        if (time > 0) {
            msg = msg + " for " + time / 50 + " seconds";
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(msg));
        return true;
    }
}

