/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.commands.BaseCommand;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class StructureCommand
extends BaseCommand {
    StructureCommand() {
        this.name = "structure";
        this.usage = "structure";
        this.description = "View author and description information for any structure at the player's coordinates.";
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        LocalWorld world = this.getWorld(sender, "");
        if (world == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
            return true;
        }
        String structureInfo = world.getWorldSession().getStructureInfoAt(sender.func_180425_c().func_177958_n(), sender.func_180425_c().func_177952_p());
        if (structureInfo.length() > 0) {
            for (String messagePart : structureInfo.split("\r\n")) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(messagePart, new Object[0]));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "There is no structure at this location.", new Object[0]));
        }
        return true;
    }
}

