/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ModDataCommand
extends BaseCommand {
    ModDataCommand() {
        this.name = "getmoddata";
        this.usage = "getmoddata <ModName> <Radius>";
        this.description = "Sends any ModData() tags in BO3's within the specified <Radius> in chunks to the specified <ModName>. Some OTG mob spawning commands can be used this way. Be sure to set up ModData() tags in your BO3 to make this work.";
    }

    @Override
    public boolean onCommand(ICommandSender sender, List<String> args) {
        LocalWorld world = this.getWorld(sender, "");
        BlockPos pos = sender.func_180425_c();
        int playerX = pos.func_177958_n();
        int playerZ = pos.func_177952_p();
        if (world == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
            return true;
        }
        if (args.size() == 2) {
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
            FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)args.get(1), (String)"GetModData", (String)(sender.func_130014_f_().func_72912_H().func_76065_j() + "," + chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ()));
        } else if (args.size() == 3) {
            try {
                ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                int radius = Integer.parseInt(args.get(2));
                if (radius > 50) {
                    radius = 50;
                    OTG.log(LogMarker.WARN, "Error in GetModData call: Parameter radius can be no higher than 50. Radius was set to 50.", new Object[0]);
                }
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        ChunkCoordinate chunkCoord2 = ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + x, chunkCoord.getChunkZ() + z);
                        FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)args.get(1), (String)"GetModData", (String)(sender.func_130014_f_().func_72912_H().func_76065_j() + "," + chunkCoord2.getChunkX() + "," + chunkCoord2.getChunkZ()));
                    }
                }
            }
            catch (NumberFormatException ex) {
                OTG.log(LogMarker.WARN, "Error in GetModData call: value \"" + args.get(2) + "\" was expected to be a number", new Object[0]);
            }
        } else {
            return false;
        }
        return true;
    }
}

