/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.blocks.portal;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.blocks.ModBlocks;
import com.pg85.otg.forge.blocks.portal.BlockPortalOTG;
import com.pg85.otg.logging.LogMarker;
import java.util.Arrays;
import java.util.List;

public class PortalColors {
    public static final String PortalColorBeige = "beige";
    public static final String PortalColorBlack = "black";
    public static final String PortalColorBlue = "blue";
    public static final String PortalColorCrystalBlue = "crystalblue";
    public static final String PortalColorDarkBlue = "darkblue";
    public static final String PortalColorDarkGreen = "darkgreen";
    public static final String PortalColorDarkRed = "darkred";
    public static final String PortalColorEmerald = "emerald";
    public static final String PortalColorFlame = "flame";
    public static final String PortalColorGold = "gold";
    public static final String PortalColorGreen = "green";
    public static final String PortalColorGrey = "grey";
    public static final String PortalColorLightBlue = "lightblue";
    public static final String PortalColorLightGreen = "lightgreen";
    public static final String PortalColorOrange = "orange";
    public static final String PortalColorPink = "pink";
    public static final String PortalColorRed = "red";
    public static final String PortalColorWhite = "white";
    public static final String PortalColorYellow = "yellow";
    public static final String PortalColorDefault = "default";
    public static final String BlockPortalOTGBeigeName = "portalotg_beige";
    public static final String BlockPortalOTGBlackName = "portalotg_black";
    public static final String BlockPortalOTGBlueName = "portalotg_blue";
    public static final String BlockPortalOTGCrystalBlueName = "portalotg_crystalblue";
    public static final String BlockPortalOTGDarkBlueName = "portalotg_darkblue";
    public static final String BlockPortalOTGDarkGreenName = "portalotg_darkgreen";
    public static final String BlockPortalOTGDarkRedName = "portalotg_darkred";
    public static final String BlockPortalOTGEmeraldName = "portalotg_emerald";
    public static final String BlockPortalOTGFlameName = "portalotg_flame";
    public static final String BlockPortalOTGGoldName = "portalotg_gold";
    public static final String BlockPortalOTGGreenName = "portalotg_green";
    public static final String BlockPortalOTGGreyName = "portalotg_grey";
    public static final String BlockPortalOTGLightBlueName = "portalotg_lightblue";
    public static final String BlockPortalOTGLightGreenName = "portalotg_lightgreen";
    public static final String BlockPortalOTGOrangeName = "portalotg_orange";
    public static final String BlockPortalOTGPinkName = "portalotg_pink";
    public static final String BlockPortalOTGRedName = "portalotg_red";
    public static final String BlockPortalOTGWhiteName = "portalotg_white";
    public static final String BlockPortalOTGYellowName = "portalotg_yellow";
    public static final String BlockPortalOTGDefaultName = "portalotg";
    public static List<String> portalColors = Arrays.asList("default", "beige", "black", "blue", "crystalblue", "darkblue", "darkgreen", "darkred", "emerald", "flame", "gold", "green", "grey", "lightblue", "lightgreen", "orange", "pink", "red", "white", "yellow");

    public static BlockPortalOTG getPortalBlockByColor(String color) {
        if (color == null) {
            return ModBlocks.BlockPortalOTG;
        }
        switch (color.trim().toLowerCase()) {
            case "beige": {
                return ModBlocks.BlockPortalOTGBeige;
            }
            case "black": {
                return ModBlocks.BlockPortalOTGBlack;
            }
            case "blue": {
                return ModBlocks.BlockPortalOTGBlue;
            }
            case "crystalblue": {
                return ModBlocks.BlockPortalOTGCrystalBlue;
            }
            case "darkblue": {
                return ModBlocks.BlockPortalOTGDarkBlue;
            }
            case "darkgreen": {
                return ModBlocks.BlockPortalOTGDarkGreen;
            }
            case "darkred": {
                return ModBlocks.BlockPortalOTGDarkRed;
            }
            case "emerald": {
                return ModBlocks.BlockPortalOTGEmerald;
            }
            case "flame": {
                return ModBlocks.BlockPortalOTGFlame;
            }
            case "gold": {
                return ModBlocks.BlockPortalOTGGold;
            }
            case "green": {
                return ModBlocks.BlockPortalOTGGreen;
            }
            case "grey": {
                return ModBlocks.BlockPortalOTGGrey;
            }
            case "lightblue": {
                return ModBlocks.BlockPortalOTGLightBlue;
            }
            case "lightgreen": {
                return ModBlocks.BlockPortalOTGLightGreen;
            }
            case "orange": {
                return ModBlocks.BlockPortalOTGOrange;
            }
            case "pink": {
                return ModBlocks.BlockPortalOTGPink;
            }
            case "red": {
                return ModBlocks.BlockPortalOTGRed;
            }
            case "white": {
                return ModBlocks.BlockPortalOTGWhite;
            }
            case "yellow": {
                return ModBlocks.BlockPortalOTGYellow;
            }
        }
        return ModBlocks.BlockPortalOTG;
    }

    public static String getPortalColorByPortalBlock(BlockPortalOTG block) {
        if (block.getRegistryName().func_110623_a() == null) {
            return null;
        }
        switch (block.getRegistryName().func_110623_a()) {
            case "portalotg_beige": {
                return PortalColorBeige;
            }
            case "portalotg_black": {
                return PortalColorBlack;
            }
            case "portalotg_blue": {
                return PortalColorBlue;
            }
            case "portalotg_crystalblue": {
                return PortalColorCrystalBlue;
            }
            case "portalotg_darkblue": {
                return PortalColorDarkBlue;
            }
            case "portalotg_darkgreen": {
                return PortalColorDarkGreen;
            }
            case "portalotg_darkred": {
                return PortalColorDarkRed;
            }
            case "portalotg_emerald": {
                return PortalColorEmerald;
            }
            case "portalotg_flame": {
                return PortalColorFlame;
            }
            case "portalotg_gold": {
                return PortalColorGold;
            }
            case "portalotg_green": {
                return PortalColorGreen;
            }
            case "portalotg_grey": {
                return PortalColorGrey;
            }
            case "portalotg_lightblue": {
                return PortalColorLightBlue;
            }
            case "portalotg_lightgreen": {
                return PortalColorLightGreen;
            }
            case "portalotg_orange": {
                return PortalColorOrange;
            }
            case "portalotg_pink": {
                return PortalColorPink;
            }
            case "portalotg_red": {
                return PortalColorRed;
            }
            case "portalotg_white": {
                return PortalColorWhite;
            }
            case "portalotg_yellow": {
                return PortalColorYellow;
            }
            case "portalotg": {
                return PortalColorDefault;
            }
        }
        return null;
    }

    public static String getNextPortalColor(String currentColor) {
        if (currentColor != null && !currentColor.toLowerCase().equals(portalColors.get(portalColors.size() - 1))) {
            for (int i = 0; i < portalColors.size(); ++i) {
                if (!portalColors.get(i).equals(currentColor.toLowerCase())) continue;
                return portalColors.get(i + 1);
            }
        }
        return portalColors.get(0);
    }

    public static void correctPortalColor(DimensionConfig dimConfig, List<DimensionConfig> dimensions) {
        if (!PortalColors.isPortalColorFree(dimConfig.Settings.PortalColor, dimensions)) {
            dimConfig.Settings.PortalColor = PortalColors.getNextFreePortalColor(dimConfig.Settings.PortalColor, dimensions, false);
            OTG.log(LogMarker.INFO, "Warning: Client tried to create a dimension, but portal color is already in use, changed portal color.", new Object[0]);
        }
    }

    private static boolean isPortalColorFree(String currentColor, List<DimensionConfig> dimensions) {
        for (DimensionConfig dimConfig1 : dimensions) {
            if (!dimConfig1.Settings.PortalColor.toLowerCase().equals(currentColor.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public static String getNextFreePortalColor(String currentColor, List<DimensionConfig> dimensions, boolean allowCurrent) {
        boolean bFound;
        String newPortalColor = null;
        if (allowCurrent) {
            bFound = false;
            for (DimensionConfig dimConfig1 : dimensions) {
                if (!dimConfig1.Settings.PortalColor.toLowerCase().equals(currentColor.toLowerCase())) continue;
                if (bFound) {
                    allowCurrent = false;
                }
                bFound = true;
            }
        }
        newPortalColor = currentColor.toLowerCase();
        block1: do {
            if ((newPortalColor = PortalColors.getNextPortalColor(newPortalColor)).equals(currentColor.toLowerCase())) {
                if (allowCurrent) {
                    return newPortalColor;
                }
                return PortalColorDefault;
            }
            bFound = false;
            for (DimensionConfig dimConfig1 : dimensions) {
                if (!dimConfig1.Settings.PortalColor.toLowerCase().equals(newPortalColor)) continue;
                bFound = true;
                continue block1;
            }
        } while (bFound);
        return newPortalColor;
    }
}

