/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo4.smoothing;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.customobjects.structures.bo4.smoothing.SmoothingAreaBlock;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.ArrayList;

public class SmoothingAreaColumn {
    private int x;
    private int z;
    private final ArrayList<SmoothingAreaBlock> blocks = new ArrayList();
    private SmoothingAreaBlock highestFillingBlock = null;
    private SmoothingAreaBlock lowestCuttingBlock = null;

    public SmoothingAreaColumn(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public void addBlock(SmoothingAreaBlock block) {
        this.blocks.add(block);
    }

    public void processBlocks(LocalWorld world, ChunkCoordinate chunkBeingPopulated, BO4Config bo4Config) {
        if (this.highestFillingBlock == null && this.lowestCuttingBlock == null) {
            for (SmoothingAreaBlock block : this.blocks) {
                if (block.smoothingBlockType == SmoothingAreaBlock.enumSmoothingBlockType.FILLING && (this.highestFillingBlock == null || this.highestFillingBlock.y < block.y)) {
                    this.highestFillingBlock = block;
                }
                if (block.smoothingBlockType != SmoothingAreaBlock.enumSmoothingBlockType.CUTTING || this.lowestCuttingBlock != null && this.lowestCuttingBlock.y <= block.y) continue;
                this.lowestCuttingBlock = block;
            }
            if (this.highestFillingBlock != null && this.lowestCuttingBlock != null && this.lowestCuttingBlock.y > this.highestFillingBlock.y) {
                this.lowestCuttingBlock.y = this.highestFillingBlock.y;
            }
        }
        this.spawn(world, chunkBeingPopulated, bo4Config);
    }

    private void spawn(LocalWorld world, ChunkCoordinate chunkBeingPopulated, BO4Config bo4Config) {
        block32: {
            LocalMaterialData blockAbove;
            LocalMaterialData surfaceBlock;
            int y;
            boolean useSagcGround;
            boolean useSagcSurface;
            LocalMaterialData smoothingGroundBlock;
            LocalMaterialData smoothingSurfaceBlock;
            LocalMaterialData replaceAboveMaterial;
            BiomeConfig biomeConfig;
            block31: {
                block30: {
                    block29: {
                        biomeConfig = world.getBiome(this.x, this.z).getBiomeConfig();
                        replaceAboveMaterial = null;
                        try {
                            replaceAboveMaterial = MaterialHelper.readMaterial(bo4Config.replaceAbove);
                        }
                        catch (InvalidConfigException e) {
                            if (!OTG.getPluginConfig().spawnLog) break block29;
                            OTG.log(LogMarker.WARN, "ReplaceAbove: " + bo4Config.replaceAbove + " could not be parsed as a material for BO4 " + bo4Config.getName(), new Object[0]);
                        }
                    }
                    smoothingSurfaceBlock = null;
                    smoothingGroundBlock = null;
                    useSagcSurface = bo4Config.replaceWithBiomeBlocks && bo4Config.smoothingSurfaceBlock != null && bo4Config.smoothingSurfaceBlock.equalsIgnoreCase(bo4Config.replaceWithSurfaceBlock);
                    useSagcGround = bo4Config.replaceWithBiomeBlocks && bo4Config.smoothingGroundBlock != null && bo4Config.smoothingGroundBlock.equalsIgnoreCase(bo4Config.replaceWithGroundBlock);
                    try {
                        smoothingSurfaceBlock = MaterialHelper.readMaterial(bo4Config.smoothingSurfaceBlock);
                    }
                    catch (InvalidConfigException e) {
                        if (!OTG.getPluginConfig().spawnLog) break block30;
                        OTG.log(LogMarker.WARN, "SmoothingSurfaceBlock: " + bo4Config.smoothingSurfaceBlock + " could not be parsed as a material for BO4 " + bo4Config.getName(), new Object[0]);
                    }
                }
                if (smoothingSurfaceBlock == null) {
                    smoothingSurfaceBlock = biomeConfig.getDefaultSurfaceBlock();
                }
                try {
                    smoothingGroundBlock = MaterialHelper.readMaterial(bo4Config.smoothingGroundBlock);
                }
                catch (InvalidConfigException e) {
                    if (!OTG.getPluginConfig().spawnLog) break block31;
                    OTG.log(LogMarker.WARN, "SmoothingGroundBlock: " + bo4Config.smoothingGroundBlock + " could not be parsed as a material for BO4 " + bo4Config.getName(), new Object[0]);
                }
            }
            if (smoothingGroundBlock == null) {
                smoothingGroundBlock = biomeConfig.getDefaultGroundBlock();
            }
            int highestBlockInWorld = -1;
            if (this.lowestCuttingBlock != null && this.highestFillingBlock == null && replaceAboveMaterial != null) {
                if (highestBlockInWorld == -1) {
                    highestBlockInWorld = world.getHighestBlockYAt(this.x, this.z, true, false, true, true, true, null);
                }
                for (y = highestBlockInWorld; y > this.lowestCuttingBlock.y; --y) {
                    if (y <= 0) continue;
                    world.setBlock(this.lowestCuttingBlock.x, y, this.lowestCuttingBlock.z, replaceAboveMaterial, null, chunkBeingPopulated, false);
                }
                if (highestBlockInWorld > this.lowestCuttingBlock.y && this.lowestCuttingBlock.y > 0) {
                    surfaceBlock = null;
                    boolean needsReplaceBlocks = bo4Config.doReplaceBlocks;
                    if (useSagcSurface) {
                        blockAbove = world.getMaterial(this.lowestCuttingBlock.x, this.lowestCuttingBlock.y + 1, this.lowestCuttingBlock.z, chunkBeingPopulated);
                        surfaceBlock = blockAbove != null && (blockAbove.isSolid() || blockAbove.isLiquid()) ? biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, this.lowestCuttingBlock.x, this.lowestCuttingBlock.y, this.lowestCuttingBlock.z) : biomeConfig.surfaceAndGroundControl.getSurfaceBlockAtHeight(world, biomeConfig, this.lowestCuttingBlock.x, this.lowestCuttingBlock.y, this.lowestCuttingBlock.z);
                        needsReplaceBlocks = false;
                        if (surfaceBlock.isAir()) {
                            surfaceBlock = this.lowestCuttingBlock.y < (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax) && world.getMaterial(this.lowestCuttingBlock.x, this.lowestCuttingBlock.y, this.lowestCuttingBlock.z, chunkBeingPopulated).isAir() ? MaterialHelper.WATER : null;
                        }
                    } else {
                        surfaceBlock = smoothingSurfaceBlock;
                    }
                    if (surfaceBlock != null) {
                        world.setBlock(this.lowestCuttingBlock.x, this.lowestCuttingBlock.y, this.lowestCuttingBlock.z, surfaceBlock, null, chunkBeingPopulated, needsReplaceBlocks);
                    }
                }
            }
            if (this.highestFillingBlock == null) break block32;
            if (highestBlockInWorld == -1) {
                highestBlockInWorld = world.getHighestBlockYAt(this.x, this.z, true, false, true, true, true, null);
            }
            if (replaceAboveMaterial != null) {
                for (y = highestBlockInWorld; y > this.highestFillingBlock.y; --y) {
                    if (y <= 0) continue;
                    world.setBlock(this.highestFillingBlock.x, y, this.highestFillingBlock.z, replaceAboveMaterial, null, chunkBeingPopulated, false);
                }
            }
            surfaceBlock = null;
            boolean needsReplaceBlocks = bo4Config.doReplaceBlocks;
            if (useSagcSurface) {
                blockAbove = world.getMaterial(this.highestFillingBlock.x, this.highestFillingBlock.y + 1, this.highestFillingBlock.z, chunkBeingPopulated);
                surfaceBlock = blockAbove != null && (blockAbove.isSolid() || blockAbove.isLiquid()) ? biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, this.highestFillingBlock.x, this.highestFillingBlock.y, this.highestFillingBlock.z) : biomeConfig.surfaceAndGroundControl.getSurfaceBlockAtHeight(world, biomeConfig, this.highestFillingBlock.x, this.highestFillingBlock.y, this.highestFillingBlock.z);
                needsReplaceBlocks = false;
                if (surfaceBlock.isAir()) {
                    surfaceBlock = this.highestFillingBlock.y < (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax) && world.getMaterial(this.highestFillingBlock.x, this.highestFillingBlock.y, this.highestFillingBlock.z, chunkBeingPopulated).isAir() ? MaterialHelper.WATER : null;
                }
            } else {
                surfaceBlock = smoothingSurfaceBlock;
            }
            if (surfaceBlock != null && this.highestFillingBlock.y > 0) {
                world.setBlock(this.highestFillingBlock.x, this.highestFillingBlock.y, this.highestFillingBlock.z, surfaceBlock, null, chunkBeingPopulated, needsReplaceBlocks);
            }
            if (useSagcGround) {
                for (y = this.highestFillingBlock.y - 1; y >= highestBlockInWorld; --y) {
                    if (y <= 0) continue;
                    LocalMaterialData groundBlock = biomeConfig.surfaceAndGroundControl.getGroundBlockAtHeight(world, biomeConfig, this.highestFillingBlock.x, y, this.highestFillingBlock.z);
                    if (groundBlock.isAir() && y < (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax)) {
                        groundBlock = MaterialHelper.WATER;
                    }
                    world.setBlock(this.highestFillingBlock.x, y, this.highestFillingBlock.z, groundBlock, null, chunkBeingPopulated, false);
                }
            } else {
                for (y = this.highestFillingBlock.y - 1; y >= highestBlockInWorld; --y) {
                    if (y <= 0) continue;
                    LocalMaterialData groundBlock = smoothingGroundBlock;
                    needsReplaceBlocks = bo4Config.doReplaceBlocks;
                    if (groundBlock.isAir() && y < (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax)) {
                        groundBlock = MaterialHelper.WATER;
                        needsReplaceBlocks = false;
                    }
                    world.setBlock(this.highestFillingBlock.x, y, this.highestFillingBlock.z, groundBlock, null, chunkBeingPopulated, needsReplaceBlocks);
                }
            }
        }
    }
}

