/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.SpawnableObject;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bofunctions.BlockFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.minecraft.defaults.DefaultStructurePart;
import java.util.List;
import java.util.Random;

public abstract class MinecraftObjectFunction<T extends CustomObjectConfigFile>
extends BlockFunction<T> {
    private DefaultStructurePart structurePart;
    protected Rotation rotation = Rotation.NORTH;

    public MinecraftObjectFunction() {
    }

    public MinecraftObjectFunction(BO3Config config, List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = (short)this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.structurePart = DefaultStructurePart.getDefaultStructurePart(args.get(3));
    }

    @Override
    public String makeString() {
        return "MinecraftObject(" + this.x + ',' + this.y + ',' + this.z + ',' + (Object)((Object)this.structurePart) + ')';
    }

    @Override
    public void spawn(LocalWorld world, Random random, int x, int y, int z, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        SpawnableObject object = world.getMojangStructurePart(this.structurePart.getPath());
        object.spawnForced(world, random, this.rotation, x, y, z);
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        MinecraftObjectFunction block = (MinecraftObjectFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

