/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.io;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.configuration.io.SettingsWriterOTGPlus;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.logging.LogMarker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileSettingsWriterOTGPlus
implements SettingsWriterOTGPlus {
    private final File file;
    private boolean writeComments;
    private BufferedWriter writer;

    public FileSettingsWriterOTGPlus(CustomObjectConfigFile configFile) {
        this.file = configFile.getFile();
    }

    public FileSettingsWriterOTGPlus(File file) {
        this.file = file;
    }

    public static final void writeToFile(CustomObjectConfigFile config, WorldConfig.ConfigMode configMode) {
        FileSettingsWriterOTGPlus.writeToFile(config, config.getFile(), configMode);
    }

    private static final void writeToFile(CustomObjectConfigFile config, File file, WorldConfig.ConfigMode configMode) {
        if (configMode == WorldConfig.ConfigMode.WriteDisable) {
            return;
        }
        try {
            FileSettingsWriterOTGPlus writer = new FileSettingsWriterOTGPlus(file);
            config.write(writer, configMode);
        }
        catch (IOException e) {
            FileSettingsWriterOTGPlus.logIOError(e, file);
        }
    }

    private static void logIOError(IOException e, File file) {
        OTG.log(LogMarker.ERROR, "Failed to write to file {}", file);
        OTG.printStackTrace(LogMarker.ERROR, e);
    }

    @Override
    public void bigTitle(String title) throws IOException {
        this.checkState();
        this.writer.newLine();
        this.writer.write("#######################################################################");
        this.writer.newLine();
        this.writer.write("# +-----------------------------------------------------------------+ #");
        this.writer.newLine();
        StringBuilder builder = new StringBuilder(title);
        builder.insert(0, ' ');
        builder.append(' ');
        boolean flag = true;
        while (builder.length() < 65) {
            if (flag) {
                builder.insert(0, ' ');
            } else {
                builder.append(' ');
            }
            flag = !flag;
        }
        this.writer.write("# |" + builder.toString() + "| #");
        this.writer.newLine();
        this.writer.write("# +-----------------------------------------------------------------+ #");
        this.writer.newLine();
        this.writer.write("#######################################################################");
        this.writer.newLine();
        this.writer.newLine();
    }

    private void checkState() throws IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Not started writing yet");
        }
    }

    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            OTG.log(LogMarker.WARN, "Failed to close file {} ({})", this.file.getAbsolutePath(), e.getMessage());
        }
        this.writer = null;
    }

    @Override
    public void comment(String comment) throws IOException {
        this.checkState();
        if (!this.writeComments) {
            return;
        }
        if (comment.length() > 0) {
            this.writer.write("# " + comment);
        }
        this.writer.newLine();
    }

    @Override
    public void function(CustomObjectConfigFunction<?> function) throws IOException {
        this.checkState();
        this.writer.write(function.write());
        this.writer.newLine();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void open() throws IOException {
        this.file.getParentFile().mkdirs();
        this.writer = new BufferedWriter(new FileWriter(this.file));
    }

    @Override
    public void setConfigMode(WorldConfig.ConfigMode configMode) {
        if (configMode == WorldConfig.ConfigMode.WriteAll) {
            this.writeComments = true;
        } else if (configMode == WorldConfig.ConfigMode.WriteWithoutComments) {
            this.writeComments = false;
        } else {
            throw new IllegalArgumentException("Invalid config mode: " + (Object)((Object)configMode));
        }
    }

    public <T> void setting(Setting<T> setting, T value) throws IOException {
        this.checkState();
        this.writer.write(setting.getName() + ": " + setting.write(value));
        this.writer.newLine();
        this.writer.newLine();
    }

    @Override
    public void smallTitle(String title) throws IOException {
        this.checkState();
        int titleLength = title.length();
        StringBuilder rowBuilder = new StringBuilder(titleLength + 4);
        for (int i = 0; i < titleLength + 4; ++i) {
            rowBuilder.append('#');
        }
        this.writer.write(rowBuilder.toString());
        this.writer.newLine();
        this.writer.write("# " + title + " #");
        this.writer.newLine();
        this.writer.write(rowBuilder.toString());
        this.writer.newLine();
        this.writer.newLine();
    }
}

