/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.biome;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.biome.settings.WeightedMobSpawnGroup;
import com.pg85.otg.configuration.io.FileSettingsReader;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.io.SimpleSettingsMap;
import com.pg85.otg.configuration.standard.BiomeStandardValues;
import com.pg85.otg.configuration.standard.StandardBiomeTemplate;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraft.defaults.BiomeRegistryNames;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BiomeConfigFinder {
    private final String preferredBiomeFileExtension;

    public BiomeConfigFinder(String preferredBiomeFileExtension) {
        this.preferredBiomeFileExtension = preferredBiomeFileExtension;
    }

    public Map<String, BiomeConfigStub> findBiomes(WorldConfig worldConfig, int worldHeightScale, Collection<File> directories, Collection<BiomeLoadInstruction> biomesToLoad) {
        HashMap<String, BiomeConfigStub> biomeConfigsStore = new HashMap<String, BiomeConfigStub>();
        HashMap<String, BiomeLoadInstruction> remainingBiomes = new HashMap<String, BiomeLoadInstruction>();
        for (BiomeLoadInstruction biome : biomesToLoad) {
            remainingBiomes.put(biome.getBiomeName(), biome);
        }
        for (File directory : directories) {
            if (!directory.exists()) continue;
            this.loadBiomesFromDirectory(worldConfig, worldHeightScale, biomeConfigsStore, directory, remainingBiomes);
        }
        File preferredDirectory = directories.iterator().next();
        for (BiomeLoadInstruction localBiome : remainingBiomes.values()) {
            File newConfigFile = new File(preferredDirectory, this.toFileName(localBiome));
            SimpleSettingsMap settings = new SimpleSettingsMap(localBiome.getBiomeName(), true);
            BiomeConfigStub biomeConfigStub = new BiomeConfigStub(settings, newConfigFile, localBiome);
            biomeConfigsStore.put(localBiome.getBiomeName(), biomeConfigStub);
        }
        return biomeConfigsStore;
    }

    private void loadBiomesFromDirectory(WorldConfig worldConfig, int worldHeightScale, Map<String, BiomeConfigStub> biomeConfigsStore, File directory, Map<String, BiomeLoadInstruction> remainingBiomes) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.loadBiomesFromDirectory(worldConfig, worldHeightScale, biomeConfigsStore, file, remainingBiomes);
                continue;
            }
            String biomeName = this.toBiomeName(file);
            if (biomeName == null) continue;
            BiomeLoadInstruction preloadedBiome = new BiomeLoadInstruction(biomeName, new StandardBiomeTemplate(worldHeightScale));
            File preloadedRenamedFile = this.renameBiomeFile(file, preloadedBiome);
            SettingsMap preloadedSettings = FileSettingsReader.read(biomeName, preloadedRenamedFile);
            BiomeConfigStub preloadedBiomeConfigStub = new BiomeConfigStub(preloadedSettings, file, preloadedBiome);
            BiomeLoadInstruction biome = remainingBiomes.get(biomeName);
            if (biome == null) {
                Collection<BiomeLoadInstruction> defaultBiomes;
                String replaceToBiomeName = preloadedBiomeConfigStub.settings.getSetting(BiomeStandardValues.REPLACE_TO_BIOME_NAME, "");
                if (replaceToBiomeName != null && replaceToBiomeName.length() > 0) {
                    defaultBiomes = OTG.getEngine().getDefaultBiomes();
                    for (BiomeLoadInstruction defaultBiome : defaultBiomes) {
                        if (!biomeName.equals(defaultBiome.getBiomeName()) || !replaceToBiomeName.equals(BiomeRegistryNames.getRegistryNameForDefaultBiome(defaultBiome.getBiomeName()))) continue;
                        biome = new BiomeLoadInstruction(defaultBiome.getBiomeName(), defaultBiome.getBiomeTemplate());
                        break;
                    }
                } else if (!worldConfig.worldBiomes.contains(biomeName)) {
                    defaultBiomes = OTG.getEngine().getDefaultBiomes();
                    for (BiomeLoadInstruction defaultBiome : defaultBiomes) {
                        if (!biomeName.equals(defaultBiome.getBiomeName())) continue;
                        biome = new BiomeLoadInstruction(defaultBiome.getBiomeName(), defaultBiome.getBiomeTemplate());
                        break;
                    }
                }
            }
            if (biome == null) {
                biome = new BiomeLoadInstruction(biomeName, new StandardBiomeTemplate(worldHeightScale));
            }
            File renamedFile = this.renameBiomeFile(file, biome);
            SettingsMap settings = FileSettingsReader.read(biomeName, renamedFile);
            BiomeConfigStub biomeConfigStub = new BiomeConfigStub(settings, file, biome);
            biomeConfigsStore.put(biomeName, biomeConfigStub);
            if (!remainingBiomes.containsKey(biome.getBiomeName())) continue;
            remainingBiomes.remove(biome.getBiomeName());
        }
    }

    private File renameBiomeFile(File toRename, BiomeLoadInstruction biome) {
        String preferredFileName = this.toFileName(biome);
        if (toRename.getName().equalsIgnoreCase(preferredFileName)) {
            return toRename;
        }
        File newFile = new File(toRename.getParentFile(), preferredFileName);
        if (toRename.renameTo(newFile)) {
            return newFile;
        }
        OTG.log(LogMarker.ERROR, "Failed to rename biome file {} to {}", toRename.getAbsolutePath(), newFile.getAbsolutePath());
        return toRename;
    }

    private String toBiomeName(File file) {
        String fileName = file.getName();
        for (String extension : BiomeStandardValues.BiomeConfigExtensions) {
            if (!fileName.endsWith(extension)) continue;
            String biomeName = fileName.substring(0, fileName.lastIndexOf(extension));
            return biomeName;
        }
        return null;
    }

    private String toFileName(BiomeLoadInstruction biome) {
        return biome.getBiomeName() + this.preferredBiomeFileExtension;
    }

    public final class BiomeConfigStub {
        private final SettingsMap settings;
        private final File file;
        private final BiomeLoadInstruction loadInstructions;
        public boolean biomeExtendsProcessed = false;
        public boolean inheritMobsBiomeNameProcessed = false;
        List<WeightedMobSpawnGroup> spawnMonsters = new ArrayList<WeightedMobSpawnGroup>();
        List<WeightedMobSpawnGroup> spawnCreatures = new ArrayList<WeightedMobSpawnGroup>();
        List<WeightedMobSpawnGroup> spawnWaterCreatures = new ArrayList<WeightedMobSpawnGroup>();
        List<WeightedMobSpawnGroup> spawnAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();
        public List<WeightedMobSpawnGroup> spawnMonstersMerged = new ArrayList<WeightedMobSpawnGroup>();
        public List<WeightedMobSpawnGroup> spawnCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        public List<WeightedMobSpawnGroup> spawnWaterCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        public List<WeightedMobSpawnGroup> spawnAmbientCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();

        private BiomeConfigStub(SettingsMap settings, File file, BiomeLoadInstruction loadInstructions) {
            this.settings = settings;
            this.file = file;
            this.loadInstructions = loadInstructions;
            StandardBiomeTemplate defaultSettings = loadInstructions.getBiomeTemplate();
            if (settings.hasSetting(BiomeStandardValues.SPAWN_MONSTERS)) {
                this.spawnMonsters = settings.getSetting(BiomeStandardValues.SPAWN_MONSTERS, null);
                if (this.spawnMonsters == null) {
                    this.spawnMonsters = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnMonsters = defaultSettings.defaultMonsters;
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_CREATURES)) {
                this.spawnCreatures = settings.getSetting(BiomeStandardValues.SPAWN_CREATURES, new ArrayList());
                if (this.spawnCreatures == null) {
                    this.spawnCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnCreatures = defaultSettings.defaultCreatures;
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_WATER_CREATURES)) {
                this.spawnWaterCreatures = settings.getSetting(BiomeStandardValues.SPAWN_WATER_CREATURES, new ArrayList());
                if (this.spawnWaterCreatures == null) {
                    this.spawnWaterCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnWaterCreatures = defaultSettings.defaultWaterCreatures;
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_AMBIENT_CREATURES)) {
                this.spawnAmbientCreatures = settings.getSetting(BiomeStandardValues.SPAWN_AMBIENT_CREATURES, new ArrayList());
                if (this.spawnAmbientCreatures == null) {
                    this.spawnAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnAmbientCreatures = defaultSettings.defaultAmbientCreatures;
            }
            this.spawnMonstersMerged.addAll(this.spawnMonsters);
            this.spawnCreaturesMerged.addAll(this.spawnCreatures);
            this.spawnWaterCreaturesMerged.addAll(this.spawnWaterCreatures);
            this.spawnAmbientCreaturesMerged.addAll(this.spawnAmbientCreatures);
        }

        public void mergeMobs(BiomeConfigStub parent) {
            this.spawnMonstersMerged = this.mergeMobs(this.spawnMonstersMerged, parent.spawnMonstersMerged);
            this.spawnCreaturesMerged = this.mergeMobs(this.spawnCreaturesMerged, parent.spawnCreaturesMerged);
            this.spawnAmbientCreaturesMerged = this.mergeMobs(this.spawnAmbientCreaturesMerged, parent.spawnAmbientCreaturesMerged);
            this.spawnWaterCreaturesMerged = this.mergeMobs(this.spawnWaterCreaturesMerged, parent.spawnWaterCreaturesMerged);
            this.inheritMobsBiomeNameProcessed = true;
        }

        public List<WeightedMobSpawnGroup> mergeMobs(List<WeightedMobSpawnGroup> childSpawnableMonsterList, List<WeightedMobSpawnGroup> parentSpawnableMonsterList) {
            ArrayList<WeightedMobSpawnGroup> newSpawnableMobsList = new ArrayList<WeightedMobSpawnGroup>();
            newSpawnableMobsList.addAll(childSpawnableMonsterList);
            if (parentSpawnableMonsterList != null) {
                for (WeightedMobSpawnGroup weightedMobSpawnGroupParent : parentSpawnableMonsterList) {
                    boolean bFound = false;
                    for (WeightedMobSpawnGroup weightedMobSpawnGroupChild : childSpawnableMonsterList) {
                        if (!weightedMobSpawnGroupChild.getMob().toLowerCase().trim().equals(weightedMobSpawnGroupParent.getMob().toLowerCase().trim())) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    newSpawnableMobsList.add(weightedMobSpawnGroupParent);
                }
            }
            return newSpawnableMobsList;
        }

        public File getFile() {
            return this.file;
        }

        public BiomeLoadInstruction getLoadInstructions() {
            return this.loadInstructions;
        }

        public SettingsMap getSettings() {
            return this.settings;
        }

        public String getBiomeName() {
            return this.loadInstructions.getBiomeName();
        }
    }
}

