/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.common;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.util.helpers.BlockHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;

public abstract class LocalMaterialData {
    protected DefaultMaterial defaultMaterial;
    protected String rawEntry;
    protected boolean isBlank = false;
    protected boolean checkedFallbacks = false;
    protected boolean parsedDefaultMaterial = false;

    protected abstract LocalMaterialData ofDefaultMaterialPrivate(DefaultMaterial var1, int var2);

    public abstract String getName();

    public abstract int getBlockId();

    public abstract byte getBlockData();

    public abstract boolean isLiquid();

    public abstract boolean isSolid();

    public abstract boolean isEmptyOrAir();

    public abstract boolean isAir();

    public abstract boolean isEmpty();

    public abstract DefaultMaterial toDefaultMaterial();

    public abstract boolean canSnowFallOn();

    public abstract boolean isMaterial(DefaultMaterial var1);

    public abstract LocalMaterialData withBlockData(int var1);

    public abstract LocalMaterialData withDefaultBlockData();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public int hashCodeWithoutBlockData() {
        return this.getBlockId();
    }

    public String toString() {
        return this.getName();
    }

    public LocalMaterialData rotate() {
        return this.rotate(1);
    }

    public LocalMaterialData rotate(int rotateTimes) {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            int blockDataByte = 0;
            int newData = 0;
            for (int i = 0; i < rotateTimes; ++i) {
                blockDataByte = this.getBlockData();
                newData = BlockHelper.rotateData(defaultMaterial, blockDataByte);
            }
            if (newData != blockDataByte) {
                return this.ofDefaultMaterialPrivate(defaultMaterial, newData);
            }
        }
        return this;
    }

    public abstract LocalMaterialData parseForWorld(LocalWorld var1);

    public LocalMaterialData parseWithBiomeAndHeight(LocalWorld world, BiomeConfig biomeConfig, int y) {
        if (!biomeConfig.worldConfig.biomeConfigsHaveReplacement) {
            return this;
        }
        return biomeConfig.replacedBlocks.replaceBlock(y, this);
    }

    public abstract boolean canFall();

    public boolean isSmoothAreaAnchor(boolean allowWood, boolean ignoreWater) {
        return this.isSolid() || !ignoreWater && this.isLiquid() || (this.isMaterial(DefaultMaterial.ICE) || this.isMaterial(DefaultMaterial.PACKED_ICE) || this.isMaterial(DefaultMaterial.FROSTED_ICE)) && (allowWood || !this.isMaterial(DefaultMaterial.LOG) && !this.isMaterial(DefaultMaterial.LOG_2)) && !this.isMaterial(DefaultMaterial.WATER_LILY);
    }

    public abstract boolean hasData();
}

