/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.metrics;

import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.metrics.Graph;
import com.pg85.otg.bukkit.metrics.Metrics;
import com.pg85.otg.bukkit.metrics.Plotter;
import com.pg85.otg.util.helpers.MetricsHelper;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BukkitMetricsHelper
extends MetricsHelper {
    private final OTGPlugin plugin;

    public BukkitMetricsHelper(OTGPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                BukkitMetricsHelper.this.startMetrics();
            }
        }, 100L);
    }

    private void startMetrics() {
        this.calculateBiomeModes(this.plugin.worlds.values());
        try {
            Metrics metrics = new Metrics((Plugin)this.plugin);
            Graph usedBiomeModesGraph = metrics.createGraph("Biome modes used");
            usedBiomeModesGraph.addPlotter(new Plotter("Normal"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.normalMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Plotter("FromImage"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.fromImageMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Plotter("BeforeGroups"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.beforeGroupsBiomeMode;
                }
            });
            usedBiomeModesGraph.addPlotter(new Plotter("Custom / Unknown"){

                @Override
                public int getValue() {
                    return BukkitMetricsHelper.this.customMode;
                }
            });
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

