/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.materials;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockFalling;
import net.minecraft.server.v1_12_R1.Blocks;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.MinecraftKey;

public class BukkitMaterialData
extends LocalMaterialData {
    private int combinedBlockId;
    private boolean hasData;

    private BukkitMaterialData(int blockId, int blockData, boolean hasData) {
        this.combinedBlockId = blockId << 4 | blockData;
        this.hasData = hasData;
    }

    public BukkitMaterialData(String input, boolean hasData) {
        this.combinedBlockId = -1;
        this.rawEntry = input;
        this.hasData = hasData;
    }

    public static BukkitMaterialData getBlank() {
        BukkitMaterialData material = new BukkitMaterialData(null, false);
        material.isBlank = true;
        return material;
    }

    public static LocalMaterialData ofString(String input) throws InvalidConfigException {
        DefaultMaterial defaultMaterial;
        if (input.toLowerCase().equals("blank")) {
            return BukkitMaterialData.getBlank();
        }
        String newInput = input;
        Block block = Block.getByName((String)newInput);
        if (block != null) {
            if (block == Blocks.PORTAL || block == Blocks.DISPENSER || block == Blocks.ACACIA_STAIRS || block == Blocks.BIRCH_STAIRS || block == Blocks.BRICK_STAIRS || block == Blocks.DARK_OAK_STAIRS || block == Blocks.JUNGLE_STAIRS || block == Blocks.NETHER_BRICK_STAIRS || block == Blocks.OAK_STAIRS || block == Blocks.PURPUR_STAIRS || block == Blocks.QUARTZ_STAIRS || block == Blocks.RED_SANDSTONE_STAIRS || block == Blocks.SANDSTONE_STAIRS || block == Blocks.SPRUCE_STAIRS || block == Blocks.STONE_BRICK_STAIRS || block == Blocks.STONE_STAIRS) {
                newInput = input + ":0";
            } else {
                return BukkitMaterialData.ofMinecraftBlock(block, false);
            }
        }
        String blockName = newInput;
        int blockData = -1;
        int splitIndex = newInput.lastIndexOf(":");
        if (splitIndex == -1) {
            splitIndex = newInput.lastIndexOf(".");
        }
        if (splitIndex != -1) {
            blockName = newInput.substring(0, splitIndex);
            try {
                blockData = Integer.parseInt(newInput.substring(splitIndex + 1));
            }
            catch (NumberFormatException e) {
                blockName = newInput;
            }
        }
        if ((block = Block.getByName((String)blockName)) == null && (defaultMaterial = DefaultMaterial.getMaterial(blockName)) != null) {
            block = Block.getById((int)defaultMaterial.id);
            if (blockData == -1 && (block == Blocks.PORTAL || block == Blocks.DISPENSER || block == Blocks.ACACIA_STAIRS || block == Blocks.BIRCH_STAIRS || block == Blocks.BRICK_STAIRS || block == Blocks.DARK_OAK_STAIRS || block == Blocks.JUNGLE_STAIRS || block == Blocks.NETHER_BRICK_STAIRS || block == Blocks.OAK_STAIRS || block == Blocks.PURPUR_STAIRS || block == Blocks.QUARTZ_STAIRS || block == Blocks.RED_SANDSTONE_STAIRS || block == Blocks.SANDSTONE_STAIRS || block == Blocks.SPRUCE_STAIRS || block == Blocks.STONE_BRICK_STAIRS || block == Blocks.STONE_STAIRS)) {
                blockData = 0;
            }
        }
        if (block != null) {
            if (blockData == -1) {
                return BukkitMaterialData.ofMinecraftBlock(block, false);
            }
            try {
                return BukkitMaterialData.ofMinecraftBlockData(block.fromLegacyData(blockData));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InvalidConfigException("Illegal meta data for the block type, cannot use " + newInput);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Illegal block data for the block type, cannot use " + newInput);
            }
        }
        return new BukkitMaterialData(newInput, false);
    }

    public static BukkitMaterialData ofIds(int id, int data) {
        return new BukkitMaterialData(id, data, true);
    }

    public static BukkitMaterialData ofDefaultMaterial(DefaultMaterial material, int data) {
        return BukkitMaterialData.ofIds(material.id, data);
    }

    @Override
    protected BukkitMaterialData ofDefaultMaterialPrivate(DefaultMaterial material, int data) {
        return BukkitMaterialData.ofDefaultMaterial(material, data);
    }

    public static BukkitMaterialData ofMinecraftBlock(Block block, boolean hasData) {
        BukkitMaterialData material = BukkitMaterialData.ofIds(Block.getId((Block)block), block.toLegacyData(block.getBlockData()));
        material.hasData = hasData;
        return material;
    }

    public static BukkitMaterialData ofBukkitBlock(org.bukkit.block.Block block) {
        return BukkitMaterialData.ofIds(block.getType().getId(), block.getData());
    }

    public static BukkitMaterialData ofMinecraftBlockData(IBlockData blockData) {
        Block block = blockData.getBlock();
        return new BukkitMaterialData(Block.getId((Block)block), block.toLegacyData(blockData), true);
    }

    @Override
    public LocalMaterialData withBlockData(int i) {
        if (i == this.getBlockData()) {
            return this;
        }
        Block block = Block.getById((int)this.getBlockId());
        return BukkitMaterialData.ofMinecraftBlockData(block.fromLegacyData(i));
    }

    @Override
    public LocalMaterialData withDefaultBlockData() {
        Block block = Block.getById((int)this.getBlockId());
        byte defaultData = (byte)block.toLegacyData(block.getBlockData());
        return this.withBlockData(defaultData);
    }

    @Override
    public byte getBlockData() {
        return (byte)(this.combinedBlockId & 0xF);
    }

    @Override
    public int getBlockId() {
        return this.combinedBlockId >> 4;
    }

    @Override
    public String getName() {
        if (this.isBlank) {
            return "BLANK";
        }
        if (this.combinedBlockId == -1) {
            if (this.rawEntry != null) {
                return this.rawEntry;
            }
            return "Unknown";
        }
        Block block = Block.getById((int)this.getBlockId());
        byte data = this.getBlockData();
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial == null) {
            boolean nonDefaultData;
            boolean bl = nonDefaultData = block.toLegacyData(block.getBlockData()) != data;
            if (nonDefaultData) {
                return Block.REGISTRY.b((Object)block) + (!this.hasData ? "" : ":" + data);
            }
            return ((MinecraftKey)Block.REGISTRY.b((Object)block)).toString();
        }
        return defaultMaterial.name() + (!this.hasData ? "" : ":" + data);
    }

    public IBlockData internalBlock() {
        return Block.getById((int)this.getBlockId()).fromLegacyData((int)this.getBlockData());
    }

    @Override
    public boolean isMaterial(DefaultMaterial material) {
        return material.id == this.getBlockId();
    }

    @Override
    public boolean isLiquid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            return defaultMaterial.isLiquid();
        }
        return this.internalBlock().getMaterial().isLiquid();
    }

    @Override
    public boolean isSolid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            return defaultMaterial.isSolid();
        }
        return this.internalBlock().getMaterial().isSolid();
    }

    @Override
    public boolean isEmptyOrAir() {
        return this.combinedBlockId == -1 || this.combinedBlockId == 0;
    }

    @Override
    public boolean isAir() {
        return this.combinedBlockId == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.combinedBlockId == -1;
    }

    @Override
    public boolean canFall() {
        return Block.getById((int)this.getBlockId()) instanceof BlockFalling;
    }

    @Override
    public boolean canSnowFallOn() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            return defaultMaterial.canSnowFallOn();
        }
        return this.internalBlock().getMaterial().isSolid();
    }

    @Override
    public LocalMaterialData parseForWorld(LocalWorld world) {
        if (!this.checkedFallbacks && this.isEmpty() && this.rawEntry != null) {
            int newId;
            this.checkedFallbacks = true;
            try {
                newId = ((BukkitMaterialData)world.getConfigs().getWorldConfig().parseFallback((String)this.rawEntry)).combinedBlockId;
            }
            catch (NullPointerException e) {
                OTG.log(LogMarker.ERROR, "Could not parse fallback for " + this.rawEntry, new Object[0]);
                throw e;
            }
            if (newId != this.combinedBlockId) {
                this.combinedBlockId = newId;
                this.defaultMaterial = null;
            }
        }
        return this;
    }

    @Override
    public DefaultMaterial toDefaultMaterial() {
        if (this.defaultMaterial == null && !this.parsedDefaultMaterial) {
            this.parsedDefaultMaterial = true;
            this.defaultMaterial = this.combinedBlockId == -1 ? null : DefaultMaterial.getMaterial(this.getBlockId());
        }
        return this.defaultMaterial;
    }

    @Override
    public int hashCode() {
        return 65535 + this.combinedBlockId;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BukkitMaterialData)) {
            return false;
        }
        BukkitMaterialData other = (BukkitMaterialData)obj;
        if (this.isBlank != other.isBlank) {
            return false;
        }
        if (this.isBlank) {
            return true;
        }
        return this.combinedBlockId == other.combinedBlockId;
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }
}

