/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.biomes;

import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.materials.BukkitMaterialData;
import com.pg85.otg.bukkit.util.EnumHelper;
import com.pg85.otg.bukkit.util.MobSpawnGroupHelper;
import com.pg85.otg.bukkit.world.WorldHelper;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.settings.WeightedMobSpawnGroup;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import org.bukkit.block.Biome;

public class OTGBiomeBase
extends BiomeBase {
    private static final int MAX_OTG_BIOME_ID = 4095;
    public int otgBiomeId;
    private int savedId;

    private OTGBiomeBase(BiomeConfig biomeConfig) {
        super((BiomeBase.a)new BiomeBase_a(biomeConfig.getName(), biomeConfig));
        if (this.getHumidity() != biomeConfig.biomeWetness) {
            throw new AssertionError((Object)"Biome temperature mismatch");
        }
        this.q = ((BukkitMaterialData)biomeConfig.getDefaultSurfaceBlock()).internalBlock();
        this.r = ((BukkitMaterialData)biomeConfig.getDefaultGroundBlock()).internalBlock();
        this.addMobs(this.t, biomeConfig.spawnMonstersMerged);
        this.addMobs(this.u, biomeConfig.spawnCreaturesMerged);
        this.addMobs(this.v, biomeConfig.spawnWaterCreaturesMerged);
        this.addMobs(this.w, biomeConfig.spawnAmbientCreaturesMerged);
    }

    private void addMobs(List<BiomeBase.BiomeMeta> internalList, List<WeightedMobSpawnGroup> configList) {
        internalList.clear();
        internalList.addAll(MobSpawnGroupHelper.toMinecraftlist(configList));
    }

    static OTGBiomeBase createInstance(BiomeConfig biomeConfig, BiomeIds biomeIds, String worldName, boolean isReload) {
        if (BiomeBase.getBiome((int)4095) == null) {
            BiomeBase.REGISTRY_ID.a(4095, (Object)new MinecraftKey("OpenTerrainGenerator", "null"), (Object)new OTGBiomeBase(biomeConfig));
        }
        String biomeNameWithoutSpaces = worldName.toLowerCase() + "_" + StringHelper.toComputerFriendlyName(biomeConfig.getName());
        MinecraftKey biomeKey = new MinecraftKey("openterraingenerator", biomeNameWithoutSpaces);
        OTGBiomeBase customBiome = new OTGBiomeBase(biomeConfig);
        if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.length() > 0) {
            customBiome.otgBiomeId = biomeIds.getOTGBiomeId();
            customBiome.savedId = biomeIds.getSavedId();
            BiomeBase existingBiome = BiomeBase.getBiome((int)customBiome.savedId);
            BiomeBase.REGISTRY_ID.a(customBiome.savedId, (Object)biomeKey, (Object)customBiome);
            if (existingBiome != null) {
                MinecraftKey existingBiomeKey = (MinecraftKey)BiomeBase.REGISTRY_ID.b((Object)existingBiome);
                BiomeBase.REGISTRY_ID.a(customBiome.savedId, (Object)existingBiomeKey, (Object)existingBiome);
            }
        } else if (biomeIds.getSavedId() > -1) {
            BiomeBase biomeAtId = (BiomeBase)BiomeBase.REGISTRY_ID.getId(biomeIds.getSavedId());
            if (biomeAtId != null && !isReload) {
                throw new RuntimeException("Tried to register biome " + biomeKey.toString() + " to a id " + biomeIds.getSavedId() + " but it is occupied by biome: " + biomeAtId.toString() + ". This can happen when changing mods setup for existing worlds, which causes the biome registry to change. This can also happen when migrating a world from OTG v6 or lower to OTG v8 or higher, if the world had biome conflicts in v6.");
            }
            customBiome.otgBiomeId = biomeIds.getOTGBiomeId();
            customBiome.savedId = biomeIds.getSavedId();
            BiomeBase.REGISTRY_ID.a(customBiome.savedId, (Object)biomeKey, (Object)customBiome);
        } else {
            int newId = 0;
            while (BiomeBase.REGISTRY_ID.getId(newId) != null) {
                if (newId == 4095) {
                    throw new RuntimeException("Biome could not be registered, no free biome id's!");
                }
                ++newId;
            }
            biomeIds.setSavedId(newId);
            customBiome.otgBiomeId = biomeIds.getOTGBiomeId();
            customBiome.savedId = newId;
            BiomeBase.REGISTRY_ID.a(customBiome.savedId, (Object)biomeKey, (Object)customBiome);
        }
        OTG.log(LogMarker.DEBUG, "{}, {}, {}, {}", biomeConfig.getName(), biomeIds.getSavedId(), biomeIds.getOTGBiomeId(), biomeKey.toString());
        try {
            Biome.valueOf((String)biomeNameWithoutSpaces.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            EnumHelper.addEnum(Biome.class, biomeNameWithoutSpaces.toUpperCase(), new Class[0], new Object[0]);
        }
        int registeredSavedId = WorldHelper.getSavedId(customBiome);
        if (registeredSavedId != customBiome.savedId) {
            throw new AssertionError((Object)("Biome " + biomeConfig.getName() + " is not properly registered: got id " + registeredSavedId + ", should be " + customBiome.savedId));
        }
        OTGBiomeBase.checkRegistry();
        return customBiome;
    }

    private static void checkRegistry() {
        for (int i = 0; i < 256; ++i) {
            BiomeBase biome = OTGBiomeBase.getBiome((int)i);
            if (biome != null && biome instanceof OTGBiomeBase && ((OTGBiomeBase)biome).savedId != i) {
                throw new AssertionError((Object)("Biome ID #" + i + " returns custom biome #" + ((OTGBiomeBase)biome).savedId + " instead of its own."));
            }
        }
    }

    private static class BiomeBase_a
    extends BiomeBase.a {
        public BiomeBase_a(String name, BiomeConfig biomeConfig) {
            super(name);
            float adjustedTemperature = biomeConfig.biomeTemperature;
            if ((double)adjustedTemperature >= 0.1 && (double)adjustedTemperature <= 0.2) {
                adjustedTemperature = (double)adjustedTemperature >= 1.5 ? 0.2f : 0.1f;
            }
            this.c(biomeConfig.biomeHeight);
            this.d(biomeConfig.biomeVolatility);
            this.a(adjustedTemperature);
            this.b(biomeConfig.biomeWetness);
            if ((double)biomeConfig.biomeWetness <= 1.0E-4) {
                this.a();
            }
            if (biomeConfig.biomeTemperature <= 0.15f) {
                this.b();
            }
        }
    }
}

