/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.client.renderer.entity;

import goblinbob.mobends.core.client.model.ModelPartTransform;
import goblinbob.mobends.core.math.Quaternion;
import goblinbob.mobends.core.math.vector.IVec3f;
import goblinbob.mobends.core.math.vector.Vec3f;
import goblinbob.mobends.core.util.GUtil;
import goblinbob.mobends.core.util.IColorRead;
import goblinbob.mobends.standard.data.BipedEntityData;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumHandSide;
import org.lwjgl.opengl.GL11;

public class SwordTrail {
    protected final Supplier<IColorRead> baseColor;
    protected LinkedList<TrailPart> trailPartList = new LinkedList();

    public SwordTrail(Supplier<IColorRead> baseColor) {
        this.baseColor = baseColor;
    }

    public void reset() {
        this.trailPartList.clear();
    }

    public void render() {
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GL11.glHint((int)3152, (int)4354);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179094_E();
        GlStateManager.func_187447_r((int)7);
        Iterator it = this.trailPartList.iterator();
        boolean first = true;
        while (it.hasNext()) {
            TrailPart part = (TrailPart)it.next();
            part.draw(first, !it.hasNext());
            first = false;
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179129_p();
        GlStateManager.func_179145_e();
    }

    public void add(BipedEntityData<?> entityData, float velocityX, float velocityY, float velocityZ) {
        Object entity = entityData.getEntity();
        EnumHandSide primaryHand = entity.func_184591_cq();
        TrailPart newPart = new TrailPart(primaryHand, this.baseColor.get(), velocityX, velocityY, velocityZ);
        newPart.body.syncUp(entityData.body);
        if (primaryHand == EnumHandSide.RIGHT) {
            newPart.arm.syncUp(entityData.rightArm);
            newPart.foreArm.syncUp(entityData.rightForeArm);
            newPart.itemRotation.set(entityData.renderRightItemRotation.getSmooth());
        } else {
            newPart.arm.syncUp(entityData.leftArm);
            newPart.foreArm.syncUp(entityData.leftForeArm);
            newPart.itemRotation.set(entityData.renderLeftItemRotation.getSmooth());
        }
        newPart.renderOffset.set(entityData.globalOffset.getX(), entityData.globalOffset.getY(), entityData.globalOffset.getZ());
        newPart.renderRotation.set(entityData.renderRotation.getSmooth());
        newPart.renderRotation.negate();
        this.trailPartList.add(newPart);
    }

    public void add(BipedEntityData<?> entityData) {
        this.add(entityData, 0.0f, 0.0f, 0.0f);
    }

    public void update(float ticksPerFrame) {
        Iterator it = this.trailPartList.iterator();
        while (it.hasNext()) {
            TrailPart trailPart = (TrailPart)it.next();
            trailPart.update(ticksPerFrame);
            if (!(trailPart.ticksExisted > 20.0f)) continue;
            it.remove();
        }
    }

    protected static class TrailPart {
        protected EnumHandSide primaryHand;
        protected IColorRead baseColor;
        protected ModelPartTransform body;
        protected ModelPartTransform arm;
        protected ModelPartTransform foreArm;
        protected Quaternion renderRotation = new Quaternion();
        protected Vec3f renderOffset = new Vec3f();
        protected Quaternion itemRotation = new Quaternion();
        protected Vec3f position = new Vec3f();
        protected float velocityX;
        protected float velocityY;
        protected float velocityZ;
        protected float ticksExisted = 0.0f;

        public TrailPart(EnumHandSide primaryHand, IColorRead baseColor, float velocityX, float velocityY, float velocityZ) {
            this.body = new ModelPartTransform();
            this.arm = new ModelPartTransform();
            this.foreArm = new ModelPartTransform();
            this.primaryHand = primaryHand;
            this.baseColor = baseColor;
            this.velocityX = velocityX;
            this.velocityY = velocityY;
            this.velocityZ = velocityZ;
        }

        public void update(float ticksPerFrame) {
            this.ticksExisted += ticksPerFrame;
            this.position.x += this.velocityX * ticksPerFrame;
            this.position.y += this.velocityY * ticksPerFrame;
            this.position.z += this.velocityZ * ticksPerFrame;
        }

        public void draw(boolean first, boolean last) {
            float alpha = this.ticksExisted / 5.0f;
            alpha = Math.min(alpha, 1.0f);
            alpha = 1.0f - alpha;
            IVec3f[] points = new Vec3f[]{new Vec3f(0.0f, 0.0f, -8.0f + 8.0f * alpha), new Vec3f(0.0f, 0.0f, -8.0f - 8.0f * alpha)};
            GUtil.translate(points, 0.0f, 0.0f, 16.0f);
            GUtil.rotate(points, this.itemRotation);
            GUtil.translate(points, this.primaryHand == EnumHandSide.LEFT ? 1.0f : -1.0f, -6.0f, 0.0f);
            GUtil.rotate(points, this.foreArm.rotation.getSmooth());
            GUtil.translate(points, 0.0f, -4.0f, 0.0f);
            GUtil.rotate(points, this.arm.rotation.getSmooth());
            GUtil.translate(points, this.arm.position.x, 10.0f, 0.0f);
            GUtil.rotate(points, this.body.rotation.getSmooth());
            GUtil.translate(points, 0.0f, 12.0f, 0.0f);
            GUtil.rotate(points, this.renderRotation);
            GUtil.translate(points, this.renderOffset.x, this.renderOffset.y, this.renderOffset.z);
            for (IVec3f point : points) {
                point.add(this.position);
            }
            GlStateManager.func_179131_c((float)this.baseColor.getR(), (float)this.baseColor.getG(), (float)this.baseColor.getB(), (float)alpha);
            if (!first) {
                GlStateManager.func_187435_e((float)((Vec3f)points[1]).x, (float)((Vec3f)points[1]).y, (float)((Vec3f)points[1]).z);
                GlStateManager.func_187435_e((float)((Vec3f)points[0]).x, (float)((Vec3f)points[0]).y, (float)((Vec3f)points[0]).z);
            }
            GlStateManager.func_187435_e((float)((Vec3f)points[0]).x, (float)((Vec3f)points[0]).y, (float)((Vec3f)points[0]).z);
            GlStateManager.func_187435_e((float)((Vec3f)points[1]).x, (float)((Vec3f)points[1]).y, (float)((Vec3f)points[1]).z);
            if (last) {
                GlStateManager.func_187435_e((float)((Vec3f)points[1]).x, (float)((Vec3f)points[1]).y, (float)((Vec3f)points[1]).z);
                GlStateManager.func_187435_e((float)((Vec3f)points[0]).x, (float)((Vec3f)points[0]).y, (float)((Vec3f)points[0]).z);
            }
        }
    }
}

