/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.math;

import goblinbob.mobends.core.math.Quaternion;
import goblinbob.mobends.core.math.matrix.IMat4x4d;
import goblinbob.mobends.core.math.vector.IVec3f;
import goblinbob.mobends.core.math.vector.Vec3f;
import goblinbob.mobends.core.math.vector.VectorUtils;
import java.nio.FloatBuffer;

public class QuaternionUtils {
    public static final float PI = (float)Math.PI;

    public static void multiply(IVec3f vector, Quaternion quat, IVec3f dest) {
        Vec3f u = new Vec3f(-quat.x, quat.y, quat.z);
        Vec3f crossResult = new Vec3f();
        float s = -quat.w;
        float x = vector.getX();
        float y = vector.getY();
        float z = vector.getZ();
        float dotUU = VectorUtils.dot(u, u);
        float dotUV = VectorUtils.dot(u, vector);
        VectorUtils.cross(u, vector, crossResult);
        dest.set(u);
        dest.scale(2.0f * dotUV);
        dest.add(x * (s * s - dotUU), y * (s * s - dotUU), z * (s * s - dotUU));
        crossResult.scale(2.0f * s);
        dest.add(crossResult);
    }

    public static Quaternion rotate(Quaternion quat, float angle, float x, float y, float z, Quaternion dest) {
        dest.set(quat);
        dest.rotate(x, y, z, angle / 180.0f * (float)Math.PI);
        return dest;
    }

    public static Quaternion rotate(Quaternion quat, float angle, float x, float y, float z) {
        quat.rotate(x, y, z, angle / 180.0f * (float)Math.PI);
        return quat;
    }

    public static FloatBuffer quatToGlMatrix(FloatBuffer buffer, Quaternion quaternionIn) {
        buffer.clear();
        float f = quaternionIn.x * quaternionIn.x;
        float f1 = quaternionIn.x * quaternionIn.y;
        float f2 = quaternionIn.x * quaternionIn.z;
        float f3 = quaternionIn.x * quaternionIn.w;
        float f4 = quaternionIn.y * quaternionIn.y;
        float f5 = quaternionIn.y * quaternionIn.z;
        float f6 = quaternionIn.y * quaternionIn.w;
        float f7 = quaternionIn.z * quaternionIn.z;
        float f8 = quaternionIn.z * quaternionIn.w;
        buffer.put(1.0f - 2.0f * (f4 + f7));
        buffer.put(2.0f * (f1 + f8));
        buffer.put(2.0f * (f2 - f6));
        buffer.put(0.0f);
        buffer.put(2.0f * (f1 - f8));
        buffer.put(1.0f - 2.0f * (f + f7));
        buffer.put(2.0f * (f5 + f3));
        buffer.put(0.0f);
        buffer.put(2.0f * (f2 + f6));
        buffer.put(2.0f * (f5 - f3));
        buffer.put(1.0f - 2.0f * (f + f4));
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(0.0f);
        buffer.put(1.0f);
        buffer.rewind();
        return buffer;
    }

    public static void quatToMat(Quaternion quaternionIn, IMat4x4d dest) {
        float f = quaternionIn.x * quaternionIn.x;
        float f1 = quaternionIn.x * quaternionIn.y;
        float f2 = quaternionIn.x * quaternionIn.z;
        float f3 = quaternionIn.x * quaternionIn.w;
        float f4 = quaternionIn.y * quaternionIn.y;
        float f5 = quaternionIn.y * quaternionIn.z;
        float f6 = quaternionIn.y * quaternionIn.w;
        float f7 = quaternionIn.z * quaternionIn.z;
        float f8 = quaternionIn.z * quaternionIn.w;
        dest.setFields(1.0f - 2.0f * (f4 + f7), 2.0f * (f1 + f8), 2.0f * (f2 - f6), 0.0, 2.0f * (f1 - f8), 1.0f - 2.0f * (f + f7), 2.0f * (f5 + f3), 0.0, 2.0f * (f2 + f6), 2.0f * (f5 - f3), 1.0f - 2.0f * (f + f4), 0.0, 0.0, 0.0, 0.0, 1.0);
    }
}

