/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.util;

import java.util.Locale;
import java.util.Objects;
import joptsimple.internal.Strings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishCaughtData;
import net.theawesomegem.fishingmadebetter.common.data.FishData;

public class FMB_BetterFishUtil {
    public static String getFishCustomLangKey(ItemStack itemStack) {
        if (!itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("FishId")) {
            return null;
        }
        return String.format("%s%s:%d%s", "item.fmb.", itemStack.func_77973_b().getRegistryName().toString(), itemStack.func_77960_j(), ".name");
    }

    public static String fishIdToCustomLangKey(String fishId) {
        if (fishId == null) {
            return null;
        }
        if (fishId.isEmpty()) {
            return fishId;
        }
        String unformattedFishId = fishId.startsWith(TextFormatting.RESET.toString()) ? fishId.substring(2) : fishId;
        FishData fishData = (FishData)CustomConfigurationHandler.fishDataMap.get(unformattedFishId);
        if (fishData == null) {
            return unformattedFishId;
        }
        return String.format("%s%s:%d%s", "item.fmb.", fishData.itemId, fishData.itemMetaData, ".name");
    }

    public static String fishIdToRecipe(String fishId) {
        if (Strings.isNullOrEmpty((String)fishId)) {
            return null;
        }
        FishData fishData = (FishData)CustomConfigurationHandler.fishDataMap.get(fishId);
        if (fishData == null) {
            return null;
        }
        return fishId.toLowerCase(Locale.ENGLISH).replace(" ", "_") + "_requirements";
    }

    public static ItemStack fishIdToItemStack(String fishId) {
        if (Strings.isNullOrEmpty((String)fishId)) {
            return null;
        }
        FishData fishData = (FishData)CustomConfigurationHandler.fishDataMap.get(fishId);
        if (fishData == null) {
            return null;
        }
        return new ItemStack(Objects.requireNonNull(Item.func_111206_d((String)fishData.itemId)), 1, fishData.itemMetaData);
    }

    public static boolean isFish(String baitName) {
        if (baitName == null) {
            return false;
        }
        return baitName.equals("aquaculture:fish") || baitName.equals("advanced-fishing:fish") || baitName.equals("minecraft:fish");
    }

    public static boolean isFish(ResourceLocation baitResource) {
        if (baitResource == null) {
            return false;
        }
        return FMB_BetterFishUtil.isFish(baitResource.toString());
    }

    public static String getBaitLangKey(String baitId, int baitMetaData) {
        if (baitId == null || baitId.isEmpty()) {
            return null;
        }
        Item item = Item.func_111206_d((String)baitId);
        if (item == null) {
            return null;
        }
        if (FMB_BetterFishUtil.isFish(baitId)) {
            return String.format("%s%s:%d%s", "item.fmb.", baitId, baitMetaData, ".name");
        }
        ItemStack itemStack = new ItemStack(item, 1, baitMetaData);
        if (itemStack.func_190926_b()) {
            return null;
        }
        return itemStack.func_77973_b().func_77657_g(itemStack) + ".name";
    }

    public static String getFishDataUnlocalizedName(FishData fishData) {
        return String.format("%s%s:%d%s", "item.fmb.", fishData.itemId, fishData.itemMetaData, ".name");
    }

    public static String getFishDataUnlocalizedDesc(FishData fishData) {
        return String.format("%s%s:%d%s", "item.fmb.", fishData.itemId, fishData.itemMetaData, ".desc");
    }

    public static String getFishCaughtDataUnlocalizedName(FishCaughtData fishData) {
        return String.format("%s%s:%d%s", "item.fmb.", fishData.itemId, fishData.itemMetaData, ".name");
    }
}

