/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.entity.Slot;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.util.Color;
import greymerk.roguelike.monster.Mob;
import greymerk.roguelike.monster.profiles.ProfileZombieVillager;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import kameib.localizator.handlers.ForgeConfigHandler;
import kameib.localizator.util.RLD_ExtraColor;
import kameib.localizator.util.RLD_MobUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfileZombieVillager.class})
public abstract class ProfileZombieVillagerMixin {
    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="TAIL")}, remap=false)
    private void RLD_ProfileZombieVillager_apply_equipNovelty(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        if (!mob.isChild()) {
            double d = random.nextDouble();
            double d2 = ForgeConfigHandler.serverConfig.rldCustomSpawnerZombieVillager ? 0.005 : 0.05;
            if (d < d2) {
                this.localizator$profileAvidya(mob, level, difficulty, random);
                return;
            }
            double d3 = random.nextDouble();
            double d4 = ForgeConfigHandler.serverConfig.rldCustomSpawnerZombieVillager ? 0.0125 : 0.25;
            if (d3 < d4) {
                mob.setChild(true);
            }
        }
        if (mob.isChild()) {
            if (level == 0) {
                this.localizator$profileFourles(mob, level, difficulty, random);
                return;
            }
            if (level == 1 && random.nextInt(2) == 0) {
                this.localizator$profileGinger(mob, level, difficulty, random);
                return;
            }
            if (level == 2 && random.nextInt(2) == 0) {
                this.localizator$profileCleo(mob, level, difficulty, random);
                return;
            }
            if (level == 4 && random.nextInt(2) == 0) {
                this.localizator$profileNotch(mob, level, difficulty, random);
            }
        }
    }

    @Unique
    private void localizator$profileAvidya(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.avidyasWhiteRussian());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.NEW_YORK_PINK).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.MONGOOSE).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.MONGOOSE).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.OLD_COPPER).asStack();
        mob.equip(Slot.HEAD, helmet);
    }

    @Unique
    private void localizator$profileFourles(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.fourlesDarkroastBeans());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(Color.COFFEE).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(Color.COFFEE).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(Color.COFFEE).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(Color.COFFEE).asStack();
        mob.equip(Slot.HEAD, helmet);
    }

    @Unique
    private void localizator$profileGinger(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.gingerSpiceChicken());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(Color.SUNNY_MOOD).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(Color.SUNNY_MOOD).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(Color.SUNNY_MOOD).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(Color.SUNNY_MOOD).asStack();
        mob.equip(Slot.HEAD, helmet);
    }

    @Unique
    private void localizator$profileCleo(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.cleophianDiggingFeesh());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.VAN_CLEEF).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.COD_GRAY_DARK).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.CASCADE).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.TIA_MARIA).asStack();
        mob.equip(Slot.HEAD, helmet);
    }

    @Unique
    private void localizator$profileNotch(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.notchsApple());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.BLACK).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.GRAY).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.SPICE).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.MY_PINK).asStack();
        mob.equip(Slot.HEAD, helmet);
    }
}

