/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.entity.Slot;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.RldItemStack;
import greymerk.roguelike.monster.Mob;
import greymerk.roguelike.monster.profiles.ProfileWitherSkeleton;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import kameib.localizator.util.RLD_ExtraColor;
import kameib.localizator.util.RLD_MobUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfileWitherSkeleton.class})
public abstract class ProfileWitherSkeletonMixin {
    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="TAIL")}, remap=false)
    private void RLD_ProfileWitherSkeleton_apply_equipNovelty(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        if (level == 3 && random.nextDouble() < 0.05) {
            this.localizator$profileEnikoEarring(mob, level, difficulty, random);
        } else if (level == 4 && random.nextDouble() < 0.005) {
            mob.equipMainhand(ItemNovelty.nullPointer());
            mob.equipOffhand(BlockType.AIR.asItem().asStack());
        }
    }

    @Unique
    private void localizator$profileEnikoEarring(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.enikosEarring());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.ENGLISH_WALNUT).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.ZEUS).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.ARMADILLO).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.TEMPTRESS).asStack();
        mob.equip(Slot.HEAD, helmet);
    }
}

