/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.entity.Slot;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.RldItemStack;
import greymerk.roguelike.monster.Mob;
import greymerk.roguelike.monster.profiles.ProfilePigZombie;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import kameib.localizator.util.RLD_ExtraColor;
import kameib.localizator.util.RLD_MobUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfilePigZombie.class})
public abstract class ProfilePigZombieMixin {
    @Unique
    private boolean localizator$babyZisteau;

    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="INVOKE", target="Lgreymerk/roguelike/monster/Mob;setMobType(Lcom/github/fnar/minecraft/block/spawner/MobType;)V", shift=At.Shift.AFTER, remap=false)}, remap=false)
    private void RLD_ProfilePigZombie_apply_setMobType_rollBaby(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        this.localizator$babyZisteau = false;
        double d = random.nextDouble();
        double d2 = level == 4 ? 0.005 : 0.0025;
        if (d < d2 && !mob.isChild()) {
            mob.setChild(true);
            this.localizator$babyZisteau = true;
        }
    }

    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="TAIL")}, remap=false)
    private void RLD_ProfilePigZombie_apply_equipNovelty(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        if (mob.isChild()) {
            if (this.localizator$babyZisteau) {
                this.localizator$profileZisteauSign(mob, level, difficulty, random);
            }
        } else {
            double d = random.nextDouble();
            double d2 = level == 4 ? 0.005 : 0.0025;
            if (d < d2) {
                this.localizator$profileManPants(mob, level, difficulty, random);
            }
        }
    }

    @Unique
    private void localizator$profileZisteauSign(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob).equipMainhand(ItemNovelty.zisteauSign());
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.FUSCOUS_GRAY).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.RIVER_BED).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.HEATHERED_GRAY).asStack();
        mob.equip(Slot.CHEST, chestplate);
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.HEATHERED_GRAY).asStack();
        mob.equip(Slot.HEAD, helmet);
    }

    @Unique
    private void localizator$profileManPants(Mob mob, int level, int difficulty, Random random) {
        RldItemStack mainHand = mob.getMainhand().asStack();
        RldItemStack offHand = mob.getOffhand().asStack();
        RLD_MobUtil.supponpon(mob).equipMainhand(mainHand);
        mob.equipOffhand(offHand);
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.FUSCOUS_GRAY).asStack();
        mob.equip(Slot.FEET, boots);
        mob.equip(Slot.LEGS, ItemNovelty.manPants());
        RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.HEATHERED_GRAY).asStack();
        mob.equip(Slot.HEAD, helmet);
    }
}

