/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.roguelike;

import com.github.fnar.minecraft.entity.Slot;
import com.github.fnar.minecraft.item.ArmourType;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.minecraft.item.ToolType;
import com.github.fnar.roguelike.Roguelike;
import greymerk.roguelike.monster.Mob;
import greymerk.roguelike.monster.profiles.ProfileBaby;
import greymerk.roguelike.treasure.loot.provider.ItemNovelty;
import java.util.Random;
import kameib.localizator.util.RLD_ExtraColor;
import kameib.localizator.util.RLD_MobUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfileBaby.class})
public abstract class ProfileBabyMixin {
    @Inject(method={"apply(Lgreymerk/roguelike/monster/Mob;IILjava/util/Random;)Lgreymerk/roguelike/monster/Mob;"}, at={@At(value="TAIL")}, remap=false)
    private void RLD_ProfileBaby_apply_equipNovelty(Mob mob, int level, int difficulty, Random random, CallbackInfoReturnable<Mob> cir) {
        if (random.nextDouble() < 0.25) {
            this.localizator$profileKameiB(mob, level, difficulty, random);
        }
    }

    @Unique
    private void localizator$profileKameiB(Mob mob, int level, int difficulty, Random random) {
        RLD_MobUtil.supponpon(mob);
        RldItemStack rod = ToolType.FISHING_ROD.asItem().plzEnchantAtLevel(level).asStack();
        mob.equipMainhand(rod);
        RldItemStack boots = ArmourType.BOOTS.asItem().leather().withColor(RLD_ExtraColor.FERN_GREEN).asStack();
        mob.equip(Slot.FEET, boots);
        RldItemStack leggings = ArmourType.LEGGINGS.asItem().leather().withColor(RLD_ExtraColor.MERCURY).asStack();
        mob.equip(Slot.LEGS, leggings);
        RldItemStack chestplate = ArmourType.CHESTPLATE.asItem().leather().withColor(RLD_ExtraColor.FRUIT_SALAD).asStack();
        mob.equip(Slot.CHEST, chestplate);
        try {
            mob.equip(Slot.HEAD, ItemNovelty.kameibShell());
        }
        catch (NoSuchMethodError e) {
            Roguelike.LOGGER.error("The KameiB RLD monster profile could not be loaded because Roguelike Dungeons -- Fnar's Edition version 2.4.5 or older is installed. Install 2.4.6 or newer to fix this error.");
            RldItemStack helmet = ArmourType.HELMET.asItem().leather().withColor(RLD_ExtraColor.FRUIT_SALAD).asStack();
            mob.equip(Slot.HEAD, helmet);
        }
    }
}

