/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.mixin.fishingmadebetter;

import java.util.ArrayList;
import java.util.Map;
import kameib.localizator.common.text.event.FishRequirementsClickEvent;
import kameib.localizator.util.FMB_BetterFishUtil;
import kameib.localizator.util.LocLoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.capability.world.PopulationData;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishCaughtData;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.event.FishingEventHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingEventHandler.class})
public abstract class FishingEventHandlerMixin {
    @Unique
    long localizator$myCurrentTime;
    @Unique
    FishData localizator$myFishData;
    @Unique
    PopulationData localizator$myPopulationData;

    @ModifyArg(method={"checkForFishInventory(Lnet/minecraft/entity/player/EntityPlayer;)V"}, at=@At(value="INVOKE", target="Lnet/theawesomegem/fishingmadebetter/util/ItemStackUtil;appendToolTip(Lnet/minecraft/item/ItemStack;Ljava/lang/Iterable;)Lnet/minecraft/item/ItemStack;", remap=false), index=0, remap=false)
    private ItemStack FMB_FishingEventHandler_checkForFishInventory_appendLocLore(ItemStack itemStack) {
        ArrayList<String> locLoreList = new ArrayList<String>();
        ArrayList<String> argList = new ArrayList<String>();
        locLoreList.add("tooltip.fishingmadebetter.fish.weight");
        argList.add(String.valueOf(BetterFishUtil.getFishWeight((ItemStack)itemStack)));
        if (((FishData)CustomConfigurationHandler.fishDataMap.get((Object)BetterFishUtil.getFishId((ItemStack)itemStack))).allowScaling) {
            if (BetterFishUtil.doesFishHasScale((ItemStack)itemStack)) {
                locLoreList.add("tooltip.fishingmadebetter.fish.scale_attached");
            } else {
                locLoreList.add("tooltip.fishingmadebetter.fish.scale_detached");
            }
            argList.add("");
        }
        locLoreList.add(BetterFishUtil.isDead((ItemStack)itemStack, (long)this.localizator$myCurrentTime) ? "tooltip.fishingmadebetter.fish.dead" : "tooltip.fishingmadebetter.fish.alive");
        argList.add("");
        return LocLoreUtil.appendLocLore(itemStack, locLoreList, argList);
    }

    @Redirect(method={"checkForFishInventory(Lnet/minecraft/entity/player/EntityPlayer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getTotalWorldTime()J", remap=true), remap=false)
    private long FMB_FishingEventHandler_checkForFishInventory_getCurrentTime(World world) {
        this.localizator$myCurrentTime = world.func_82737_E();
        return world.func_82737_E();
    }

    @Redirect(method={"getTrackingFish(Lnet/minecraft/entity/player/EntityPlayer;Lnet/theawesomegem/fishingmadebetter/common/item/tracker/ItemFishTracker;)V"}, at=@At(value="INVOKE", target="Lnet/theawesomegem/fishingmadebetter/common/capability/world/PopulationData;getFishType()Ljava/lang/String;", remap=false), remap=false)
    private String FMB_FishingMadeBetter_getTrackingFish_getPopulationData(PopulationData populationData) {
        this.localizator$myPopulationData = populationData;
        return populationData.getFishType();
    }

    @Redirect(method={"getTrackingFish(Lnet/minecraft/entity/player/EntityPlayer;Lnet/theawesomegem/fishingmadebetter/common/item/tracker/ItemFishTracker;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", remap=false), remap=false)
    private Object FMB_FishingEventHandler_getTrackingFish_getFishData(Map<String, FishData> fishDataMap, Object fishType) {
        this.localizator$myFishData = fishDataMap.get((String)fishType);
        return fishDataMap.get((String)fishType);
    }

    @ModifyArg(method={"getTrackingFish(Lnet/minecraft/entity/player/EntityPlayer;Lnet/theawesomegem/fishingmadebetter/common/item/tracker/ItemFishTracker;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=1, remap=true), index=0, remap=false)
    private ITextComponent FMB_FishingEventHandler_getTrackingFish_sendCreativeMessage1(ITextComponent par1) {
        return new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.creative.fishQty_Y_levels", new Object[]{this.localizator$myPopulationData.getQuantity(), new TextComponentTranslation(FMB_BetterFishUtil.getFishDataUnlocalizedName(this.localizator$myFishData), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150227_a(Boolean.valueOf(true)).func_150241_a((ClickEvent)new FishRequirementsClickEvent(FishRequirementsClickEvent.Action.FISH_REQUIREMENTS, this.localizator$myFishData.fishId)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("jei.fishingmadebetter.category.fish_requirements", new Object[0])))), new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.creative.liquid." + this.localizator$myFishData.liquid.toString(), new Object[0]), this.localizator$myFishData.minYLevel, this.localizator$myFishData.maxYLevel});
    }

    @ModifyArg(method={"getTrackingFish(Lnet/minecraft/entity/player/EntityPlayer;Lnet/theawesomegem/fishingmadebetter/common/item/tracker/ItemFishTracker;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=2, remap=true), index=0, remap=false)
    private ITextComponent FMB_FishingEventHandler_getTrackingFish_sendCreativeMessage2(ITextComponent par1) {
        return new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.creative.fishEnvironmentConditions", new Object[]{this.localizator$myFishData.minDeepLevel, new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.creative.time." + this.localizator$myFishData.time.toString(), new Object[0]), this.localizator$myFishData.maxLightLevel, new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.creative.rain." + this.localizator$myFishData.rainRequired, new Object[0]), new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.creative.thunder." + this.localizator$myFishData.thunderRequired, new Object[0])});
    }

    @ModifyArg(method={"getTrackingFish(Lnet/minecraft/entity/player/EntityPlayer;Lnet/theawesomegem/fishingmadebetter/common/item/tracker/ItemFishTracker;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=3, remap=true), index=0, remap=false)
    private ITextComponent FMB_FishingEventHandler_getTrackingFish_sendSurvivalMessageLimited(ITextComponent par1) {
        return new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.survival.limited", new Object[]{new TextComponentTranslation(FMB_BetterFishUtil.getFishDataUnlocalizedName(this.localizator$myFishData), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150227_a(Boolean.valueOf(true)).func_150241_a((ClickEvent)new FishRequirementsClickEvent(FishRequirementsClickEvent.Action.FISH_REQUIREMENTS, this.localizator$myFishData.fishId)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("jei.fishingmadebetter.category.fish_requirements", new Object[0]))))});
    }

    @ModifyArg(method={"getTrackingFish(Lnet/minecraft/entity/player/EntityPlayer;Lnet/theawesomegem/fishingmadebetter/common/item/tracker/ItemFishTracker;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V", ordinal=4, remap=true), index=0, remap=false)
    private ITextComponent FMB_FishingEventHandler_getTrackingFish_sendSurvivalMessageDetailed(ITextComponent par1) {
        int pop = this.localizator$myPopulationData.getQuantity();
        String quantity = pop > 50 ? "notif.fishingmadebetter.fish_tracker.quantity_immense_" : (pop > 40 ? "notif.fishingmadebetter.fish_tracker.quantity_abundant_" : (pop > 30 ? "notif.fishingmadebetter.fish_tracker.quantity_ample_" : (pop > 20 ? "notif.fishingmadebetter.fish_tracker.quantity_substantial_" : (pop > 10 ? "notif.fishingmadebetter.fish_tracker.quantity_numerous_" : (pop > 3 ? "notif.fishingmadebetter.fish_tracker.quantity_light_" : (pop > 1 ? "notif.fishingmadebetter.fish_tracker.quantity_sparse_" : "notif.fishingmadebetter.fish_tracker.quantity_meager_"))))));
        return new TextComponentTranslation("notif.fishingmadebetter.fish_tracker.survival.detailed", new Object[]{new TextComponentTranslation(FMB_BetterFishUtil.getFishDataUnlocalizedName(this.localizator$myFishData), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150227_a(Boolean.valueOf(true)).func_150241_a((ClickEvent)new FishRequirementsClickEvent(FishRequirementsClickEvent.Action.FISH_REQUIREMENTS, this.localizator$myFishData.fishId)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("jei.fishingmadebetter.category.fish_requirements", new Object[0])))), new TextComponentTranslation(FMB_BetterFishUtil.getFishDataUnlocalizedDesc(this.localizator$myFishData), new Object[0]), new TextComponentTranslation(quantity, new Object[0])});
    }

    @Inject(method={"getFishItemStack(Lnet/theawesomegem/fishingmadebetter/common/data/FishCaughtData;JI)Lnet/minecraft/item/ItemStack;"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true, remap=false)
    private void FMB_FishingEventHandler_getFishItemStack_addLocalizedNBT(FishCaughtData fishCaughtData, long currentTime, int weightModifier, CallbackInfoReturnable<ItemStack> cir) {
        if (ItemStack.field_190927_a.equals(cir.getReturnValue())) {
            cir.setReturnValue((Object)ItemStack.field_190927_a);
        } else {
            ItemStack newItem = (ItemStack)cir.getReturnValue();
            newItem.func_135074_t();
            newItem.func_190924_f(FMB_BetterFishUtil.getFishCaughtDataUnlocalizedName(fishCaughtData));
            ArrayList<String> locLoreList = new ArrayList<String>();
            ArrayList<String> argList = new ArrayList<String>();
            locLoreList.add("tooltip.fishingmadebetter.fish.weight");
            argList.add(String.valueOf(fishCaughtData.weight));
            if (newItem.func_77978_p().func_74764_b("FishScale")) {
                locLoreList.add("tooltip.fishingmadebetter.fish.scale_attached");
                argList.add("");
            }
            locLoreList.add("tooltip.fishingmadebetter.fish.alive");
            argList.add("");
            cir.setReturnValue((Object)LocLoreUtil.appendLocLore(newItem, locLoreList, argList));
        }
    }
}

