/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.data.fishingmadebetter;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.theawesomegem.fishingmadebetter.common.data.FishData;

public class FishRequirementData {
    public int minYLevel;
    public int maxYLevel;
    public FishData.FishingLiquid liquid;
    public List<Integer> dimensionList;
    public boolean rainRequired;
    public boolean thunderRequired;
    public List<String> biomeTagList;
    public FishData.TimeToFish timeToFish;
    public String fishId;
    public int maxLightLevel;

    public FishRequirementData(FishData fishData) {
        this.fishId = fishData.fishId;
        this.minYLevel = fishData.minYLevel;
        this.maxYLevel = fishData.maxYLevel;
        this.liquid = fishData.liquid;
        this.timeToFish = fishData.time;
        this.rainRequired = fishData.rainRequired;
        this.thunderRequired = fishData.thunderRequired;
        this.maxLightLevel = fishData.maxLightLevel;
        this.dimensionList = new ArrayList<Integer>();
        if (!fishData.dimensionBlacklist) {
            this.dimensionList.addAll(fishData.dimensionList);
        } else {
            this.dimensionList.addAll(DefaultDimensions.getDefaultDimensions());
            this.dimensionList.removeAll(fishData.dimensionList);
        }
        this.biomeTagList = new ArrayList<String>();
        if (!fishData.biomeBlacklist) {
            this.biomeTagList.addAll(fishData.biomeTagList);
        } else {
            this.biomeTagList.addAll(FishRequirementData.getAllBiomeTypeNames());
            this.biomeTagList.removeAll(fishData.biomeTagList);
        }
    }

    public static List<String> getAllBiomeTypeNames() {
        return Arrays.asList("MUSHROOM", "DEAD", "SPOOKY", "JUNGLE", "SWAMP", "HOT", "SANDY", "COLD", "MOUNTAIN", "FOREST", "PLAINS", "RIVER", "WATER");
    }

    public static int texturePosFromBiomeTag(String tag) {
        int index = 0;
        if (Strings.isNullOrEmpty((String)tag)) {
            return index;
        }
        switch (tag) {
            case "MUSHROOM": {
                index = 8;
                break;
            }
            case "DEAD": 
            case "SPOOKY": {
                index = 9;
                break;
            }
            case "JUNGLE": {
                index = 1;
                break;
            }
            case "SWAMP": {
                index = 7;
                break;
            }
            case "HOT": 
            case "SANDY": {
                index = 2;
                break;
            }
            case "COLD": {
                index = 3;
                break;
            }
            case "MOUNTAIN": {
                index = 4;
                break;
            }
            case "FOREST": {
                index = 5;
                break;
            }
            case "PLAINS": 
            case "RIVER": {
                index = 6;
            }
        }
        return index;
    }

    public static enum DefaultDimensions {
        NETHER(-1),
        OVERWORLD(0),
        THE_END(1);

        private final Integer dimensionCode;

        private DefaultDimensions(Integer dimension) {
            this.dimensionCode = dimension;
        }

        public static List<Integer> getDefaultDimensions() {
            return Arrays.asList(DefaultDimensions.NETHER.dimensionCode, DefaultDimensions.OVERWORLD.dimensionCode, DefaultDimensions.THE_END.dimensionCode);
        }
    }
}

