/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.common.text.event;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.text.event.ClickEvent;

public class FishRequirementsClickEvent
extends ClickEvent {
    private final Action action;
    private final String value;

    public FishRequirementsClickEvent(Action theAction, String theValue) {
        super(ClickEvent.Action.SUGGEST_COMMAND, "");
        this.action = theAction;
        this.value = theValue;
    }

    public Action getFishRequirementsAction() {
        return this.action;
    }

    @Nonnull
    public String func_150668_b() {
        return this.action.canonicalName + " " + this.value;
    }

    public String getfishId() {
        return this.value;
    }

    @Nonnull
    public String toString() {
        return "FishRequirementsClickEvent{action=" + (Object)((Object)this.action) + ", value='" + this.value + "'" + '}';
    }

    public static enum Action {
        FISH_REQUIREMENTS("fish_requirements", true);

        private static final Map<String, Action> NAME_MAPPING;
        private final boolean allowedInChat;
        private final String canonicalName;

        private Action(String canonicalNameIn, boolean allowedInChatIn) {
            this.canonicalName = canonicalNameIn;
            this.allowedInChat = allowedInChatIn;
        }

        public boolean shouldAllowInChat() {
            return this.allowedInChat;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public static Action getValueByCanonicalName(String canonicalNameIn) {
            return NAME_MAPPING.get(canonicalNameIn);
        }

        static {
            NAME_MAPPING = Maps.newHashMap();
            for (Action clickevent$action : Action.values()) {
                NAME_MAPPING.put(clickevent$action.getCanonicalName(), clickevent$action);
            }
        }
    }
}

