/*
 * Decompiled with CFR 0.152.
 */
package kameib.localizator.client.jei.fishingmadebetter;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;

public class FishRequirementsRecipeCategory
implements IRecipeCategory<IRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private static final short SLOT_FISH = 0;
    private static final short SLOT_FISHING_ROD = 1;
    private static final short SLOT_REEL = 2;
    private static final short SLOT_BOBBER = 3;
    private static final short SLOT_BAIT_BUCKET = 4;
    private static final short SLOT_BAITS_START = 5;
    private static final short X_OFFSET = -8;
    private static final short Y_OFFSET = -6;

    public FishRequirementsRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @Nonnull
    public String getUid() {
        return "FMB_FISH_REQUIREMENTS";
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.fishingmadebetter.category.fish_requirements", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Localizator";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("fishingmadebetter", "textures/gui/fishreq_gui.png"), 7, 5, 163, 120);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((Object)new ItemStack((Item)ItemManager.FISH_TRACKER_DIAMOND));
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 15, 49);
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() <= 0) {
            return;
        }
        guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.init(1, true, 6, 77);
        if (ingredients.getInputs(VanillaTypes.ITEM).size() >= 1) {
            guiItemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        guiItemStacks.init(2, true, 24, 77);
        if (ingredients.getInputs(VanillaTypes.ITEM).size() >= 2) {
            guiItemStacks.set(2, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        }
        guiItemStacks.init(3, true, 6, 95);
        if (ingredients.getInputs(VanillaTypes.ITEM).size() >= 3) {
            guiItemStacks.set(3, (List)ingredients.getInputs(VanillaTypes.ITEM).get(2));
        }
        guiItemStacks.init(4, true, 56, 95);
        if (ingredients.getInputs(VanillaTypes.ITEM).size() >= 4) {
            guiItemStacks.set(4, (List)ingredients.getInputs(VanillaTypes.ITEM).get(3));
        }
        int slot = 5;
        int x = 88;
        int y = 45;
        for (int i = 0; slot - 1 < ingredients.getInputs(VanillaTypes.ITEM).size() && i < 16; i = (int)((short)(i + 1))) {
            guiItemStacks.init(slot, true, x + i / 4 * 18, y + i % 4 * 18);
            if (ingredients.getInputs(VanillaTypes.ITEM).size() > slot - 1) {
                guiItemStacks.set(slot, (List)ingredients.getInputs(VanillaTypes.ITEM).get(slot - 1));
            }
            slot = (short)(slot + 1);
        }
    }
}

