/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenAnimalFarm
extends WorldGenerator {
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        Biome biome = worldIn.func_180494_b(position);
        Set types = BiomeDictionary.getTypes((Biome)biome);
        boolean sandy = types.contains(BiomeDictionary.Type.SANDY);
        Block fence = Blocks.field_180407_aO;
        Block fence_gate = Blocks.field_180390_bo;
        ArrayList<Integer> spawns = new ArrayList<Integer>();
        if (types.contains(BiomeDictionary.Type.SAVANNA)) {
            fence = Blocks.field_180405_aT;
            fence_gate = Blocks.field_180387_bt;
            spawns.add(0);
        } else if (types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            fence = Blocks.field_180408_aP;
            fence_gate = Blocks.field_180391_bp;
            spawns.add(1);
        } else if (types.contains(BiomeDictionary.Type.JUNGLE)) {
            fence = Blocks.field_180403_aR;
            fence_gate = Blocks.field_180386_br;
            spawns.add(2);
        } else if (types.contains(BiomeDictionary.Type.FOREST) && types.contains(BiomeDictionary.Type.DENSE)) {
            fence = Blocks.field_180406_aS;
            fence_gate = Blocks.field_180385_bs;
        } else if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q || biome == Biomes.field_185448_Z || biome == Biomes.field_185429_aa) {
            fence = Blocks.field_180404_aQ;
            fence_gate = Blocks.field_180392_bq;
        }
        if (types.contains(BiomeDictionary.Type.SANDY)) {
            spawns.add(3);
        }
        if (types.contains(BiomeDictionary.Type.PLAINS)) {
            spawns.add(2);
        }
        if (spawns.isEmpty()) {
            spawns.add(rand.nextInt(4));
        }
        Iterator iterator = spawns.iterator();
        block6: while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            for (int count = 0; count < rand.nextInt(3) + 2; ++count) {
                EntityCow animal = null;
                switch (type) {
                    case 0: {
                        animal = new EntityCow(worldIn);
                        break;
                    }
                    case 1: {
                        animal = new EntitySheep(worldIn);
                        break;
                    }
                    case 2: {
                        animal = new EntityChicken(worldIn);
                        break;
                    }
                    case 3: {
                        animal = new EntityPig(worldIn);
                    }
                }
                if (animal == null) continue block6;
                animal.func_70080_a((double)((float)position.func_177958_n() + 0.5f + (float)(-3 + rand.nextInt(6))), (double)((float)position.func_177956_o() + 1.5f), (double)((float)position.func_177952_p() + 0.5f + (float)(-3 + rand.nextInt(6))), rand.nextFloat() * 360.0f, 0.0f);
                worldIn.func_72838_d((Entity)animal);
            }
        }
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                if ((x % 4 == 0 || z % 4 == 0 || x % -4 == 0 || z % -4 == 0) && Math.abs(x) != 0 && Math.abs(z) != 0) {
                    worldIn.func_175656_a(position.func_177982_a(x, 0, z), sandy ? Blocks.field_150354_m.func_176223_P() : Blocks.field_150349_c.func_176223_P());
                    worldIn.func_175656_a(position.func_177982_a(x, 1, z), fence.func_176223_P());
                } else {
                    worldIn.func_175656_a(position.func_177982_a(x, 0, z), Blocks.field_185774_da.func_176223_P());
                    worldIn.func_175656_a(position.func_177982_a(x, 1, z), Blocks.field_150350_a.func_176223_P());
                    worldIn.func_175656_a(position.func_177982_a(x, 2, z), Blocks.field_150350_a.func_176223_P());
                }
                if (x == 0) {
                    worldIn.func_175656_a(position.func_177982_a(0, 1, 4), fence_gate.func_176223_P().func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.SOUTH));
                    worldIn.func_175656_a(position.func_177982_a(0, 1, -4), fence_gate.func_176223_P().func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.NORTH));
                    worldIn.func_175656_a(position.func_177982_a(0, 0, 4), Blocks.field_185774_da.func_176223_P());
                    worldIn.func_175656_a(position.func_177982_a(0, 0, -4), Blocks.field_185774_da.func_176223_P());
                }
                if (z != 0) continue;
                worldIn.func_175656_a(position.func_177982_a(4, 1, 0), fence_gate.func_176223_P().func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.EAST));
                worldIn.func_175656_a(position.func_177982_a(-4, 1, 0), fence_gate.func_176223_P().func_177226_a((IProperty)BlockFenceGate.field_185512_D, (Comparable)EnumFacing.WEST));
                worldIn.func_175656_a(position.func_177982_a(4, 0, 0), Blocks.field_185774_da.func_176223_P());
                worldIn.func_175656_a(position.func_177982_a(-4, 0, 0), Blocks.field_185774_da.func_176223_P());
            }
        }
        return true;
    }
}

