/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IceAndFire;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class DragonPosWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "iceandfire_dragonPositions";
    protected final Map<UUID, BlockPos> lastDragonPositions = new HashMap<UUID, BlockPos>();
    private int tickCounter;

    public DragonPosWorldData(String name) {
        super(name);
    }

    public DragonPosWorldData() {
        super(IDENTIFIER);
        this.func_76185_a();
    }

    public static DragonPosWorldData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        DragonPosWorldData instance = (DragonPosWorldData)storage.func_75742_a(DragonPosWorldData.class, IDENTIFIER);
        if (instance == null) {
            instance = new DragonPosWorldData();
            storage.func_75745_a(IDENTIFIER, (WorldSavedData)instance);
        }
        instance.func_76185_a();
        return instance;
    }

    public void addDragon(UUID uuid, BlockPos pos) {
        this.lastDragonPositions.put(uuid, pos);
        this.func_76185_a();
    }

    public void removeDragon(UUID uuid) {
        this.lastDragonPositions.remove(uuid);
        this.func_76185_a();
    }

    @Nullable
    public BlockPos getDragonPos(UUID uuid) {
        return this.lastDragonPositions.get(uuid);
    }

    public void debug() {
        IceAndFire.logger.warn(this.lastDragonPositions.toString());
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        NBTTagList nbttaglist = nbt.func_150295_c("DragonMap", 10);
        this.lastDragonPositions.clear();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            UUID uuid = nbttagcompound.func_186857_a("DragonUUID");
            BlockPos pos = new BlockPos(nbttagcompound.func_74762_e("DragonPosX"), nbttagcompound.func_74762_e("DragonPosY"), nbttagcompound.func_74762_e("DragonPosZ"));
            this.lastDragonPositions.put(uuid, pos);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        NBTTagList nbttaglist = new NBTTagList();
        for (Map.Entry<UUID, BlockPos> pair : this.lastDragonPositions.entrySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_186854_a("DragonUUID", pair.getKey());
            nbttagcompound.func_74768_a("DragonPosX", pair.getValue().func_177958_n());
            nbttagcompound.func_74768_a("DragonPosY", pair.getValue().func_177956_o());
            nbttagcompound.func_74768_a("DragonPosZ", pair.getValue().func_177952_p());
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("DragonMap", (NBTBase)nbttaglist);
        return compound;
    }
}

