/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.block.BlockCoinPile;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class WorldGenDragonRoost
extends WorldGenerator {
    private static boolean isMale;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        isMale = rand.nextBoolean();
        int dragonAge = 50 + rand.nextInt(25);
        this.transformGround(worldIn, rand, position, dragonAge / 5);
        this.generateStructures(worldIn, rand, position, dragonAge / 5);
        this.generateDragon(worldIn, rand, position, dragonAge);
        return true;
    }

    private void transformGround(World world, Random rand, BlockPos position, int radius) {
        for (int i = 0; radius >= 0 && i < 3; ++i) {
            int j = radius + rand.nextInt(2);
            int k = radius + rand.nextInt(2);
            int l = radius + rand.nextInt(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                IBlockState state;
                float hardness;
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || (hardness = (state = world.func_180495_p(blockpos)).func_177230_c().func_176195_g(state, world, blockpos)) == -1.0f) continue;
                this.transformState(world, blockpos, state);
            }
        }
    }

    public void generateStructures(World world, Random rand, BlockPos position, int radius) {
        for (int i = 0; radius >= 0 && i < 3; ++i) {
            int j = radius + rand.nextInt(2);
            int k = radius + rand.nextInt(2);
            int l = radius + rand.nextInt(2);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            block5: for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                int chance;
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || !world.func_175623_d(blockpos) || !this.isDragonTransformedBlock(world.func_180495_p(blockpos.func_177977_b()).func_177230_c()) || (chance = rand.nextInt(100)) >= 4) continue;
                int chance2 = rand.nextInt(20);
                switch (chance2) {
                    default: {
                        this.generatePile(world, rand, blockpos);
                        continue block5;
                    }
                    case 1: {
                        this.generateArchNS(world, rand, blockpos);
                        continue block5;
                    }
                    case 2: 
                }
                this.generateArchEW(world, rand, blockpos);
            }
        }
    }

    public void generatePile(World world, Random rand, BlockPos position) {
        int height = 1 + rand.nextInt(7);
        int chance = rand.nextInt(100);
        if (chance < 20) {
            TileEntity chest;
            world.func_180501_a(position, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[rand.nextInt(3)]), 3);
            if (world.func_180495_p(position).func_177230_c() instanceof BlockChest && (chest = world.func_175625_s(position)) instanceof TileEntityChest && !chest.func_145837_r()) {
                ((TileEntityChest)chest).func_189404_a(this.getLootTable(), rand.nextLong());
            }
        } else {
            world.func_180501_a(position, this.getPileBlock().func_177226_a((IProperty)BlockCoinPile.LAYERS, (Comparable)Integer.valueOf(height)), 3);
        }
    }

    public void generateArchNS(World world, Random rand, BlockPos position) {
        int height = 3 + rand.nextInt(1);
        int width = 1 + rand.nextInt(2);
        for (int sides = 0; sides < height; ++sides) {
            world.func_180501_a(position.func_177981_b(sides).func_177965_g(width / 2), this.getBuildingBlock(), 3);
            world.func_180501_a(position.func_177981_b(sides).func_177985_f(width / 2), this.getBuildingBlock(), 3);
        }
        for (int way = -1; way < width; ++way) {
            world.func_180501_a(position.func_177981_b(height).func_177965_g(way), this.getBuildingBlock(), 3);
        }
    }

    public void generateArchEW(World world, Random rand, BlockPos position) {
        int height = 3 + rand.nextInt(1);
        int width = 1 + rand.nextInt(2);
        for (int sides = 0; sides < height; ++sides) {
            world.func_180501_a(position.func_177981_b(sides).func_177964_d(width / 2), this.getBuildingBlock(), 3);
            world.func_180501_a(position.func_177981_b(sides).func_177970_e(width / 2), this.getBuildingBlock(), 3);
        }
        for (int way = 0; way < width; ++way) {
            world.func_180501_a(position.func_177981_b(height).func_177970_e(way), this.getBuildingBlock(), 3);
        }
    }

    private void generateDragon(World worldIn, Random rand, BlockPos position, int dragonAge) {
        EntityDragonBase dragon = this.createDragon(worldIn);
        dragon.setGender(isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)worldIn.func_175645_m(position).func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, worldIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
        dragon.homePos = position;
        dragon.hasHomePosition = true;
        dragon.setHunger(50);
        worldIn.func_72838_d((Entity)dragon);
    }

    private boolean isDragonTransformedBlock(Block block) {
        for (Block dragonTransformedBlock : this.getDragonTransformedBlocks()) {
            if (block != dragonTransformedBlock) continue;
            return true;
        }
        return false;
    }

    protected abstract void transformState(World var1, BlockPos var2, IBlockState var3);

    protected abstract IBlockState getPileBlock();

    protected abstract IBlockState getBuildingBlock();

    protected abstract Block[] getDragonTransformedBlocks();

    protected abstract ResourceLocation getLootTable();

    protected abstract EntityDragonBase createDragon(World var1);
}

