/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningVector;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageChainLightningFX
extends AbstractMessage<MessageChainLightningFX> {
    private List<Integer> entityIds;

    public MessageChainLightningFX(List<Integer> entityIds) {
        this.entityIds = entityIds;
    }

    public MessageChainLightningFX() {
    }

    public void fromBytes(ByteBuf buf) {
        int count = buf.readInt();
        this.entityIds = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            int entityId = buf.readInt();
            this.entityIds.add(entityId);
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.entityIds == null) {
            buf.writeInt(0);
        }
        buf.writeInt(this.entityIds.size());
        for (int entityId : this.entityIds) {
            buf.writeInt(entityId);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientReceived(Minecraft client, MessageChainLightningFX message, EntityPlayer player, MessageContext messageContext) {
        if (this.entityIds == null || this.entityIds.size() < 2) {
            return;
        }
        Entity entity = player.field_70170_p.func_73045_a(this.entityIds.get(0).intValue());
        ParticleLightningVector sourceVec = null;
        ParticleLightningVector targetVec = null;
        if (entity != null) {
            sourceVec = ParticleLightningVector.fromEntityCenter(entity);
        }
        for (int i = 1; i < this.entityIds.size(); ++i) {
            entity = player.field_70170_p.func_73045_a(this.entityIds.get(i).intValue());
            if (entity != null) {
                targetVec = ParticleLightningVector.fromEntityCenter(entity);
            }
            if (sourceVec != null && targetVec != null) {
                IceAndFire.PROXY.spawnLightningEffect(player.field_70170_p, sourceVec, targetVec, false);
            }
            if (targetVec == null) continue;
            sourceVec = targetVec;
        }
    }

    public void onServerReceived(MinecraftServer server, MessageChainLightningFX message, EntityPlayer player, MessageContext messageContext) {
    }
}

