/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouseModel;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityPixieHouse
extends TileEntity
implements ITickable {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    public int houseType;
    public boolean hasPixie;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public int ticksExisted;
    public NonNullList<ItemStack> pixieItems = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("HouseType", this.houseType);
        compound.func_74757_a("HasPixie", this.hasPixie);
        compound.func_74768_a("PixieType", this.pixieType);
        compound.func_74757_a("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            compound.func_186854_a("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.pixieItems);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieHouseModel(this.field_174879_c.func_177986_g(), packet.func_148857_g().func_74762_e("HouseType")));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.houseType = compound.func_74762_e("HouseType");
        this.hasPixie = compound.func_74767_n("HasPixie");
        this.pixieType = compound.func_74762_e("PixieType");
        this.tamedPixie = compound.func_74767_n("TamedPixie");
        this.pixieOwnerUUID = compound.func_186857_a("TicksExisted");
        this.pixieItems = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.pixieItems);
        super.func_145839_a(compound);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K && this.hasPixie && this.field_145850_b.field_73012_v.nextInt(100) == 0) {
            this.releasePixie();
        }
        if (this.hasPixie && this.field_145850_b.field_72995_K) {
            IceAndFire.PROXY.spawnParticle(EnumParticle.PIXIE_DUST, this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f) + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)this.field_174879_c.func_177956_o() + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.6f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f) + (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.3f * 2.0f) - (double)0.3f, EntityPixie.PARTICLE_RGB[this.pixieType][0], EntityPixie.PARTICLE_RGB[this.pixieType][1], EntityPixie.PARTICLE_RGB[this.pixieType][2]);
        }
    }

    public void releasePixie() {
        EntityPixie pixie = new EntityPixie(this.field_145850_b);
        pixie.func_70080_a((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, new Random().nextInt(360), 0.0f);
        pixie.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)this.pixieItems.get(0));
        pixie.setColor(this.pixieType);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)pixie);
        }
        this.hasPixie = false;
        this.pixieType = 0;
        pixie.ticksUntilHouseAI = 500;
        pixie.func_70903_f(this.tamedPixie);
        pixie.func_184754_b(this.pixieOwnerUUID);
        if (!this.field_145850_b.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieHouse(this.field_174879_c.func_177986_g(), false, 0));
        }
    }
}

