/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.explosion;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import com.github.alexthe666.iceandfire.message.MessageParticleFX;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockBreakExplosion
extends Explosion {
    private final World worldObj;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final EntityCreature exploder;
    private final float explosionSize;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;

    public BlockBreakExplosion(World world, EntityCreature entity, double x, double y, double z, float size) {
        super(world, (Entity)entity, x, y, z, size, true, true);
        this.worldObj = world;
        this.exploder = entity;
        this.explosionSize = size;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.position = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 3.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.explosionX;
                    double d6 = this.explosionY;
                    double d8 = this.explosionZ;
                    float f1 = 0.3f;
                    for (float f = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.worldObj.func_180495_p(blockpos);
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.worldObj, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.worldObj, blockpos, (Entity)null, (Explosion)this);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.worldObj, blockpos, iblockstate, f)) && iblockstate.func_177230_c().canEntityDestroy(iblockstate, (IBlockAccess)this.worldObj, blockpos, (Entity)this.exploder)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.explosionSize * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
        List list = this.worldObj.func_72839_b((Entity)this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)f3);
        Vec3d Vec3d2 = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        for (Entity entity : list) {
            double d12;
            if (entity.func_180427_aV() || DragonUtils.isControllingPassenger((Entity)this.exploder, entity) || !((d12 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)f3) <= 1.0)) continue;
            double d5 = entity.field_70165_t - this.explosionX;
            double d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY;
            double d9 = entity.field_70161_v - this.explosionZ;
            double d13 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7 + d9 * d9));
            double d14 = this.worldObj.func_72842_a(Vec3d2, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            if (d13 != 0.0 && this.exploder != null) {
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.exploder), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)) / 6.0f);
            }
            double d11 = 0.5;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            if (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75102_a) continue;
            this.playerKnockbackMap.put((EntityPlayer)entity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        ArrayList<MessageParticleFX.Particle> explosionParticles = new ArrayList<MessageParticleFX.Particle>();
        ArrayList<MessageParticleFX.Particle> smokeParticles = new ArrayList<MessageParticleFX.Particle>();
        for (BlockPos blockpos : this.affectedBlockPositions) {
            IBlockState state = this.worldObj.func_180495_p(blockpos);
            Block block = this.worldObj.func_180495_p(blockpos).func_177230_c();
            if (spawnParticles && this.worldObj.field_73012_v.nextBoolean() && !this.worldObj.func_175623_d(blockpos)) {
                double d0 = (float)blockpos.func_177958_n() + this.worldObj.field_73012_v.nextFloat();
                double d1 = (float)blockpos.func_177956_o() + this.worldObj.field_73012_v.nextFloat();
                double d2 = (float)blockpos.func_177952_p() + this.worldObj.field_73012_v.nextFloat();
                double d3 = d0 - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                explosionParticles.add(MessageParticleFX.createParticle((d0 + this.explosionX) / 2.0, (d1 + this.explosionY) / 2.0, (d2 + this.explosionZ) / 2.0, d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7));
                smokeParticles.add(MessageParticleFX.createParticle(d0, d1, d2, d3, d4, d5));
            }
            if (state.func_185904_a() == Material.field_151579_a) continue;
            if (block.func_149659_a((Explosion)this)) {
                block.func_180653_a(this.worldObj, blockpos, this.worldObj.func_180495_p(blockpos), 1.0f / this.explosionSize, 0);
            }
            block.onBlockExploded(this.worldObj, blockpos, (Explosion)this);
        }
        if (!explosionParticles.isEmpty()) {
            IceAndFire.NETWORK_WRAPPER.sendToAllTracking((IMessage)new MessageParticleFX(EnumParticle.EXPLOSION, explosionParticles), (Entity)this.exploder);
        }
        if (!smokeParticles.isEmpty()) {
            IceAndFire.NETWORK_WRAPPER.sendToAllTracking((IMessage)new MessageParticleFX(EnumParticle.SMOKE_NORMAL, smokeParticles), (Entity)this.exploder);
        }
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public EntityLivingBase func_94613_c() {
        return this.exploder;
    }

    public void func_180342_d() {
        super.func_180342_d();
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

