/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class StymphalianBirdAIAirTarget
extends EntityAIBase {
    private EntityStymphalianBird bird;

    public StymphalianBirdAIAirTarget(EntityStymphalianBird bird) {
        this.bird = bird;
    }

    public boolean func_75250_a() {
        if (!this.bird.isFlying()) {
            return false;
        }
        if (this.bird.func_70631_g_()) {
            return false;
        }
        if (this.bird.doesWantToLand()) {
            return false;
        }
        if (this.bird.airTarget != null && this.bird.isTargetBlocked(new Vec3d((Vec3i)this.bird.airTarget))) {
            this.bird.airTarget = null;
        }
        if (this.bird.airTarget == null) {
            EntityLivingBase attackTarget = this.bird.func_70638_az();
            if (attackTarget != null) {
                this.bird.airTarget = new BlockPos(attackTarget.field_70165_t, attackTarget.field_70163_u + (double)attackTarget.func_70047_e(), attackTarget.field_70161_v);
                return true;
            }
            BlockPos pos = StymphalianBirdAIAirTarget.getNearbyAirTarget(this.bird);
            if (pos == null) {
                return false;
            }
            Vec3d vec = new Vec3d((Vec3i)pos);
            this.bird.airTarget = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.bird.isFlying()) {
            return false;
        }
        if (this.bird.func_70631_g_()) {
            return false;
        }
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this.bird);
        if (capability != null && capability.isStoned()) {
            return false;
        }
        EntityLivingBase attackTarget = this.bird.func_70638_az();
        if (attackTarget != null) {
            this.bird.airTarget = new BlockPos(attackTarget.field_70165_t, attackTarget.field_70163_u + (double)attackTarget.func_70047_e(), attackTarget.field_70161_v);
        }
        return this.bird.airTarget != null;
    }

    public static BlockPos getNearbyAirTarget(EntityStymphalianBird bird) {
        if (bird.func_70638_az() == null) {
            BlockPos pos = DragonUtils.getBlockInViewStymphalian(bird);
            if (pos != null && bird.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
                return pos;
            }
            if (bird.flock != null && bird.flock.isLeader(bird)) {
                bird.flock.setTarget(bird.airTarget);
            }
        }
        return null;
    }
}

