/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class DragonAIWaterTarget
extends EntityAIBase {
    private final EntityIceDragon dragon;

    public DragonAIWaterTarget(EntityIceDragon dragon) {
        this.dragon = dragon;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.dragon != null) {
            if (this.dragon.isSleeping()) {
                return false;
            }
            if (!this.dragon.func_70090_H()) {
                return false;
            }
            if (this.dragon.isPlayerControlled()) {
                return false;
            }
            if (this.dragon.waterTarget != null && this.dragon.isTargetBlocked(new Vec3d((Vec3i)this.dragon.waterTarget))) {
                this.dragon.waterTarget = null;
            }
            if (this.dragon.waterTarget == null || this.dragon.isTargetBlocked(new Vec3d((Vec3i)this.dragon.waterTarget))) {
                EntityLivingBase attackTarget = this.dragon.func_70638_az();
                if (attackTarget != null) {
                    this.dragon.waterTarget = new BlockPos(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v);
                    return true;
                }
                BlockPos pos = this.getNearbyWaterTarget();
                if (pos == null) {
                    this.dragon.waterTarget = null;
                    return false;
                }
                Vec3d vec = new Vec3d((Vec3i)pos);
                this.dragon.waterTarget = new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.dragon.func_70090_H()) {
            return false;
        }
        if (this.dragon.isSleeping()) {
            return false;
        }
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this.dragon);
        if (capability != null && capability.isStoned()) {
            return false;
        }
        EntityLivingBase attackTarget = this.dragon.func_70638_az();
        if (attackTarget != null) {
            this.dragon.waterTarget = new BlockPos(attackTarget.field_70165_t, attackTarget.field_70163_u, attackTarget.field_70161_v);
        }
        if (this.dragon.waterTarget != null) {
            if (this.dragon.isTargetBlocked(new Vec3d((Vec3i)this.dragon.waterTarget))) {
                this.dragon.waterTarget = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public BlockPos getNearbyWaterTarget() {
        BlockPos pos;
        if (this.dragon.func_70638_az() == null && (pos = DragonUtils.getWaterBlockInView(this.dragon)) != null && this.dragon.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            return pos;
        }
        return null;
    }
}

