/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IafVillagerRegistry;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexQueenAIWander;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.event.StructureGenerator;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMyrmexQueen
extends EntityMyrmexBase {
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_queen.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_queen.png");
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final Animation ANIMATION_EGG = Animation.create((int)20);
    public static final Animation ANIMATION_DIGNEST = Animation.create((int)45);
    private static final DataParameter<Boolean> HASMADEHOME = EntityDataManager.func_187226_a(EntityMyrmexQueen.class, (DataSerializer)DataSerializers.field_187198_h);
    private int eggTicks = 0;
    public static final ResourceLocation DESERT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_queen_desert"));
    public static final ResourceLocation JUNGLE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_queen_jungle"));

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    public EntityMyrmexQueen(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.9f, 1.86f);
    }

    @Override
    protected int func_70693_a(EntityPlayer player) {
        return 20;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HASMADEHOME, (Object)true);
    }

    public void func_96094_a(String name) {
        if (!this.func_95999_t().equals(name) && this.getHive() != null) {
            this.getHive().colonyName = name;
        }
        super.func_96094_a(name);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("EggTicks", this.eggTicks);
        tag.func_74757_a("MadeHome", this.hasMadeHome());
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.eggTicks = tag.func_74762_e("EggTicks");
        this.setMadeHome(tag.func_74767_n("MadeHome"));
    }

    public boolean hasMadeHome() {
        return (Boolean)this.field_70180_af.func_187225_a(HASMADEHOME);
    }

    public void setMadeHome(boolean madeHome) {
        this.field_70180_af.func_187227_b(HASMADEHOME, (Object)madeHome);
    }

    @Override
    public VillagerRegistry.VillagerProfession getProfessionForge() {
        return this.isJungle() ? IafVillagerRegistry.INSTANCE.jungleMyrmexQueen : IafVillagerRegistry.INSTANCE.desertMyrmexQueen;
    }

    public void func_70636_d() {
        double extraZ;
        float angle;
        float radius;
        double extraX;
        BlockPos eggPos;
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_DIGNEST) {
            this.spawnGroundEffects(3.0f);
        }
        if (this.getHive() != null) {
            this.getHive().tick(0, this.field_70170_p);
        }
        if (this.hasMadeHome() && this.getGrowthStage() >= 2 && !this.canSeeSky()) {
            ++this.eggTicks;
        } else if (this.canSeeSky() && !this.hasMadeHome()) {
            this.setAnimation(ANIMATION_DIGNEST);
            if (this.getAnimationTick() == 42) {
                int down = Math.max(15, this.func_180425_c().func_177956_o() - 20 + this.func_70681_au().nextInt(10));
                BlockPos genPos = new BlockPos(this.field_70165_t, (double)down, this.field_70161_v);
                StructureGenerator.generateMyrmexHiveForQueen(this, this.func_70681_au(), genPos);
                this.setMadeHome(true);
                this.func_70012_b(genPos.func_177958_n(), down, genPos.func_177952_p(), 0.0f, 0.0f);
                this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 30));
                for (int i = 0; i < 3; ++i) {
                    EntityMyrmexWorker worker = new EntityMyrmexWorker(this.field_70170_p);
                    worker.func_82149_j((Entity)this);
                    worker.setHive(this.getHive());
                    worker.setJungleVariant(this.isJungle());
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_72838_d((Entity)worker);
                }
                return;
            }
        }
        if ((!this.field_70170_p.field_72995_K && this.eggTicks > IceAndFireConfig.ENTITY_SETTINGS.myrmexPregnantTicks && this.getHive() == null || !this.field_70170_p.field_72995_K && this.getHive() != null && this.getHive().repopulate() && this.eggTicks > IceAndFireConfig.ENTITY_SETTINGS.myrmexPregnantTicks) && this.field_70170_p.func_175623_d(eggPos = new BlockPos(this.field_70165_t + (extraX = (double)((radius = -5.25f) * MathHelper.func_76126_a((float)((float)(Math.PI + (double)(angle = (float)Math.PI / 180 * this.field_70761_aq)))))), this.field_70163_u + 0.75, this.field_70161_v + (extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)))))) {
            this.setAnimation(ANIMATION_EGG);
            if (this.getAnimationTick() == 10) {
                EntityMyrmexEgg egg = new EntityMyrmexEgg(this.field_70170_p);
                egg.setJungle(this.isJungle());
                int caste = EntityMyrmexQueen.getRandomCaste(this.field_70170_p, this.func_70681_au(), this.getHive() == null || this.getHive().reproduces);
                egg.setMyrmexCaste(caste);
                egg.func_70012_b(this.field_70165_t + extraX, this.field_70163_u + 0.75, this.field_70161_v + extraZ, 0.0f, 0.0f);
                if (this.getHive() != null) {
                    egg.hiveUUID = this.getHive().hiveUUID;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)egg);
                }
                this.eggTicks = 0;
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.getAnimationTick() == 0) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6 && this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2));
            this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
            this.func_70638_az().field_70160_al = true;
            float f = MathHelper.func_76133_a((double)0.5);
            this.func_70638_az().field_70159_w /= 2.0;
            this.func_70638_az().field_70179_y /= 2.0;
            this.func_70638_az().field_70159_w -= 0.5 / (double)f * 4.0;
            this.func_70638_az().field_70179_y -= 0.5 / (double)f * 4.0;
            if (this.func_70638_az().field_70122_E) {
                this.func_70638_az().field_70181_x /= 2.0;
                this.func_70638_az().field_70181_x += 4.0;
                if (this.func_70638_az().field_70181_x > (double)0.4f) {
                    this.func_70638_az().field_70181_x = 0.4f;
                }
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.getAnimation() == ANIMATION_DIGNEST;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new MyrmexQueenAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, true, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(@Nullable EntityLiving entity) {
                return entity != null && !IMob.field_175450_e.apply((Object)entity) && !EntityMyrmexBase.haveSameHive(EntityMyrmexQueen.this, (Entity)entity) && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(120.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.75f;
    }

    @Override
    public int getCasteImportance() {
        return 3;
    }

    @Override
    public boolean shouldLeaveHive() {
        return false;
    }

    @Override
    public boolean shouldEnterHive() {
        return true;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
            if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(EnumHand.MAIN_HAND) != ItemStack.field_190927_a) {
                this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity entity : this.func_184188_bt()) {
                    entity.func_184210_p();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.hasMadeHome();
    }

    public void spawnGroundEffects(float size) {
        int i = 0;
        while ((float)i < size * 3.0f) {
            for (int i1 = 0; i1 < 10; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = size * this.field_70146_Z.nextFloat();
                float angle = (float)Math.PI / 180 * this.field_70761_aq * 3.14f * this.field_70146_Z.nextFloat();
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + extraX)), MathHelper.func_76128_c((double)(this.field_70163_u + extraY)) - 1, MathHelper.func_76128_c((double)(this.field_70161_v + extraZ))));
                if (iblockstate.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.BLOCK_CRACK, true, this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ, motionX, motionY, motionZ, Block.func_176210_f((IBlockState)iblockstate));
            }
            ++i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(3.0, 1.5, 3.0);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING, ANIMATION_EGG, ANIMATION_DIGNEST};
    }
}

