/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.client.model.util.LegSolverQuadruped;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.ai.PathNavigateExperimentalGround;
import com.github.alexthe666.iceandfire.entity.explosion.BlockBreakExplosion;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.EntityMultipartPart;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IDropArmor;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.util.ReversedBuffer;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.enums.EnumDragonType;
import com.github.alexthe666.iceandfire.enums.EnumParticle;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonArmor;
import com.github.alexthe666.iceandfire.item.ItemSummoningCrystal;
import com.github.alexthe666.iceandfire.message.MessageDragonArmor;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageParticleFX;
import com.github.alexthe666.iceandfire.message.MessageUpdateRidingState;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.multipart.IMultipartEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityDragonBase
extends EntityTameable
implements IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IDropArmor,
ISyncMount {
    public static EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    private static final int FLIGHT_CHANCE_PER_TICK = 1500;
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AGE_TICKS = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FIREBREATHING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HEAD_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NECK_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BODY_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TAIL_ARMOR = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> MODEL_DEAD = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DEATH_STAGE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> TACKLE = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> AGINGDISABLED = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CRYSTAL_BOUND = EntityDataManager.func_187226_a(EntityDragonBase.class, (DataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public EnumDragonType dragonType;
    public double minimumDamage;
    public double maximumDamage;
    public double minimumHealth;
    public double maximumHealth;
    public double minimumSpeed;
    public double maximumSpeed;
    public double minimumArmor;
    public double maximumArmor;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public ContainerHorseChest dragonInv;
    public boolean attackDecision;
    public int flightCycle;
    public BlockPos airTarget;
    public BlockPos homePos;
    public boolean hasHomePosition = false;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer roll_buffer;
    @SideOnly(value=Side.CLIENT)
    public ReversedBuffer turn_buffer;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public float[][] growth_stages;
    public LegSolverQuadruped legSolver;
    private boolean isSleeping;
    private boolean isSitting;
    private boolean isHovering;
    private boolean isFlying;
    private boolean isBreathingFire;
    private boolean isTackling;
    private int fireTicks;
    private int hoverTicks;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    public int walkCycle;
    private int tacklingTicks;
    private int ticksStill;
    private float lastScale;
    public EntityDragonPart headPart;
    public EntityDragonPart neckPart;
    public EntityDragonPart rightWingUpperPart;
    public EntityDragonPart rightWingLowerPart;
    public EntityDragonPart leftWingUpperPart;
    public EntityDragonPart leftWingLowerPart;
    public EntityDragonPart tail1Part;
    public EntityDragonPart tail2Part;
    public EntityDragonPart tail3Part;
    public EntityDragonPart tail4Part;

    public EntityDragonBase(World world) {
        super(world);
    }

    public EntityDragonBase(World world, EnumDragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(world);
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.updateAttributes();
        this.initDragonInv();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.roll_buffer = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.2f, 1.2f, 1.0f);
        this.field_70158_ak = true;
        this.resetParts(1.0f);
    }

    public void resetParts(float scale) {
        this.removeParts();
        this.headPart = new EntityDragonPart(this, 1.55f * scale, 0.0f, 0.6f * scale, 0.5f * scale, 0.35f * scale, 1.5f);
        this.neckPart = new EntityDragonPart(this, 0.85f * scale, 0.0f, 0.7f * scale, 0.5f * scale, 0.2f * scale, 1.0f);
        this.rightWingUpperPart = new EntityDragonPart(this, 1.0f * scale, 90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.rightWingLowerPart = new EntityDragonPart(this, 1.4f * scale, 100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.leftWingUpperPart = new EntityDragonPart(this, 1.0f * scale, -90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.leftWingLowerPart = new EntityDragonPart(this, 1.4f * scale, -100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.tail1Part = new EntityDragonPart(this, -0.75f * scale, 0.0f, 0.6f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail2Part = new EntityDragonPart(this, -1.15f * scale, 0.0f, 0.45f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail3Part = new EntityDragonPart(this, -1.5f * scale, 0.0f, 0.35f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail4Part = new EntityDragonPart(this, -1.95f * scale, 0.0f, 0.25f * scale, 0.45f * scale, 0.3f * scale, 1.5f);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.headPart);
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.neckPart);
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.rightWingUpperPart);
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.rightWingLowerPart);
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.leftWingUpperPart);
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.field_70170_p.func_72973_f((Entity)this.leftWingLowerPart);
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail1Part);
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail2Part);
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail3Part);
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.field_70170_p.func_72973_f((Entity)this.tail4Part);
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.headPart != null) {
            this.headPart.func_70071_h_();
        }
        if (this.neckPart != null) {
            this.neckPart.func_70071_h_();
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.func_70071_h_();
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.func_70071_h_();
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.func_70071_h_();
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.func_70071_h_();
        }
        if (this.tail1Part != null) {
            this.tail1Part.func_70071_h_();
        }
        if (this.tail2Part != null) {
            this.tail2Part.func_70071_h_();
        }
        if (this.tail3Part != null) {
            this.tail3Part.func_70071_h_();
        }
        if (this.tail4Part != null) {
            this.tail4Part.func_70071_h_();
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return IceAndFireConfig.DRAGON_SETTINGS.experimentalPathFinder ? new PathNavigateExperimentalGround((EntityLiving)this, worldIn) : super.func_175447_b(worldIn);
    }

    public boolean canDestroyBlock(BlockPos pos) {
        float hardness = this.field_70170_p.func_180495_p(pos).func_177230_c().func_176195_g(this.field_70170_p.func_180495_p(pos), this.field_70170_p, pos);
        return this.field_70170_p.func_180495_p(pos).func_177230_c().canEntityDestroy(this.field_70170_p.func_180495_p(pos), (IBlockAccess)this.field_70170_p, pos, (Entity)this) && hardness >= 0.0f;
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int func_184649_cE() {
        return 10 * this.getDragonStage() / 5;
    }

    private void initDragonInv() {
        ContainerHorseChest animalchest = this.dragonInv;
        this.dragonInv = new ContainerHorseChest("dragonInventory", 4);
        this.dragonInv.func_110133_a(this.func_70005_c_());
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.dragonInv.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.dragonInv.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.HEAD, this.getArmorOrdinal(this.dragonInv.func_70301_a(0))));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.CHEST, this.getArmorOrdinal(this.dragonInv.func_70301_a(1))));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.LEGS, this.getArmorOrdinal(this.dragonInv.func_70301_a(2))));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.FEET, this.getArmorOrdinal(this.dragonInv.func_70301_a(3))));
        }
    }

    public void updateDragonSlots() {
        int armorHead = this.getArmorOrdinal(this.dragonInv.func_70301_a(0));
        int armorNeck = this.getArmorOrdinal(this.dragonInv.func_70301_a(1));
        int armorBody = this.getArmorOrdinal(this.dragonInv.func_70301_a(2));
        int armorTail = this.getArmorOrdinal(this.dragonInv.func_70301_a(3));
        this.setArmorInSlot(EntityEquipmentSlot.HEAD, armorHead);
        this.setArmorInSlot(EntityEquipmentSlot.CHEST, armorNeck);
        this.setArmorInSlot(EntityEquipmentSlot.LEGS, armorBody);
        this.setArmorInSlot(EntityEquipmentSlot.FEET, armorTail);
        if (this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.HEAD, armorHead));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.CHEST, armorNeck));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.LEGS, armorBody));
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.FEET, armorTail));
        }
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        double baseArmor = this.minimumArmor + armorStep * (double)Math.min(this.getAgeInDays(), 125);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(baseArmor + this.calculateArmorModifier());
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            playerEntity.openGui((Object)IceAndFire.INSTANCE, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public int func_70627_aG() {
        return 90;
    }

    protected void func_70609_aI() {
        this.field_70725_aQ = 0;
        if (!this.isModelDead() && !this.field_70170_p.field_72995_K && this.field_70718_bc > 0) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        this.setModelDead(true);
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            double d1;
            double d0;
            int k;
            this.func_70106_y();
            for (k = 0; k < 40; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (!this.field_70170_p.field_72995_K) continue;
                ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
            for (k = 0; k < 3; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.dragonType == EnumDragonType.FIRE && this.field_70170_p.field_72995_K) {
                    ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.FLAME, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
                    continue;
                }
                if (this.dragonType == EnumDragonType.ICE && this.field_70170_p.field_72995_K) {
                    IceAndFire.PROXY.spawnParticle(EnumParticle.SNOWFLAKE, this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
                    continue;
                }
                if (this.dragonType != EnumDragonType.LIGHTNING || !this.field_70170_p.field_72995_K) continue;
                IceAndFire.PROXY.spawnParticle(EnumParticle.SPARK, this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
            }
        }
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && this.isBoundToCrystal()) {
            DragonPosWorldData.get(this.field_70170_p).removeDragon(this.func_110124_au());
        }
        this.removeParts();
        super.func_70106_y();
    }

    protected int func_70693_a(EntityPlayer player) {
        switch (this.getDragonStage()) {
            case 2: {
                return 20;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 100;
            }
            case 5: {
                return 150;
            }
        }
        return 5;
    }

    public int getArmorOrdinal(ItemStack stack) {
        Item item;
        Item item2 = item = !stack.func_190926_b() ? stack.func_77973_b() : null;
        if (item instanceof ItemDragonArmor) {
            return ((ItemDragonArmor)item).type.ordinal() + 1;
        }
        return 0;
    }

    public boolean func_175446_cd() {
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        return this.isModelDead() || capability == null || capability.isStoned() || super.func_175446_cd();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(AGE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(FIREBREATHING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HOVERING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(FLYING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HEAD_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(NECK_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(BODY_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(TAIL_ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(DEATH_STAGE, (Object)0);
        this.field_70180_af.func_187214_a(MODEL_DEAD, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(TACKLE, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(AGINGDISABLED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(CRYSTAL_BOUND, (Object)Boolean.FALSE);
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean strike() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 4 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (command == 1) {
            this.func_70904_g(true);
        } else {
            this.func_70904_g(false);
        }
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.isBoundToCrystal()) {
            compound.func_186854_a("UUID", this.func_110124_au());
        }
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74768_a("AgeTicks", this.getAgeInTicks());
        compound.func_74757_a("Gender", this.isMale());
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Sleeping", this.isSleeping());
        compound.func_74757_a("FireBreathing", this.isBreathingFire());
        compound.func_74757_a("AttackDecision", this.attackDecision);
        compound.func_74757_a("Hovering", this.isHovering());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("ArmorHead", this.getArmorInSlot(EntityEquipmentSlot.HEAD));
        compound.func_74768_a("ArmorNeck", this.getArmorInSlot(EntityEquipmentSlot.CHEST));
        compound.func_74768_a("ArmorBody", this.getArmorInSlot(EntityEquipmentSlot.LEGS));
        compound.func_74768_a("ArmorTail", this.getArmorInSlot(EntityEquipmentSlot.FEET));
        compound.func_74768_a("DeathStage", this.getDeathStage());
        compound.func_74757_a("ModelDead", this.isModelDead());
        compound.func_74776_a("DeadProg", this.modelDeadProgress);
        compound.func_74757_a("Tackle", this.isTackling());
        if (this.dragonInv != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.dragonInv.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInv.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (this.func_95999_t() != null && !this.func_95999_t().isEmpty()) {
            compound.func_74778_a("CustomName", this.func_95999_t());
        }
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.func_74768_a("HomeAreaX", this.homePos.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homePos.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homePos.func_177952_p());
        }
        compound.func_74757_a("AgingDisabled", this.isAgingDisabled());
        compound.func_74768_a("Command", this.getCommand());
        compound.func_74757_a("CrystalBound", this.isBoundToCrystal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("UUID")) {
            this.field_96093_i = compound.func_186857_a("UUID");
            this.field_189513_ar = this.field_96093_i.toString();
        }
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setAgeInTicks(compound.func_74762_e("AgeTicks"));
        this.setGender(compound.func_74767_n("Gender"));
        this.setVariant(compound.func_74762_e("Variant"));
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.setBreathingFire(compound.func_74767_n("FireBreathing"));
        this.attackDecision = compound.func_74767_n("AttackDecision");
        this.setHovering(compound.func_74767_n("Hovering"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setArmorInSlot(EntityEquipmentSlot.HEAD, compound.func_74762_e("ArmorHead"));
        this.setArmorInSlot(EntityEquipmentSlot.CHEST, compound.func_74762_e("ArmorNeck"));
        this.setArmorInSlot(EntityEquipmentSlot.LEGS, compound.func_74762_e("ArmorBody"));
        this.setArmorInSlot(EntityEquipmentSlot.FEET, compound.func_74762_e("ArmorTail"));
        if (this.dragonInv != null) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initDragonInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int dragonInvSlot = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (dragonInvSlot > 4) continue;
                this.dragonInv.func_70299_a(dragonInvSlot, new ItemStack(nbttagcompound));
            }
        } else {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initDragonInv();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int dragonInvSlot = nbttagcompound.func_74771_c("Slot") & 0xFF;
                this.initDragonInv();
                this.dragonInv.func_70299_a(dragonInvSlot, new ItemStack(nbttagcompound));
                this.setArmorInSlot(DragonUtils.getEquipmentSlotFromDragonInvSlot(dragonInvSlot), this.getArmorOrdinal(new ItemStack(nbttagcompound)));
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.HEAD, this.getArmorOrdinal(new ItemStack(nbttagcompound))));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.CHEST, this.getArmorOrdinal(new ItemStack(nbttagcompound))));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.LEGS, this.getArmorOrdinal(new ItemStack(nbttagcompound))));
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), EntityEquipmentSlot.FEET, this.getArmorOrdinal(new ItemStack(nbttagcompound))));
            }
        }
        this.setDeathStage(compound.func_74762_e("DeathStage"));
        this.setModelDead(compound.func_74767_n("ModelDead"));
        this.modelDeadProgress = compound.func_74760_g("DeadProg");
        if (!compound.func_74779_i("CustomName").isEmpty()) {
            this.func_96094_a(compound.func_74779_i("CustomName"));
        }
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
        this.setTackling(compound.func_74767_n("Tackle"));
        this.setAgingDisabled(compound.func_74767_n("AgingDisabled"));
        this.setCommand(compound.func_74762_e("Command"));
        this.setCrystalBound(compound.func_74767_n("CrystalBound"));
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (passenger instanceof EntityPlayer && this.func_70638_az() != passenger) {
                EntityPlayer player = (EntityPlayer)passenger;
                if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
                return player;
            }
            if (!(passenger instanceof EntityLiving) || !DragonUtils.isDragonRider(passenger)) continue;
            return passenger;
        }
        return null;
    }

    public boolean isPlayerControlled() {
        return this.func_184179_bs() instanceof EntityPlayer;
    }

    public boolean isControllingPassenger(Entity entity) {
        return this.func_184179_bs() != null && this.func_184179_bs().func_110124_au().equals(entity.func_110124_au());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)Math.min(2048, IceAndFireConfig.DRAGON_SETTINGS.dragonTargetSearchLength));
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    protected void updateAttributes() {
        int armorHead = this.getArmorInSlot(EntityEquipmentSlot.HEAD);
        int armorNeck = this.getArmorInSlot(EntityEquipmentSlot.CHEST);
        int armorLegs = this.getArmorInSlot(EntityEquipmentSlot.LEGS);
        int armorFeet = this.getArmorInSlot(EntityEquipmentSlot.FEET);
        String armorResLoc = this.dragonType.getName() + "|" + armorHead + "|" + armorNeck + "|" + armorLegs + "|" + armorFeet;
        IceAndFire.PROXY.updateDragonArmorRender(armorResLoc);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        int age = Math.min(this.getAgeInDays(), 125);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(this.minimumHealth + healthStep * (double)age));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(this.minimumDamage + attackStep * (double)age));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.minimumSpeed + speedStep * (double)age);
        double baseArmor = this.minimumArmor + armorStep * (double)age;
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(baseArmor + this.calculateArmorModifier());
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)Math.min(100, hunger));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_70180_af.func_187225_a(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.field_70180_af.func_187227_b(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.field_70180_af.func_187225_a(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.field_70180_af.func_187227_b(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER);
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean isModelDead() {
        if (this.field_70170_p.field_72995_K) {
            this.isModelDead = (Boolean)this.field_70180_af.func_187225_a(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.field_70180_af.func_187227_b(MODEL_DEAD, (Object)modeldead);
        if (!this.field_70170_p.field_72995_K) {
            this.isModelDead = modeldead;
        }
    }

    public boolean isHovering() {
        if (this.field_70170_p.field_72995_K) {
            this.isHovering = (Boolean)this.field_70180_af.func_187225_a(HOVERING);
            return this.isHovering;
        }
        return this.isHovering;
    }

    public void setHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(HOVERING, (Object)hovering);
        if (!this.field_70170_p.field_72995_K) {
            this.isHovering = hovering;
        }
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public void setGender(boolean male) {
        this.field_70180_af.func_187227_b(GENDER, (Object)male);
    }

    public boolean isSleeping() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSleeping;
            this.isSleeping = isSleeping = ((Boolean)this.field_70180_af.func_187225_a(SLEEPING)).booleanValue();
            return isSleeping;
        }
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
        if (!this.field_70170_p.field_72995_K) {
            this.isSleeping = sleeping;
        }
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean isBreathingFire() {
        if (this.field_70170_p.field_72995_K) {
            boolean breathing;
            this.isBreathingFire = breathing = ((Boolean)this.field_70180_af.func_187225_a(FIREBREATHING)).booleanValue();
            return breathing;
        }
        return this.isBreathingFire;
    }

    public void setBreathingFire(boolean breathing) {
        this.field_70180_af.func_187227_b(FIREBREATHING, (Object)breathing);
        if (!this.field_70170_p.field_72995_K) {
            this.isBreathingFire = breathing;
        }
    }

    public void setTackling(boolean tackling) {
        this.field_70180_af.func_187227_b(TACKLE, (Object)tackling);
        if (!this.field_70170_p.field_72995_K) {
            this.isTackling = tackling;
        }
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.field_70180_af.func_187227_b(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.field_70180_af.func_187227_b(CRYSTAL_BOUND, (Object)crystalBound);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public int getArmorInSlot(EntityEquipmentSlot slot) {
        switch (slot) {
            default: {
                return (Integer)this.field_70180_af.func_187225_a(HEAD_ARMOR);
            }
            case CHEST: {
                return (Integer)this.field_70180_af.func_187225_a(NECK_ARMOR);
            }
            case LEGS: {
                return (Integer)this.field_70180_af.func_187225_a(BODY_ARMOR);
            }
            case FEET: 
        }
        return (Integer)this.field_70180_af.func_187225_a(TAIL_ARMOR);
    }

    public void riderShootFire(Entity controller) {
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((Entity)entity));
    }

    public void setArmorInSlot(EntityEquipmentSlot slot, int armorType) {
        switch (slot) {
            default: {
                this.field_70180_af.func_187227_b(HEAD_ARMOR, (Object)armorType);
                break;
            }
            case CHEST: {
                this.field_70180_af.func_187227_b(NECK_ARMOR, (Object)armorType);
                break;
            }
            case LEGS: {
                this.field_70180_af.func_187227_b(BODY_ARMOR, (Object)armorType);
                break;
            }
            case FEET: {
                this.field_70180_af.func_187227_b(TAIL_ARMOR, (Object)armorType);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonArmor(this.func_145782_y(), slot, armorType));
        }
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        double baseArmor = this.minimumArmor + armorStep * (double)Math.min(this.getAgeInDays(), 125);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(baseArmor + this.calculateArmorModifier());
    }

    private double calculateArmorModifier() {
        double val = 1.0;
        block7: for (EntityEquipmentSlot slot : ARMOR_SLOTS) {
            switch (this.getArmorInSlot(slot)) {
                case 1: {
                    val += 2.0;
                    continue block7;
                }
                case 2: {
                    val += 3.0;
                    continue block7;
                }
                case 3: {
                    val += 5.0;
                    continue block7;
                }
                case 4: {
                    val += 3.0;
                    continue block7;
                }
                case 5: {
                    val += 1.0;
                }
            }
        }
        return val;
    }

    public boolean canMove() {
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        if (capability != null && capability.isStoned()) {
            return false;
        }
        return !this.func_70906_o() && !this.isSleeping() && !this.isPlayerControlled() && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int lastDeathStage = this.getAgeInDays() / 5;
        if (this.isModelDead() && this.getDeathStage() < lastDeathStage && player.field_71075_bZ.field_75099_e) {
            if (!this.field_70170_p.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() == Items.field_151069_bo && this.getDeathStage() < lastDeathStage / 2 && IceAndFireConfig.DRAGON_SETTINGS.dragonDropBlood) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.setDeathStage(this.getDeathStage() + 1);
                player.field_71071_by.func_70441_a(new ItemStack(this.getBlood(), 1));
                return true;
            }
            if (!this.field_70170_p.field_72995_K && stack.func_190926_b() && IceAndFireConfig.DRAGON_SETTINGS.dragonDropSkull) {
                if (this.getDeathStage() == lastDeathStage - 1) {
                    ItemStack skull = this.getSkull();
                    skull.func_77982_d(new NBTTagCompound());
                    skull.func_77978_p().func_74768_a("Stage", this.getDragonStage());
                    skull.func_77978_p().func_74768_a("DragonType", 0);
                    skull.func_77978_p().func_74768_a("DragonAge", this.getAgeInDays());
                    this.setDeathStage(this.getDeathStage() + 1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(skull, 1.0f);
                    }
                    this.func_70106_y();
                } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && IceAndFireConfig.DRAGON_SETTINGS.dragonDropHeart) {
                    ItemStack heart = new ItemStack(this.getHeart(), 1);
                    ItemStack egg = new ItemStack(this.getVariantEgg(this.field_70146_Z.nextInt(4)), 1);
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(heart, 1.0f);
                        if (!this.isMale() && this.getDragonStage() > 3) {
                            this.func_70099_a(egg, 1.0f);
                        }
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                } else {
                    this.setDeathStage(this.getDeathStage() + 1);
                    ItemStack drop = this.getRandomDrop();
                    if (!drop.func_190926_b() && !this.field_70170_p.field_72995_K) {
                        this.func_70099_a(drop, 1.0f);
                    }
                }
            }
            return true;
        }
        if (!this.isModelDead()) {
            if (this.func_152114_e((EntityLivingBase)player)) {
                if (!stack.func_190926_b()) {
                    int itemFoodAmount;
                    if (this.func_70877_b(stack) && this.isAdult()) {
                        this.func_70873_a(0);
                        this.func_175505_a(player, stack);
                        this.func_146082_f(player);
                        return true;
                    }
                    if (stack.func_77973_b() == this.getSummoningCrystal()) {
                        if (!ItemSummoningCrystal.hasDragon(stack)) {
                            this.setCrystalBound(true);
                            NBTTagCompound compound = stack.func_77978_p();
                            if (compound == null) {
                                compound = new NBTTagCompound();
                                stack.func_77982_d(compound);
                            }
                            NBTTagCompound dragonTag = new NBTTagCompound();
                            dragonTag.func_186854_a("DragonUUID", this.func_110124_au());
                            dragonTag.func_74778_a("CustomName", this.func_95999_t());
                            compound.func_74782_a("Dragon", (NBTBase)dragonTag);
                            this.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
                            player.func_184609_a(hand);
                            return true;
                        }
                        if (ItemSummoningCrystal.isBoundTo(stack, this)) {
                            stack.func_77982_d(new NBTTagCompound());
                            this.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
                            player.func_184609_a(hand);
                            return true;
                        }
                    }
                    if ((itemFoodAmount = FoodUtils.getFoodPoints(stack, true, this.dragonType.isPiscivore())) > 0 && (this.getHunger() < 100 || this.func_110143_aJ() < this.func_110138_aP())) {
                        this.setHunger(this.getHunger() + itemFoodAmount);
                        this.func_70606_j(Math.min(this.func_110138_aP(), (float)((int)(this.func_110143_aJ() + (float)(itemFoodAmount / 10)))));
                        this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                        this.spawnItemCrackParticles(stack.func_77973_b());
                        this.eatFoodBonus(stack);
                        if (!player.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == IafItemRegistry.dragon_meal) {
                        this.growDragon(1);
                        this.setHunger(this.getHunger() + 20);
                        this.func_70691_i(Math.min(this.func_110143_aJ(), (float)((int)(this.func_110138_aP() / 2.0f))));
                        this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                        this.spawnItemCrackParticles(stack.func_77973_b());
                        this.spawnItemCrackParticles(Items.field_151103_aS);
                        this.spawnItemCrackParticles(Items.field_151100_aR);
                        this.eatFoodBonus(stack);
                        if (!player.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == IafItemRegistry.sickly_dragon_meal && !this.isAgingDisabled()) {
                        this.setHunger(this.getHunger() + 20);
                        this.func_70691_i(this.func_110138_aP());
                        this.func_184185_a(SoundEvents.field_187942_hp, this.func_70599_aP(), this.func_70647_i());
                        this.spawnItemCrackParticles(stack.func_77973_b());
                        this.spawnItemCrackParticles(Items.field_151103_aS);
                        this.spawnItemCrackParticles(Items.field_151100_aR);
                        this.spawnItemCrackParticles(Items.field_151170_bI);
                        this.spawnItemCrackParticles(Items.field_151170_bI);
                        this.setAgingDisabled(true);
                        this.eatFoodBonus(stack);
                        if (!player.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                        return true;
                    }
                    if (stack.func_77973_b() == IafItemRegistry.dragon_stick) {
                        if (player.func_70093_af()) {
                            this.homePos = new BlockPos((Entity)this);
                            this.hasHomePosition = true;
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("dragon.command.new_home", new Object[]{this.homePos.func_177958_n(), this.homePos.func_177956_o(), this.homePos.func_177952_p()}), true);
                        } else {
                            this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
                            this.setCommand(this.getCommand() + 1);
                            if (this.getCommand() > 1) {
                                this.setCommand(0);
                            }
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("dragon.command." + (this.getCommand() == 1 ? "sit" : "stand"), new Object[0]), true);
                        }
                        return true;
                    }
                    IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
                    if (!(stack.func_77973_b() != IafItemRegistry.dragon_horn || this.field_70170_p.field_72995_K || hand != EnumHand.MAIN_HAND || capability != null && capability.isStoned())) {
                        this.func_184185_a(SoundEvents.field_187941_ho, 3.0f, 1.25f);
                        NBTTagCompound tag = new NBTTagCompound();
                        this.func_70014_b(tag);
                        ItemStack horn = this.getHorn();
                        horn.func_77982_d(tag);
                        player.func_184611_a(hand, horn);
                        this.func_70106_y();
                        return true;
                    }
                } else {
                    if (!player.func_70093_af() && !this.field_70128_L) {
                        if (this.getDragonStage() < 2) {
                            this.func_184205_a((Entity)player, true);
                        }
                        if (this.getDragonStage() > 2 && !player.func_184218_aH()) {
                            player.func_184205_a((Entity)this, true);
                            if (this.field_70170_p.field_72995_K) {
                                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageUpdateRidingState(this.func_145782_y(), true));
                            }
                            this.setSleeping(false);
                        }
                        if (this.getDragonStage() < 2) {
                            this.func_184205_a((Entity)player, true);
                        }
                        return true;
                    }
                    if (stack.func_190926_b() && player.func_70093_af()) {
                        this.openGUI(player);
                        return true;
                    }
                }
            } else if (stack.func_77973_b() == IafItemRegistry.dragon_collar) {
                this.func_193101_c(player);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        if (stack.func_77973_b() == Items.field_151063_bx) {
            EntityAgeable entityageable;
            Class oclass;
            if (!this.field_70170_p.field_72995_K && (oclass = EntityList.getClass((ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)stack))) != null && this.getClass() == oclass && (entityageable = this.func_90011_a((EntityAgeable)this)) != null) {
                entityageable.func_70873_a(-24000);
                entityageable.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityageable);
                if (stack.func_82837_s()) {
                    entityageable.func_96094_a(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    protected abstract ItemStack getSkull();

    protected abstract ItemStack getHorn();

    public abstract Item getBlood();

    public abstract Item getHeart();

    public abstract Item getFlesh();

    protected abstract int getBaseEggTypeValue();

    private ItemStack getRandomDrop() {
        ItemStack stack = this.getItemFromLootTable();
        if (stack.func_77973_b() == IafItemRegistry.dragonbone) {
            this.func_184185_a(SoundEvents.field_187854_fc, 1.0f, 1.0f);
        } else {
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
        }
        return stack;
    }

    public abstract ResourceLocation getDeadLootTable();

    public ItemStack getItemFromLootTable() {
        List loot;
        LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(this.getDeadLootTable());
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(DamageSource.field_76377_j);
        if (this.field_70717_bb != null) {
            lootcontext$builder = lootcontext$builder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
        }
        if ((loot = loottable.func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a())).isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)loot.get(0);
    }

    public void eatFoodBonus(ItemStack stack) {
    }

    protected boolean func_70692_ba() {
        return IceAndFireConfig.DRAGON_SETTINGS.canDragonsDespawn;
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.func_98054_a(false);
        this.func_174829_m();
        if (this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
                float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
                float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
                if (this.field_70170_p.field_72995_K) {
                    ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.VILLAGER_HAPPY, f, (double)f1, (double)f2, motionX, motionY, motionZ, new int[0]);
                }
                ++i;
            }
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            Vec3d headPos = this.getHeadPosition();
            if (!this.field_70170_p.field_72995_K) continue;
            ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.ITEM_CRACK, headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, motionX, motionY, motionZ, Item.func_150891_b((Item)item), 0);
        }
    }

    protected boolean isTimeToWake() {
        return this.field_70170_p.func_72935_r();
    }

    private boolean isStuck() {
        return !this.func_70909_n() && (!this.func_70661_as().func_75500_f() && (this.func_70661_as().func_75505_d() == null || this.func_70661_as().func_75505_d().func_75870_c() != null && this.func_174818_b(new BlockPos(this.func_70661_as().func_75505_d().func_75870_c().field_75839_a, this.func_70661_as().func_75505_d().func_75870_c().field_75837_b, this.func_70661_as().func_75505_d().func_75870_c().field_75838_c)) > 15.0) || this.airTarget != null) && this.ticksStill > 80 && !this.isHovering() && this.canMove();
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        if (livingBase != null && this.getClass().equals(livingBase.getClass())) {
            if (((EntityDragonBase)livingBase).func_70909_n() && !DragonUtils.hasSameOwner((Entity)livingBase, (Entity)this)) {
                super.func_70604_c(livingBase);
            }
        } else {
            super.func_70604_c(livingBase);
        }
    }

    public void func_70636_d() {
        boolean riding;
        boolean flying;
        boolean sleeping;
        boolean sitting;
        super.func_70636_d();
        this.field_70138_W = (float)this.getDragonStage() * 0.5f;
        if (!this.isPlayerControlled() && this.isBeyondHeight() && !this.field_70122_E) {
            this.field_70181_x -= (double)0.1f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70906_o() && (this.getCommand() != 1 || this.func_184179_bs() != null)) {
                this.func_70904_g(false);
            }
            if (!this.func_70906_o() && this.getCommand() == 1 && this.func_184179_bs() == null) {
                this.func_70904_g(true);
            }
            if (this.func_70906_o()) {
                this.func_70661_as().func_75499_g();
            }
            if (this.func_70880_s()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
            }
            this.ticksStill = (int)this.field_70169_q == (int)this.field_70165_t && (int)this.field_70166_s == (int)this.field_70161_v ? ++this.ticksStill : 0;
            if (this.getDragonStage() >= 3 && this.isStuck() && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && IceAndFireConfig.DRAGON_SETTINGS.dragonGriefing != 2) {
                if (this.getAnimation() == NO_ANIMATION && this.field_70173_aa % 5 == 0) {
                    this.setAnimation(ANIMATION_TAILWHACK);
                }
                if (this.getAnimation() == ANIMATION_TAILWHACK && this.getAnimationTick() == 10) {
                    BlockBreakExplosion explosion = new BlockBreakExplosion(this.field_70170_p, (EntityCreature)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4 * this.getDragonStage() - 2);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                    this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
                }
            }
        }
        this.walkCycle = this.walkCycle < 39 ? ++this.walkCycle : 0;
        if (this.getAnimation() == ANIMATION_WINGBLAST && (this.getAnimationTick() == 17 || this.getAnimationTick() == 22 || this.getAnimationTick() == 28)) {
            this.spawnGroundEffects();
            if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 4.0f);
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), (float)this.getDragonStage() * 0.6f, 1.0, 1.0);
                this.attackDecision = this.func_70681_au().nextBoolean();
            }
        }
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        if (!this.field_70170_p.field_72995_K) {
            if (this.isTackling() && !this.isFlying() && this.field_70122_E) {
                ++this.tacklingTicks;
                if (this.tacklingTicks == 40) {
                    this.tacklingTicks = 0;
                    this.setTackling(false);
                    this.setFlying(false);
                }
            }
            if (this.func_70681_au().nextInt(500) == 0 && !this.isModelDead() && !this.isSleeping()) {
                this.roar();
            }
            if (this.field_70122_E && this.func_70661_as().func_75500_f() && this.func_70638_az() != null && this.func_70638_az().field_70163_u - 3.0 > this.field_70163_u && this.func_70681_au().nextInt(15) == 0 && this.canMove() && !this.isHovering() && !this.isFlying() && !this.func_70631_g_()) {
                this.setHovering(true);
                this.setSleeping(false);
                this.func_70904_g(false);
                this.hoverTicks = 0;
            }
            if (this.isFlying() && this.func_70638_az() != null && this.attackDecision && this.isDirectPathBetweenPoints(this.func_174791_d(), this.func_70638_az().func_174791_d())) {
                this.setTackling(true);
            }
            if (this.isFlying() && this.func_70638_az() != null && this.isTackling() && this.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.attackDecision = true;
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(this.getDragonStage() * 3));
                this.spawnGroundEffects();
                this.setFlying(false);
                this.setHovering(false);
            }
            if (this.isTackling() && this.func_70638_az() == null) {
                this.setTackling(false);
            }
            if (capability != null && capability.isStoned()) {
                this.setFlying(false);
                this.setHovering(false);
                return;
            }
            if (this.isFlying() && this.field_70173_aa % 40 == 0 || this.isFlying() && this.isSleeping()) {
                this.setFlying(true);
                this.setSleeping(false);
            }
            if (this.isModelDead() && (this.isFlying() || this.isHovering())) {
                this.setFlying(false);
                this.setHovering(false);
            }
            if (!this.canMove()) {
                this.func_70661_as().func_75499_g();
            }
            if (!this.canMove() && this.func_70638_az() != null) {
                this.func_70624_b(null);
            }
            if (!this.func_70909_n()) {
                this.updateCheckPlayer();
            }
        }
        this.field_70181_x = Math.min(this.field_70181_x, 0.5);
        this.field_70181_x = Math.max(this.field_70181_x, -0.5);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.legSolver.update((EntityLivingBase)this);
        if ((this.isFlying() || this.isHovering()) && !this.isModelDead()) {
            this.flightCycle = this.flightCycle < 58 ? (this.flightCycle += 2) : 0;
            if (this.flightCycle == 2) {
                this.func_184185_a(IafSoundRegistry.DRAGON_FLIGHT, this.func_70599_aP() * (float)IceAndFireConfig.DRAGON_SETTINGS.dragonFlapNoiseDistance, this.func_70647_i());
            }
        } else if (this.isModelDead()) {
            this.flightCycle = 0;
        }
        boolean bl = sitting = this.func_70906_o() && !this.isModelDead() && !this.isSleeping() && !this.isHovering() && !this.isFlying();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean bl2 = sleeping = this.isSleeping() && !this.isHovering() && !this.isFlying();
        if (sleeping && this.sleepProgress < 20.0f) {
            this.sleepProgress += 0.5f;
        } else if (!sleeping && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 0.5f;
        }
        boolean fireBreathing = this.isBreathingFire();
        this.prevFireBreathProgress = this.fireBreathProgress;
        if (fireBreathing && this.fireBreathProgress < 5.0f) {
            this.fireBreathProgress += 0.5f;
        } else if (!fireBreathing && this.fireBreathProgress > 0.0f) {
            this.fireBreathProgress -= 0.5f;
        }
        boolean hovering = this.isHovering();
        if (hovering && this.hoverProgress < 20.0f) {
            this.hoverProgress += 0.5f;
        } else if (!hovering && this.hoverProgress > 0.0f) {
            this.hoverProgress -= 0.5f;
        }
        boolean tackling = this.isTackling();
        if (tackling && this.tackleProgress < 5.0f) {
            this.tackleProgress += 0.5f;
        } else if (!tackling && this.tackleProgress > 0.0f) {
            this.tackleProgress -= 1.5f;
        }
        boolean bl3 = flying = !tackling && this.isFlying() || !this.field_70122_E && !this.isHovering() && this.airTarget != null;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 0.5f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 0.5f;
        }
        boolean isModelDead = this.isModelDead();
        if (isModelDead && this.modelDeadProgress < 20.0f) {
            this.modelDeadProgress += 0.5f;
        } else if (!isModelDead && this.modelDeadProgress > 0.0f) {
            this.modelDeadProgress -= 0.5f;
        }
        boolean bl4 = riding = this.func_184218_aH() && this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer;
        if (riding && this.ridingProgress < 20.0f) {
            this.ridingProgress += 0.5f;
        } else if (!riding && this.ridingProgress > 0.0f) {
            this.ridingProgress -= 0.5f;
        }
        if (this.isModelDead()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70122_E && this.doesWantToLand() && (this.isFlying() || this.isHovering())) {
                this.airTarget = null;
                this.setFlying(false);
                this.setHovering(false);
            }
            if (this.isHovering()) {
                if (this.isSleeping()) {
                    this.setHovering(false);
                }
                ++this.hoverTicks;
                if (this.doesWantToLand() && !this.field_70122_E) {
                    this.field_70181_x -= 0.25;
                } else {
                    if (!this.isPlayerControlled() && !this.isBeyondHeight()) {
                        this.field_70181_x += 0.08;
                    }
                    if (this.hoverTicks > 40) {
                        if (!this.func_70631_g_()) {
                            this.setFlying(true);
                        }
                        this.setHovering(false);
                        this.hoverTicks = 0;
                    }
                }
            }
            if (this.isSleeping()) {
                this.func_70661_as().func_75499_g();
            }
            if (!this.isPlayerControlled()) {
                if (!this.isFlying() && !this.isHovering() && this.airTarget != null && this.field_70122_E) {
                    this.airTarget = null;
                }
                if (this.isFlying() && this.airTarget == null && this.field_70122_E) {
                    this.setFlying(false);
                    this.setHovering(false);
                }
                if (this.isFlying() && this.func_70638_az() == null) {
                    this.flyAround();
                } else if (this.airTarget != null) {
                    this.flyTowardsTarget();
                }
            } else {
                this.airTarget = null;
            }
            if (this.field_70122_E && this.flyTicks != 0) {
                this.flyTicks = 0;
            }
            if (this.isFlying() && this.doesWantToLand()) {
                this.setFlying(false);
                this.setHovering(!this.field_70122_E);
                if (this.field_70122_E) {
                    this.hoverTicks = 0;
                }
            }
            if (this.isFlying()) {
                ++this.flyTicks;
            }
            if ((this.isHovering() || this.isFlying()) && this.isSleeping()) {
                this.setFlying(false);
                this.setHovering(false);
            }
            if (!(capability != null && capability.isStoned() || (this.func_70681_au().nextInt(1500) != 0 || this.isFlying() || this.func_70631_g_() || this.isHovering() || !this.canMove() || !this.field_70122_E) && !(this.field_70163_u < -1.0))) {
                this.setHovering(true);
                this.setSleeping(false);
                this.func_70904_g(false);
                this.hoverTicks = 0;
            }
            if (this.func_70638_az() != null && this.func_70638_az().field_70163_u + 5.0 < this.field_70163_u && !this.isFlying() && !this.func_70631_g_() && !this.isHovering() && this.canMove() && this.field_70122_E) {
                this.setHovering(true);
                this.setSleeping(false);
                this.func_70904_g(false);
                this.hoverTicks = 0;
            }
            if (!(!this.func_70090_H() || this.func_70638_az() == null || this.func_70681_au().nextInt(15) != 0 || capability != null && capability.isStoned() || !this.canMove() || this.isHovering() || this.isFlying() || this.func_70631_g_())) {
                this.setHovering(true);
                this.setSleeping(false);
                this.func_70904_g(false);
                this.hoverTicks = 0;
            }
            if (this.func_70638_az() != null && this.isPlayerControlled()) {
                this.func_70624_b(null);
            }
        }
        if (this.isPlayerControlled() && !this.field_70122_E && (this.isFlying() || this.isHovering())) {
            this.field_70181_x *= 0.0;
        }
        if (!this.isAgingDisabled()) {
            this.setAgeInTicks(this.getAgeInTicks() + 1);
            if (this.getAgeInTicks() % 24000 == 0) {
                this.growDragon(0);
            }
        }
        if (this.getAgeInTicks() % IceAndFireConfig.DRAGON_SETTINGS.dragonHungerTickRate == 0 && this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackDecision && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) > Math.min(this.func_174813_aQ().func_72320_b() * 5.0, 25.0) && !this.func_70631_g_()) {
                this.attackDecision = false;
            }
            if ((!this.attackDecision || this.func_70681_au().nextInt(750) == 0) && this.func_70631_g_()) {
                this.attackDecision = this.func_70681_au().nextBoolean();
                ArrayList<MessageParticleFX.Particle> particles = new ArrayList<MessageParticleFX.Particle>();
                Vec3d headPos = this.getHeadPosition();
                for (int i = 0; i < 5; ++i) {
                    particles.add(MessageParticleFX.createParticle(headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, 0.0, 0.0, 0.0));
                }
                EnumParticle particleType = EnumParticle.SMOKE_LARGE;
                if (this.dragonType == EnumDragonType.ICE) {
                    particleType = EnumParticle.DRAGON_ICE;
                } else if (this.dragonType == EnumDragonType.LIGHTNING) {
                    particleType = EnumParticle.SPARK;
                }
                IceAndFire.NETWORK_WRAPPER.sendToAllTracking((IMessage)new MessageParticleFX(particleType, particles), (Entity)this);
                if (this.dragonType == EnumDragonType.ICE) {
                    this.func_184185_a(IafSoundRegistry.ICEDRAGON_BREATH_SHORT, 3.0f, 1.0f);
                } else if (this.dragonType == EnumDragonType.LIGHTNING) {
                    this.func_184185_a(IafSoundRegistry.LIGHTNINGDRAGON_BREATH_SHORT, 3.0f, 1.0f);
                } else {
                    this.func_184185_a(IafSoundRegistry.FIREDRAGON_BREATH_SHORT, 3.0f, 1.0f);
                }
            }
            if (this.isBreathingFire()) {
                ++this.fireTicks;
                if (this.fireTicks > this.getDragonStage() * 25 || this.fireStopTicks <= 0 && this.isPlayerControlled()) {
                    this.setBreathingFire(false);
                    this.attackDecision = this.func_70681_au().nextBoolean();
                    this.fireTicks = 0;
                }
                if (this.fireStopTicks > 0 && this.isPlayerControlled()) {
                    --this.fireStopTicks;
                }
            }
            if (this.isFlying() && this.func_70638_az() != null && this.func_174813_aQ().func_72321_a(3.0, 3.0, 3.0).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70652_k((Entity)this.func_70638_az());
            }
            this.breakBlock();
        }
    }

    private boolean isBeyondHeight() {
        if (this.field_70163_u > (double)this.field_70170_p.func_72800_K()) {
            return true;
        }
        return this.field_70163_u > (double)DragonUtils.getMaximumFlightHeightForPos(this.field_70170_p, new BlockPos((Entity)this));
    }

    public void breakBlock() {
        if (IceAndFireConfig.DRAGON_SETTINGS.dragonGriefing != 2 && (!this.func_70909_n() || IceAndFireConfig.DRAGON_SETTINGS.tamedDragonGriefing)) {
            float hardness;
            float f = hardness = IceAndFireConfig.DRAGON_SETTINGS.dragonGriefing == 1 || this.getDragonStage() <= 3 ? 1.6f : 5.0f;
            if (!this.isModelDead() && this.getDragonStage() >= 3 && (this.canMove() || this.isPlayerControlled())) {
                for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 1; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 1; ++a) {
                    for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) + 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                        for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 1; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 1; ++c) {
                            IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(a, b, c));
                            Block block = state.func_177230_c();
                            BlockPos pos = new BlockPos(a, b, c);
                            if (state.func_185904_a() == Material.field_151579_a || block instanceof BlockBush || block instanceof BlockLiquid || !(state.func_185887_b(this.field_70170_p, pos) < hardness) || !DragonUtils.canDragonBreak(this.field_70170_p, state.func_177230_c(), pos) || !this.canDestroyBlock(pos)) continue;
                            this.field_70159_w *= 0.6;
                            this.field_70179_y *= 0.6;
                            DragonUtils.destroyBlock(this.field_70170_p, new BlockPos(a, b, c), state);
                        }
                    }
                }
            }
        }
    }

    public void spawnGroundEffects() {
        int i = 0;
        while ((float)i < this.getRenderSize()) {
            for (int i1 = 0; i1 < 20; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                BlockPos ground = this.getGround(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + extraX)), MathHelper.func_76128_c((double)(this.field_70163_u + extraY)) - 1, MathHelper.func_76128_c((double)(this.field_70161_v + extraZ))));
                IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Vec3i)ground));
                if (iblockstate.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                ParticleHelper.spawnParticle(this.field_70170_p, EnumParticleTypes.BLOCK_CRACK, true, this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ, motionX, motionY, motionZ, Block.func_176210_f((IBlockState)iblockstate));
            }
            ++i;
        }
    }

    private BlockPos getGround(BlockPos blockPos) {
        while (this.field_70170_p.func_175623_d(blockPos) && blockPos.func_177956_o() > 1) {
            blockPos = blockPos.func_177977_b();
        }
        return blockPos;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean isActuallyBreathingFire() {
        return this.fireTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        IEntityEffectCapability capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        return this.flyTicks > 6000 || this.down() || this.flyTicks > 40 && this.flyProgress == 0.0f || capability != null && capability.isStoned();
    }

    public abstract String getVariantName(int var1);

    public boolean shouldRiderSit() {
        return this.func_184179_bs() != null;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            if (this.func_184179_bs() == null || !this.isControllingPassenger(passenger)) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.func_184210_p();
                }
                float speed_walk = 0.2f;
                float speed_idle = 0.05f;
                float speed_fly = 0.2f;
                float degree_walk = 0.5f;
                float degree_idle = 0.5f;
                float degree_fly = 0.5f;
                if (passenger instanceof EntityPlayer) {
                    this.field_70761_aq = this.field_70177_z;
                    this.field_70177_z = passenger.field_70177_z;
                }
                float hoverAddition = this.hoverProgress * -0.001f;
                float flyAddition = this.flyProgress * -1.0E-4f;
                float flyBody = Math.max(this.flyProgress, this.hoverProgress) * 0.0065f;
                float radius = 0.75f * ((0.3f - flyBody) * this.getRenderSize()) + this.getRenderSize() / 3.0f * flyAddition * 0.0065f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                float bob0 = this.isFlying() || this.isHovering() ? (this.hoverProgress > 0.0f || this.flyProgress > 0.0f ? this.bob(-speed_fly, degree_fly * 5.0f, false, this.field_70173_aa, -0.0625f) : 0.0f) : 0.0f;
                float bob1 = this.bob(speed_walk * 2.0f, degree_walk * 1.7f, false, this.field_184619_aG, this.field_70721_aZ * -0.0625f);
                float bob2 = this.bob(speed_idle, degree_idle * 1.3f, false, this.field_70173_aa, -0.0625f);
                float extraAgeScale = (float)Math.max(0, this.getAgeInDays() - 75) / 75.0f * 1.65f;
                double extraY_pre = 0.8f;
                double extraY = (extraY_pre - (double)hoverAddition + (double)flyAddition) * (double)(this.getRenderSize() / 3.0f) - 0.35 * (double)(1.0f - this.getRenderSize() / 30.0f) + (double)bob0 + (double)bob1 + (double)bob2 + (double)extraAgeScale;
                passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        float bob = (float)(Math.sin(f * speed) * (double)f1 * (double)degree - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    private void updatePreyInMouth(Entity prey) {
        this.setAnimation(ANIMATION_SHAKEPREY);
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            this.doBiteAttack(prey);
            prey.func_184210_p();
        }
        this.field_70761_aq = this.field_70177_z;
        float modTick_0 = this.getAnimationTick() - 25;
        float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * MathHelper.func_76131_a((float)MathHelper.func_76126_a((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
        float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
        float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
        float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f + modTick_1 * 2.0f * 0.015f;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
        prey.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() < 4 && this.getDragonStage() > 2;
    }

    public boolean isAdult() {
        return this.getDragonStage() >= 4;
    }

    public boolean func_70631_g_() {
        return this.getDragonStage() < 2;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setGender(this.func_70681_au().nextBoolean());
        int age = this.func_70681_au().nextInt(80) + 1;
        this.growDragon(age);
        this.setVariant(new Random().nextInt(4));
        this.setSleeping(false);
        this.updateAttributes();
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.func_70691_i(Math.round(this.minimumHealth + healthStep * (double)age));
        this.attackDecision = true;
        this.setHunger(50);
        return livingdata;
    }

    public boolean func_70601_bi() {
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return state.func_189884_a((Entity)this);
    }

    public boolean doBiteAttack(Entity entity) {
        float changed;
        boolean success;
        float prevHealth = 0.0f;
        if (entity instanceof EntityLivingBase) {
            prevHealth = ((EntityLivingBase)entity).func_110143_aJ();
        }
        if ((success = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) && entity instanceof EntityLivingBase && (changed = (float)IceAndFireConfig.DRAGON_SETTINGS.dragonBiteHeal * Math.max(0.0f, Math.min(40.0f, prevHealth - ((EntityLivingBase)entity).func_110143_aJ()))) > 1.0f) {
            this.func_70691_i(changed);
        }
        return success;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.isModelDead()) {
            return false;
        }
        if (this.func_184207_aI() && dmg.func_76346_g() != null && this.func_184179_bs() != null && dmg.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        if ((dmg.field_76373_n.contains("arrow") || this.func_184187_bx() != null && dmg.func_76346_g() != null && dmg.func_76346_g().func_70028_i(this.func_184187_bx())) && this.func_184218_aH()) {
            return false;
        }
        if (dmg == DamageSource.field_76368_d || dmg == DamageSource.field_82729_p) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && dmg.func_76346_g() != null && this.func_70681_au().nextInt(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.isSleeping()) {
            this.setSleeping(false);
            if (!this.func_70909_n() && dmg.func_76346_g() instanceof EntityPlayer) {
                this.func_70624_b((EntityLivingBase)((EntityPlayer)dmg.func_76346_g()));
            }
        }
        return super.func_70097_a(dmg, i);
    }

    public void func_70071_h_() {
        IEntityEffectCapability capability;
        super.func_70071_h_();
        this.updateParts();
        this.func_98054_a(true);
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.isModelDead()) {
            return;
        }
        if (this.up()) {
            if (!this.isFlying() && !this.isHovering()) {
                this.spacebarTicks += 2;
            }
            if (this.isFlying() || this.isHovering()) {
                this.field_70181_x += 0.4;
            }
        } else if (this.dismount() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x -= 0.4;
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.down() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x -= 0.4;
        }
        if (!this.dismount() && (this.isFlying() || this.isHovering())) {
            this.field_70181_x += 0.01;
        }
        if (this.attack() && this.isPlayerControlled() && this.getDragonStage() > 1) {
            this.setBreathingFire(true);
            this.riderShootFire(this.func_184179_bs());
            this.fireStopTicks = 10;
        }
        if (this.strike() && this.isPlayerControlled()) {
            EntityLivingBase target = DragonUtils.riderLookingAtEntity((EntityLivingBase)this, (EntityLivingBase)((EntityPlayer)this.func_184179_bs()), (double)this.getDragonStage() + (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a));
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
            }
            if (target != null && !DragonUtils.hasSameOwner((Entity)this, (Entity)target)) {
                this.doBiteAttack((Entity)target);
            }
        }
        if (this.isPlayerControlled() && this.func_184179_bs().func_70093_af()) {
            this.func_184179_bs().func_70095_a(false);
            this.func_184179_bs().func_184210_p();
            if (this.field_70170_p.field_72995_K) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageUpdateRidingState(this.func_145782_y(), false));
            }
        }
        if (this.isFlying() && !this.isHovering() && this.isPlayerControlled() && !this.field_70122_E && Math.max(Math.abs(this.field_70179_y), Math.abs(this.field_70159_w)) < (double)0.1f) {
            this.setHovering(true);
            this.setFlying(false);
            this.hoverTicks = 0;
        } else if (this.isHovering() && !this.isFlying() && this.isPlayerControlled() && !this.field_70122_E && Math.max(Math.abs(this.field_70179_y), Math.abs(this.field_70159_w)) > (double)0.1f) {
            this.setFlying(true);
            this.setHovering(false);
        }
        if (this.spacebarTicks > 0) {
            --this.spacebarTicks;
        }
        if (!this.field_70170_p.field_72995_K && this.spacebarTicks > 20 && this.isPlayerControlled() && !this.isFlying() && !this.isHovering()) {
            this.setHovering(true);
            this.hoverTicks = 0;
        }
        if (this.field_70170_p.field_72995_K && !this.isModelDead()) {
            this.roll_buffer.calculateChainFlapBuffer(50.0f, 10, 4.0f, (EntityLivingBase)this);
            this.turn_buffer.calculateChainSwingBuffer(50.0f, 0, 4.0f, (EntityLivingBase)this);
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 10, 2.5f, (EntityLivingBase)this);
        }
        if (this.func_70638_az() != null && this.func_184187_bx() == null && this.func_70638_az().field_70128_L || this.func_70638_az() != null && this.func_70638_az() instanceof EntityDragonBase && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K && (capability = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this)) != null && !capability.isStoned()) {
            if (!(this.func_70090_H() || this.isSleeping() || !this.field_70122_E || this.isFlying() || this.isHovering() || this.func_70638_az() != null || this.isTimeToWake() || this.func_70681_au().nextInt(250) != 0 || this.func_70638_az() != null || !this.func_184188_bt().isEmpty())) {
                this.setSleeping(true);
            }
            if (this.isSleeping() && (this.isFlying() || this.isHovering() || this.func_70090_H() || this.field_70170_p.func_175710_j(new BlockPos((Entity)this)) && this.isTimeToWake() && !this.func_70909_n() || this.isTimeToWake() && this.func_70909_n() || this.func_70638_az() != null || !this.func_184188_bt().isEmpty())) {
                this.setSleeping(false);
            }
            if (this.func_70906_o() && this.func_184179_bs() != null) {
                this.func_70904_g(false);
            }
        }
    }

    public void func_98054_a(boolean par1) {
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        this.func_98055_j(scale);
        if (scale != this.lastScale) {
            this.resetParts(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public float getRenderSize() {
        int stage = this.getDragonStage() - 1;
        float step = (this.growth_stages[stage][1] - this.growth_stages[stage][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return this.growth_stages[stage][0] + step * 25.0f;
        }
        return this.growth_stages[stage][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isTackling()) {
            return false;
        }
        if (this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity.field_70128_L) {
            this.func_184210_p();
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.func_184196_w((Entity)this) && riding instanceof EntityPlayer) {
            int i = riding.func_184188_bt().indexOf(this);
            float radius = (i == 2 ? 0.0f : 0.5f) + (float)(((EntityPlayer)riding).func_184613_cA() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((EntityPlayer)riding).field_70761_aq + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = (riding.func_70093_af() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.field_70177_z = ((EntityPlayer)riding).field_70759_as;
            this.field_70759_as = ((EntityPlayer)riding).field_70759_as;
            this.field_70126_B = ((EntityPlayer)riding).field_70759_as;
            this.func_70107_b(riding.field_70165_t + extraX, riding.field_70163_u + extraY, riding.field_70161_v + extraZ);
            if (this.getControlState() == 16 || ((EntityPlayer)riding).func_184613_cA()) {
                this.func_184210_p();
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void func_70642_aH() {
        if (!this.isSleeping() && !this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_70642_aH();
        }
    }

    protected void func_184581_c(DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_184581_c(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityDragonBase && otherAnimal != this && otherAnimal.getClass() == this.getClass()) {
            EntityDragonBase dragon = (EntityDragonBase)otherAnimal;
            if (!this.isAdult() || !this.func_70880_s() || this.func_184207_aI()) {
                return false;
            }
            if (!dragon.isAdult() || !dragon.func_70880_s() || dragon.func_184207_aI()) {
                return false;
            }
            return this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale();
        }
        return false;
    }

    public EntityDragonEgg createEgg(EntityDragonBase mate) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        EntityDragonEgg dragon = new EntityDragonEgg(this.field_70170_p);
        int rand = new Random().nextInt(100);
        int typeValue = this.getBaseEggTypeValue();
        typeValue = rand >= 70 ? (typeValue += this.getVariant()) : (rand >= 40 ? (typeValue += mate.getVariant()) : (typeValue += rand % 4));
        dragon.setType(EnumDragonEgg.byMetadata(typeValue));
        dragon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
        return dragon;
    }

    public void flyAround() {
        if (this.airTarget != null) {
            if (this.doesWantToLand()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    public boolean isTargetBlocked(Vec3d target) {
        RayTraceResult rayTrace;
        if (target != null && (rayTrace = this.field_70170_p.func_72901_a(new Vec3d((Vec3i)this.func_180425_c()), target, false)) != null && rayTrace.field_72307_f != null) {
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(pos) || this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h && this.dragonType == EnumDragonType.ICE) {
                return true;
            }
            return rayTrace.field_72313_a != RayTraceResult.Type.BLOCK;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null) {
            return;
        }
        maximumDragonFlightHeight = DragonUtils.getMaximumFlightHeightForPos(this.field_70170_p, new BlockPos((Vec3i)this.airTarget));
        if (this.airTarget.func_177956_o() > maximumDragonFlightHeight) {
            this.airTarget = new BlockPos(this.airTarget.func_177958_n(), maximumDragonFlightHeight, this.airTarget.func_177952_p());
        }
        if (!this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
        if (this.getDistanceSquared(v0) > 3.0f) {
            y = this.attackDecision != false ? (double)this.airTarget.func_177956_o() : this.field_70163_u;
            targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.field_70165_t;
            targetY = Math.min(y, (double)maximumDragonFlightHeight) + 1.0 - this.field_70163_u;
            targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * this.getFlySpeed();
            this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * this.getFlySpeed();
            this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * this.getFlySpeed();
            this.field_191988_bg = 0.5f;
            d0 = (double)this.airTarget.func_177958_n() + 0.5 - this.field_70165_t;
            d2 = (double)this.airTarget.func_177952_p() + 0.5 - this.field_70161_v;
            d1 = y + 0.5 - this.field_70163_u;
            d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
            this.field_70125_A = this.updateRotation(this.field_70125_A, f1, 30.0f);
            this.field_70177_z = this.updateRotation(this.field_70177_z, f, 30.0f);
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null) {
            if (!this.isFlying()) {
                this.setFlying(true);
                this.setHovering(false);
                this.hoverTicks = 0;
            }
            v1 = new Vec3d((double)this.airTarget.func_177958_n(), this.field_70163_u, (double)this.airTarget.func_177952_p());
            if (this.getDistanceSquared(v1) < 3.0f && this.doesWantToLand()) {
                this.setFlying(false);
                this.setHovering(true);
            }
        }
    }

    private double getFlySpeed() {
        return (2.0 + (double)this.getAgeInDays() / 125.0 * 2.0) * (double)(this.isTackling() ? 2 : 1);
    }

    private boolean isTackling() {
        if (this.field_70170_p.field_72995_K) {
            boolean tackling;
            this.isTackling = tackling = ((Boolean)this.field_70180_af.func_187225_a(TACKLE)).booleanValue();
            return tackling;
        }
        return this.isTackling;
    }

    private boolean isAgingDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(AGINGDISABLED);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.field_70180_af.func_187225_a(CRYSTAL_BOUND);
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && this.isPosInAir(this.airTarget);
    }

    public boolean isPosInAir(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
            return true;
        }
        if (this instanceof EntityIceDragon) {
            return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public float getDistanceSquared(Vec3d vec3d) {
        float f = (float)(this.field_70165_t - vec3d.field_72450_a);
        float f1 = (float)(this.field_70163_u - vec3d.field_72448_b);
        float f2 = (float)(this.field_70161_v - vec3d.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.dragonInv.func_70302_i_()) {
            this.dragonInv.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public abstract Item getVariantScale(int var1);

    public abstract Item getVariantEgg(int var1);

    public abstract Item getSummoningCrystal();

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isControllingPassenger((Entity)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(ModKeys.dragon_down.func_151470_d());
            this.attack(ModKeys.dragon_fireAttack.func_151470_d());
            this.strike(ModKeys.dragon_strike.func_151470_d());
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70104_M() {
        return !this.isModelDead();
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        EntityLivingBase controller;
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.func_184207_aI()) {
            strafe = 0.0f;
            forward = 0.0f;
            vertical = 0.0f;
            super.func_191986_a(strafe, forward, vertical);
            return;
        }
        if (this.isPlayerControlled() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null && controller != this.func_70638_az()) {
            this.field_70126_B = this.field_70177_z = controller.field_70177_z;
            this.field_70125_A = controller.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.isFlying() || this.isHovering()) {
                this.field_70159_w *= 1.06;
                this.field_70179_y *= 1.06;
            }
            this.field_70747_aH = 0.05f;
            this.func_70659_e(this.field_70122_E ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : (float)this.getFlySpeed());
            super.func_191986_a(strafe, 0.0f, forward);
            return;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    public void updateCheckPlayer() {
        double checklength = this.func_174813_aQ().func_72320_b() * 3.0;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, checklength);
        if (this.isSleeping() && player != null && !this.func_152114_e((EntityLivingBase)player) && !player.func_184812_l_()) {
            this.setSleeping(false);
            this.func_70904_g(false);
            this.func_70624_b((EntityLivingBase)player);
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.dragonInv != null && !this.field_70170_p.field_72995_K) {
            IEntityEffectCapability cap = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
            if (cap != null && cap.isStoned()) {
                return;
            }
            for (int i = 0; i < this.dragonInv.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInv.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    @Override
    public void onHearFlute(EntityPlayer player) {
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    public abstract SoundEvent getRoarSound();

    public void roar() {
        if (EntityGorgon.isStoneMob((EntityLivingBase)this)) {
            return;
        }
        if (this.getAnimation() != ANIMATION_ROAR) {
            this.setAnimation(ANIMATION_ROAR);
            this.func_184185_a(this.getRoarSound(), this.func_70599_aP() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.func_70647_i());
        }
        if (this.getDragonStage() > 3) {
            int size = (this.getDragonStage() - 3) * 30;
            List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)size, (double)size, (double)size));
            for (Entity entity : entities) {
                boolean isStrongerDragon;
                boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                if (!(entity instanceof EntityLivingBase) || isStrongerDragon) continue;
                EntityLivingBase living = (EntityLivingBase)entity;
                if (this.func_152114_e(living) || this.isOwnersPet(living)) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 30 * size));
                    continue;
                }
                if (living.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == IafItemRegistry.earplugs) continue;
                living.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 30 * size));
            }
        }
    }

    private boolean isOwnersPet(EntityLivingBase living) {
        return this.func_70909_n() && this.func_70902_q() != null && living instanceof EntityTameable && ((EntityTameable)living).func_70902_q() != null && this.func_70902_q().func_70028_i((Entity)((EntityTameable)living).func_70902_q());
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3d vec1, Vec3d vec2) {
        RayTraceResult movingobjectposition = entity.field_70170_p.func_147447_a(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)entity.field_70131_O * 0.5, vec2.field_72449_c), false, true, false);
        return movingobjectposition == null || movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK;
    }

    public boolean shouldRenderEyes() {
        return !this.isSleeping() && !this.isModelDead() && !this.isBlinking() && !EntityGorgon.isStoneMob((EntityLivingBase)this);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
        IEntityEffectCapability cap = InFCapabilities.getEntityEffectCapability((EntityLivingBase)this);
        if (cap != null && cap.isStoned()) {
            return;
        }
        if (this.dragonInv != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.dragonInv.func_70302_i_(); ++i) {
                ItemStack itemstack = this.dragonInv.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public Vec3d getHeadPosition() {
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        float sitProg = this.sitProgress * 0.015f;
        float sleepProg = this.sleepProgress * -0.025f;
        float flightXz = 1.0f + flyProg + hoverProg;
        float xzMod = 1.7f * this.getRenderSize() * 0.3f * flightXz + this.getRenderSize() * hoverProg * -0.45f;
        float headPosX = (float)(this.field_70165_t + (double)xzMod * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
        float headPosY = (float)(this.field_70163_u + (double)((0.7f + sitProg + hoverProg + deadProg + sleepProg + flyProg) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.field_70161_v + (double)xzMod * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
        return new Vec3d((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        this.func_189511_e(compound);
        return true;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.field_187537_bA || soundIn == this.func_184639_G() || soundIn == this.func_184601_bQ(null) || soundIn == this.func_184615_bR() || soundIn == this.getRoarSound()) {
            if (!this.func_174814_R()) {
                Vec3d headPos = this.getHeadPosition();
                this.field_70170_p.func_184148_a(null, headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, soundIn, this.func_184176_by(), volume, pitch);
            }
        } else {
            super.func_184185_a(soundIn, volume, pitch);
        }
    }

    public void onRemovedFromWorld() {
        if (this.isBoundToCrystal() && !this.field_70128_L) {
            DragonPosWorldData.get(this.field_70170_p).addDragon(this.func_110124_au(), this.func_180425_c());
        }
        super.onRemovedFromWorld();
    }

    public boolean canDismount() {
        return this.currentAnimation != ANIMATION_SHAKEPREY || this.animationTick > 60;
    }

    public boolean func_70028_i(Entity entityIn) {
        if (entityIn instanceof EntityMultipartPart) {
            EntityLivingBase parent = ((EntityMultipartPart)entityIn).getParent();
            return super.func_70028_i((Entity)parent);
        }
        return super.func_70028_i(entityIn);
    }
}

