/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIFleePlayer;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.AmphithereAIHurtByTarget;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIWatchClosestIgnoreRider;
import com.github.alexthe666.iceandfire.entity.ai.PathNavigateFlyingCreature;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IFlapable;
import com.github.alexthe666.iceandfire.entity.util.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageUpdateRidingState;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.util.ParticleHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAmphithere
extends EntityTameable
implements IAnimatedEntity,
IPhasesThroughBlock,
IFlapable,
IDragonFlute,
ISyncMount {
    private int animationTick;
    private Animation currentAnimation;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityAmphithere.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityAmphithere.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FLAP_TICKS = EntityDataManager.func_187226_a(EntityAmphithere.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityAmphithere.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityAmphithere.class, (DataSerializer)DataSerializers.field_187192_b);
    public float flapProgress;
    private int flapTicks = 0;
    public float groundProgress = 0.0f;
    public float sitProgress = 0.0f;
    public float diveProgress = 0.0f;
    private int flightCooldown = 0;
    private int ticksInAir = 0;
    private boolean isFlying;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer roll_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer tail_buffer;
    @SideOnly(value=Side.CLIENT)
    public IFChainBuffer pitch_buffer;
    protected FlightBehavior flightBehavior = FlightBehavior.WANDER;
    private boolean changedFlightBehavior = false;
    @Nullable
    public BlockPos orbitPos = null;
    public float orbitRadius = 0.0f;
    private int ticksStill = 0;
    private int ridingTime = 0;
    private boolean hasInitiatedFlight = false;
    public boolean isFallen;
    public static Animation ANIMATION_BITE = Animation.create((int)15);
    public static Animation ANIMATION_BITE_RIDER = Animation.create((int)15);
    public static Animation ANIMATION_WING_BLAST = Animation.create((int)30);
    public static Animation ANIMATION_TAIL_WHIP = Animation.create((int)30);
    public static Animation ANIMATION_SPEAK = Animation.create((int)10);
    private boolean isSitting;
    public BlockPos homePos;
    public boolean hasHomePosition = false;
    protected int ticksCircling = 0;
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "amphithere"));

    public EntityAmphithere(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.5f, 1.25f);
        this.field_70138_W = 1.0f;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.tail_buffer = new IFChainBuffer();
        }
        this.updateNavigator(true);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public float func_180484_a(BlockPos pos) {
        if (this.isFlying()) {
            if (this.field_70170_p.func_175623_d(pos)) {
                return 10.0f;
            }
            return 0.0f;
        }
        return super.func_180484_a(pos);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb || itemstack.func_77973_b() == Items.field_151058_ca;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151106_aX) {
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70911_d.func_75270_a(false);
                }
                this.func_146082_f(player);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77952_i() == EnumDyeColor.BROWN.func_176767_b()) {
            this.func_70691_i(5.0f);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (!super.func_184645_a(player, hand)) {
            if (itemstack.func_77973_b() == IafItemRegistry.dragon_stick && this.func_152114_e((EntityLivingBase)player)) {
                if (player.func_70093_af()) {
                    this.homePos = new BlockPos((Entity)this);
                    this.hasHomePosition = true;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("amphithere.command.new_home", new Object[]{this.homePos.func_177958_n(), this.homePos.func_177956_o(), this.homePos.func_177952_p()}), true);
                    return true;
                }
                return true;
            }
            if (player.func_70093_af() && this.func_152114_e((EntityLivingBase)player)) {
                if (player.func_184586_b(hand).func_190926_b()) {
                    int command = this.getCommand();
                    if (command < 2) {
                        this.setCommand(command + 1);
                    } else {
                        this.setCommand(0);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("amphithere.command." + this.getCommand(), new Object[0]), true);
                    this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                    return true;
                }
                return true;
            }
            if (!(this.func_70909_n() && !this.func_152114_e((EntityLivingBase)player) || this.func_70631_g_())) {
                player.func_184205_a((Entity)this, true);
                if (this.field_70170_p.field_72995_K) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageUpdateRidingState(this.func_145782_y(), true));
                }
                return true;
            }
        }
        return true;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AmphithereAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AmphithereAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AmphithereAIFleePlayer(this, 32.0f, 0.8, 1.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFlyWander());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFlyCircle());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILandWander(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosestIgnoreRider((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AmphithereAIHurtByTarget(this, false, new Class[0]));
    }

    public boolean isStill() {
        return Math.abs(this.field_70159_w) < 0.05 && Math.abs(this.field_70179_y) < 0.05;
    }

    private void updateNavigator(boolean isOnGround) {
        if (isOnGround) {
            if (this.field_70765_h instanceof GroundMoveHelper) {
                return;
            }
            this.field_70765_h = new GroundMoveHelper(this);
            this.field_70699_by = new PathNavigateClimber((EntityLiving)this, this.field_70170_p);
            return;
        }
        if (this.field_70765_h instanceof FlyMoveHelper) {
            return;
        }
        this.field_70765_h = new FlyMoveHelper(this);
        this.field_70699_by = new PathNavigateFlyingCreature(this, this.field_70170_p);
    }

    public boolean onLeaves() {
        IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
        return state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, this.func_180425_c().func_177977_b());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            if (!this.func_70909_n() && this.isFlying() && !this.isOnGround() && source.func_76352_a() && !this.field_70170_p.field_72995_K) {
                this.isFallen = true;
            }
            if (this.func_70909_n() && this.isRidingPlayer((EntityPlayer)source.func_76346_g())) {
                return false;
            }
        } else if (source.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger) && this.func_70909_n()) {
            this.field_70177_z = passenger.field_70177_z;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n() && passenger instanceof EntityPlayer && this.getAnimation() == NO_ANIMATION && this.field_70146_Z.nextInt(15) == 0) {
            this.setAnimation(ANIMATION_BITE_RIDER);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == ANIMATION_BITE_RIDER && this.getAnimationTick() == 6 && !this.func_70909_n()) {
            passenger.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)IceAndFireConfig.ENTITY_SETTINGS.amphithereTameDamage);
        }
        float pitch_forward = 0.0f;
        if (this.field_70125_A > 0.0f && this.isFlying()) {
            pitch_forward = this.field_70125_A / 45.0f * 0.45f;
        }
        float scaled_ground = this.groundProgress * 0.1f;
        float radius = (this.func_70909_n() ? 0.5f : 0.3f) - scaled_ground * 0.5f + pitch_forward;
        float angle = (float)Math.PI / 180 * this.field_70761_aq;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + (double)0.7f - (double)(scaled_ground * 0.14f) + (double)pitch_forward, this.field_70161_v + extraZ);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151106_aX;
    }

    public void func_70636_d() {
        boolean notGrounded;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (this.func_70090_H() && this.field_70703_bu) {
            this.field_70181_x += 0.1;
        }
        if (this.func_70631_g_() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (this.func_70880_s()) {
            this.setFlying(false);
        }
        if (this.func_70906_o() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        boolean flapping = this.isFlapping();
        boolean flying = !this.func_184218_aH() && (this.isFlying() && !this.isOnGround() || !this.isOnGround() && !this.onLeaves());
        boolean diving = flying && this.field_70181_x <= (double)-0.1f || this.isFallen;
        boolean sitting = this.func_70906_o() && !this.isFlying();
        boolean bl = notGrounded = this.isFlying() || this.getAnimation() == ANIMATION_WING_BLAST;
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70906_o() && (this.getCommand() != 1 || this.func_184179_bs() != null)) {
                this.field_70911_d.func_75270_a(false);
            }
            if (!this.func_70906_o() && this.getCommand() == 1 && this.func_184179_bs() == null) {
                this.field_70911_d.func_75270_a(true);
            }
            if (this.func_70906_o()) {
                this.func_70661_as().func_75499_g();
                this.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
            }
            this.ticksCircling = this.flightBehavior == FlightBehavior.CIRCLE ? ++this.ticksCircling : 0;
        }
        this.ticksInAir = flying ? ++this.ticksInAir : 0;
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
        }
        if (this.getRider() != null && !this.func_70909_n()) {
            ++this.ridingTime;
        }
        if (this.getRider() == null) {
            this.ridingTime = 0;
        }
        if (!this.func_70909_n() && this.ridingTime > IceAndFireConfig.ENTITY_SETTINGS.amphithereTameTime && this.getRider() != null && this.getRider() instanceof EntityPlayer) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            this.func_193101_c((EntityPlayer)this.getRider());
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        this.ticksStill = this.isStill() ? ++this.ticksStill : 0;
        if (this.isFlying && this.field_70122_E) {
            this.setFlying(false);
        }
        if (!this.isFlying() && !this.func_70631_g_() && !this.func_70909_n() && (this.isOnGround() && this.field_70146_Z.nextInt(200) == 0 && this.flightCooldown == 0 && this.getRider() == null && !this.func_175446_cd() && this.canMove() || this.field_70163_u < -1.0)) {
            this.field_70181_x += 0.5;
            this.hasInitiatedFlight = true;
        }
        if (notGrounded && this.groundProgress > 0.0f) {
            this.groundProgress -= 2.0f;
        } else if (!notGrounded && this.groundProgress < 20.0f) {
            this.groundProgress += 2.0f;
        }
        if (diving && this.diveProgress < 20.0f) {
            this.diveProgress += 1.0f;
        } else if (!diving && this.diveProgress > 0.0f) {
            this.diveProgress -= 1.0f;
        }
        if (this.isFallen && this.flightBehavior != FlightBehavior.NONE) {
            this.flightBehavior = FlightBehavior.NONE;
        }
        if (flying) {
            Entity controllingPassenger = this.func_184179_bs();
            if (controllingPassenger instanceof EntityPlayer) {
                if (this.isFlying()) {
                    float pitch = this.func_184179_bs().field_70125_A;
                    this.field_70125_A = pitch / 2.0f;
                    if (pitch > 25.0f && this.field_70181_x > -1.0) {
                        if (this.field_70181_x > 0.0) {
                            this.field_70181_x = 0.0;
                        }
                        this.field_70181_x -= 0.1;
                    }
                    if (pitch < -25.0f && this.field_70181_x < 1.0) {
                        if (this.field_70181_x < 0.0) {
                            this.field_70181_x = 0.0;
                        }
                        this.field_70181_x += 0.1;
                    }
                }
            } else if (this.isFallen) {
                this.field_70181_x -= (double)0.2f;
                this.field_70125_A = Math.max(this.field_70125_A + 5.0f, 75.0f);
            } else if (this.flightBehavior == FlightBehavior.NONE) {
                this.field_70181_x -= (double)0.3f;
            }
            if (!this.isFlying() && (this.hasInitiatedFlight || this.ticksInAir > 25)) {
                this.setFlying(true);
            }
            this.updateNavigator(false);
        } else {
            if (this.isFallen) {
                this.setFlying(false);
                if (!this.func_70909_n()) {
                    this.flightCooldown = 12000;
                }
                this.isFallen = false;
            }
            this.updateNavigator(true);
        }
        if ((this.hasHomePosition || this.getCommand() == 2) && this.flightBehavior == FlightBehavior.WANDER) {
            this.flightBehavior = FlightBehavior.CIRCLE;
        }
        if (flapping && this.flapProgress < 10.0f) {
            this.flapProgress += 1.0f;
        } else if (!flapping && this.flapProgress > 0.0f) {
            this.flapProgress -= 1.0f;
        }
        if (this.flapTicks > 0) {
            --this.flapTicks;
        }
        this.field_70761_aq = this.field_70177_z;
        if (this.field_70170_p.field_72995_K) {
            if (!this.isOnGround()) {
                this.roll_buffer.calculateChainFlapBuffer(this.func_184207_aI() ? 55.0f : 90.0f, 3, 10.0f, 0.5f, (EntityLivingBase)this);
                this.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 10.0f, 0.5f, (EntityLivingBase)this);
            }
            this.tail_buffer.calculateChainSwingBuffer(70.0f, 20, 5.0f, (EntityLivingBase)this);
        }
        if (this.changedFlightBehavior) {
            this.changedFlightBehavior = false;
        }
        if (!flapping && flying && (this.field_70181_x > (double)0.15f || this.field_70181_x > 0.0 && this.field_70173_aa % 200 == 0)) {
            this.flapWings();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_189652_ae() {
        return this.isFlying();
    }

    @Override
    public boolean isFlapping() {
        return this.flapTicks > 0;
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70911_d.func_75270_a(command == 1);
        }
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    @Override
    public void flapWings() {
        this.flapTicks = 20;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            this.isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return this.isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (passenger instanceof EntityPlayer) {
                if (this.func_70638_az() == passenger) continue;
                EntityPlayer player = (EntityPlayer)passenger;
                if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
                return player;
            }
            return passenger;
        }
        return null;
    }

    public boolean isPlayerControlled() {
        return this.func_184179_bs() instanceof EntityPlayer;
    }

    @Nullable
    public Entity getRider() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer)) continue;
            return passenger;
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(IceAndFireConfig.ENTITY_SETTINGS.amphithereMaxHealth);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(IceAndFireConfig.ENTITY_SETTINGS.amphithereAttackStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(FLAP_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("FlightCooldown", this.flightCooldown);
        compound.func_74768_a("RidingTime", this.ridingTime);
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.func_74768_a("HomeAreaX", this.homePos.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homePos.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homePos.func_177952_p());
        }
        compound.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.flightCooldown = compound.func_74762_e("FlightCooldown");
        this.ridingTime = compound.func_74762_e("RidingTime");
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
        this.setCommand(compound.func_74762_e("Command"));
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.func_184179_bs() instanceof EntityPlayer && this.func_184179_bs().func_110124_au().equals(player.func_110124_au()) && this.func_70909_n();
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        return this.field_70170_p.func_175710_j(blockpos.func_177984_a());
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_70071_h_() {
        float f;
        double dist;
        super.func_70071_h_();
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 7 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 10.0) {
            this.func_70638_az().func_70653_a((Entity)this, 0.6f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        }
        if (this.getAnimation() == ANIMATION_WING_BLAST && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.AMPHITHERE_GUST, 1.0f, 1.0f);
        }
        if ((this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_BITE_RIDER) && this.getAnimationTick() == 1) {
            this.func_184185_a(IafSoundRegistry.AMPHITHERE_BITE, 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_WING_BLAST && this.func_70638_az() != null && this.getAnimationTick() > 5 && this.getAnimationTick() < 22 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 25.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() / 2.0f);
            this.func_70638_az().field_70160_al = true;
            f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * (double)0.2f + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * (double)0.2f));
            this.func_70638_az().field_70159_w /= 2.0;
            this.func_70638_az().field_70179_y /= 2.0;
            this.func_70638_az().field_70159_w -= 0.5 / (double)f;
            this.func_70638_az().field_70179_y -= 0.5 / (double)f;
            if (this.func_70638_az().field_70122_E) {
                this.func_70638_az().field_70181_x /= 2.0;
                this.func_70638_az().field_70181_x += 4.0;
                if (this.func_70638_az().field_70181_x > (double)0.4f) {
                    this.func_70638_az().field_70181_x = 0.4f;
                }
            }
        }
        if (this.getAnimation() == ANIMATION_TAIL_WHIP && this.func_70638_az() != null && this.getAnimationTick() == 7 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 10.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            this.func_70638_az().field_70160_al = true;
            f = MathHelper.func_76133_a((double)0.5);
            this.func_70638_az().field_70159_w /= 2.0;
            this.func_70638_az().field_70179_y /= 2.0;
            this.func_70638_az().field_70159_w -= 0.5 / (double)f * 4.0;
            this.func_70638_az().field_70179_y -= 0.5 / (double)f * 4.0;
            if (this.func_70638_az().field_70122_E) {
                this.func_70638_az().field_70181_x /= 2.0;
                this.func_70638_az().field_70181_x += 4.0;
                if (this.func_70638_az().field_70181_x > (double)0.4f) {
                    this.func_70638_az().field_70181_x = 0.4f;
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.up() && !this.isFlying()) {
            this.field_70181_x += 1.0;
            this.hasInitiatedFlight = true;
        }
        if (this.dismount() && this.isFlying()) {
            if (this.isOnGround()) {
                this.setFlying(false);
            } else {
                this.setCommand(2);
            }
        }
        if (this.getRider() != null && this.getRider().func_70093_af()) {
            this.getRider().func_70095_a(false);
            this.getRider().func_184210_p();
            if (this.field_70170_p.field_72995_K) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageUpdateRidingState(this.func_145782_y(), false));
            }
        }
        if (this.attack() && this.func_184179_bs() instanceof EntityPlayer) {
            EntityLivingBase target = DragonUtils.riderLookingAtEntity((EntityLivingBase)this, (EntityLivingBase)((EntityPlayer)this.func_184179_bs()), 2.5);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
            }
            if (target != null) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.func_70638_az() != null && (this.func_152114_e(this.func_70638_az()) || DragonUtils.isControllingPassenger((Entity)this, (Entity)this.func_70638_az()))) {
            this.func_70624_b(null);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_TAIL_WHIP && this.getAnimation() != ANIMATION_WING_BLAST && !this.isPlayerControlled()) {
            if (this.field_70146_Z.nextBoolean()) {
                this.setAnimation(ANIMATION_BITE);
            } else {
                this.setAnimation(this.func_70681_au().nextBoolean() || this.isFlying() ? ANIMATION_WING_BLAST : ANIMATION_TAIL_WHIP);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(ModKeys.dragon_down.func_151470_d());
            this.attack(ModKeys.dragon_strike.func_151470_d());
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
        this.hasInitiatedFlight = false;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void dismount(boolean dismount) {
        this.setStateField(3, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    private byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.AMPHITHERE_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.AMPHITHERE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.AMPHITHERE_DIE;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_BITE_RIDER, ANIMATION_WING_BLAST, ANIMATION_TAIL_WHIP, ANIMATION_SPEAK};
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 40;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityAmphithere amphithere = new EntityAmphithere(this.field_70170_p);
        amphithere.setVariant(this.func_70681_au().nextInt(5));
        return amphithere;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 10;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(this.func_70681_au().nextInt(5));
        return livingdata;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public static BlockPos getPositionRelativeToGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.field_70163_u, z);
        for (int yDown = 0; yDown < 6 + rand.nextInt(6); ++yDown) {
            if (world.func_175623_d(pos.func_177979_c(yDown))) continue;
            return pos.func_177981_b(yDown);
        }
        return pos;
    }

    public static BlockPos getPositionInOrbit(EntityAmphithere entity, BlockPos orbit) {
        float possibleOrbitRadius = entity.orbitRadius + 10.0f;
        float radius = 10.0f;
        if (entity.getCommand() == 2) {
            if (entity.func_70902_q() != null) {
                orbit = entity.func_70902_q().func_180425_c().func_177981_b(7);
                radius = 5.0f;
            }
        } else if (entity.hasHomePosition) {
            orbit = entity.homePos.func_177981_b(30);
            radius = 30.0f;
        }
        float angle = (float)Math.PI / 180 * possibleOrbitRadius;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos((double)orbit.func_177958_n() + extraX, (double)orbit.func_177956_o(), (double)orbit.func_177952_p() + extraZ);
        entity.orbitRadius = possibleOrbitRadius;
        return radialPos;
    }

    @Override
    public boolean canPhaseThroughBlock(IBlockState state, World world, BlockPos pos) {
        return state.func_185904_a() == Material.field_151584_j;
    }

    public void func_191986_a(float strafe, float forward, float vertical) {
        EntityLivingBase controller;
        if (!this.canMove() && !this.func_184207_aI()) {
            strafe = 0.0f;
            forward = 0.0f;
            vertical = 0.0f;
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        if (this.isPlayerControlled() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (!this.isOnGround()) {
                strafe = 0.0f;
                forward = 1.5f;
            }
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.isFlying()) {
                this.field_70159_w *= 1.06;
                this.field_70179_y *= 1.06;
            }
            this.field_70747_aH = 0.05f;
            this.func_70659_e(this.isOnGround() ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : 2.0f);
            super.func_191986_a(strafe, 0.0f, forward);
            return;
        }
        super.func_191986_a(strafe, forward, vertical);
    }

    public boolean canMove() {
        return !this.isPlayerControlled() && this.sitProgress == 0.0f && !this.func_70906_o();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            this.playEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    private void playEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            ParticleHelper.spawnParticle(this.field_70170_p, enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Override
    public void onHearFlute(EntityPlayer player) {
        if (!this.isOnGround() && this.func_70909_n()) {
            this.isFallen = true;
        }
    }

    public boolean isOnGround() {
        return this.field_70122_E || !this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b());
    }

    class FlyMoveHelper
    extends EntityMoveHelper {
        public FlyMoveHelper(EntityAmphithere entity) {
            super((EntityLiving)entity);
            this.field_75645_e = IceAndFireConfig.ENTITY_SETTINGS.amphithereFlightSpeed;
        }

        public void func_75641_c() {
            if (!EntityAmphithere.this.canMove()) {
                return;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityAmphithere.this.field_70165_t;
                double d1 = this.field_75647_c - EntityAmphithere.this.field_70163_u;
                double d2 = this.field_75644_d - EntityAmphithere.this.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                if (d3 < 6.0 && EntityAmphithere.this.func_70638_az() == null) {
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.WANDER && EntityAmphithere.this.field_70146_Z.nextInt(30) == 0) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (!EntityAmphithere.this.changedFlightBehavior && EntityAmphithere.this.flightBehavior == FlightBehavior.CIRCLE && EntityAmphithere.this.field_70146_Z.nextInt(5) == 0 && EntityAmphithere.this.ticksCircling > 150) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.WANDER;
                        EntityAmphithere.this.changedFlightBehavior = true;
                    }
                    if (EntityAmphithere.this.hasHomePosition && EntityAmphithere.this.flightBehavior != FlightBehavior.NONE || EntityAmphithere.this.getCommand() == 2) {
                        EntityAmphithere.this.flightBehavior = FlightBehavior.CIRCLE;
                    }
                }
                if (d3 < 1.0 && EntityAmphithere.this.func_70638_az() == null) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityAmphithere.this.field_70159_w *= 0.5;
                    EntityAmphithere.this.field_70181_x *= 0.5;
                    EntityAmphithere.this.field_70179_y *= 0.5;
                } else {
                    EntityAmphithere.this.field_70159_w += d0 / d3 * 0.5 * this.field_75645_e;
                    EntityAmphithere.this.field_70181_x += d1 / d3 * 0.5 * this.field_75645_e;
                    EntityAmphithere.this.field_70179_y += d2 / d3 * 0.5 * this.field_75645_e;
                    EntityAmphithere.this.field_70125_A = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    if (EntityAmphithere.this.func_70638_az() == null) {
                        EntityAmphithere.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityAmphithere.this.field_70159_w, (double)EntityAmphithere.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityAmphithere.this.func_70638_az().field_70165_t - EntityAmphithere.this.field_70165_t;
                        double d5 = EntityAmphithere.this.func_70638_az().field_70161_v - EntityAmphithere.this.field_70161_v;
                        EntityAmphithere.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                    EntityAmphithere.this.field_70761_aq = EntityAmphithere.this.field_70177_z;
                }
            }
        }
    }

    class GroundMoveHelper
    extends EntityMoveHelper {
        public GroundMoveHelper(EntityAmphithere entity) {
            super((EntityLiving)entity);
        }

        public void func_75641_c() {
            if (!EntityAmphithere.this.canMove()) {
                return;
            }
            super.func_75641_c();
        }
    }

    class AIFlyCircle
    extends EntityAIBase {
        BlockPos target;

        public AIFlyCircle() {
            this.func_75248_a(0);
        }

        public boolean func_75250_a() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.CIRCLE || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                EntityAmphithere.this.orbitPos = EntityAmphithere.getPositionRelativeToGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.field_70165_t + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70161_v + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70146_Z);
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.orbitPos);
                return true;
            }
            return false;
        }

        private boolean isDirectPathBetweenPoints() {
            RayTraceResult rayTrace = EntityAmphithere.this.field_70170_p.func_72901_a(EntityAmphithere.this.func_174791_d(), new Vec3d((Vec3i)this.target).func_72441_c(0.5, 0.5, 0.5), false);
            if (rayTrace != null && rayTrace.field_72307_f != null) {
                BlockPos sidePos = rayTrace.func_178782_a();
                BlockPos pos = new BlockPos(rayTrace.field_72307_f);
                if (EntityAmphithere.this.field_70170_p.func_175623_d(pos) || EntityAmphithere.this.field_70170_p.func_175623_d(sidePos) || EntityAmphithere.this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151584_j || EntityAmphithere.this.field_70170_p.func_180495_p(sidePos).func_185904_a() == Material.field_151584_j) {
                    return true;
                }
                return rayTrace.field_72313_a != RayTraceResult.Type.MISS;
            }
            return true;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints()) {
                this.target = EntityAmphithere.getPositionInOrbit(EntityAmphithere.this, EntityAmphithere.this.orbitPos);
            }
            if (EntityAmphithere.this.field_70170_p.func_175623_d(this.target)) {
                EntityAmphithere.this.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityAmphithere.this.func_70638_az() == null) {
                    EntityAmphithere.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AIFlyWander
    extends EntityAIBase {
        BlockPos target;

        public AIFlyWander() {
            this.func_75248_a(0);
        }

        public boolean func_75250_a() {
            if (EntityAmphithere.this.flightBehavior != FlightBehavior.WANDER || !EntityAmphithere.this.canMove()) {
                return false;
            }
            if (EntityAmphithere.this.isFlying()) {
                this.target = EntityAmphithere.getPositionRelativeToGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.field_70165_t + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70161_v + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70146_Z);
                EntityAmphithere.this.orbitPos = null;
                return !EntityAmphithere.this.func_70605_aq().func_75640_a() || EntityAmphithere.this.ticksStill >= 50;
            }
            return false;
        }

        protected boolean isDirectPathBetweenPoints(Entity e) {
            RayTraceResult rayTrace = EntityAmphithere.this.field_70170_p.func_72901_a(e.func_174791_d(), new Vec3d((Vec3i)this.target).func_72441_c(0.5, 0.5, 0.5), false);
            if (rayTrace != null && rayTrace.field_72307_f != null) {
                BlockPos sidePos = rayTrace.func_178782_a();
                BlockPos pos = new BlockPos(rayTrace.field_72307_f);
                if (EntityAmphithere.this.field_70170_p.func_175623_d(pos) || EntityAmphithere.this.field_70170_p.func_175623_d(sidePos) || EntityAmphithere.this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151584_j || EntityAmphithere.this.field_70170_p.func_180495_p(sidePos).func_185904_a() == Material.field_151584_j) {
                    return true;
                }
                return rayTrace.field_72313_a != RayTraceResult.Type.MISS;
            }
            return true;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints((Entity)EntityAmphithere.this)) {
                this.target = EntityAmphithere.getPositionRelativeToGround((Entity)EntityAmphithere.this, EntityAmphithere.this.field_70170_p, EntityAmphithere.this.field_70165_t + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70161_v + (double)EntityAmphithere.this.field_70146_Z.nextInt(30) - 15.0, EntityAmphithere.this.field_70146_Z);
            }
            if (EntityAmphithere.this.field_70170_p.func_175623_d(this.target)) {
                EntityAmphithere.this.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityAmphithere.this.func_70638_az() == null) {
                    EntityAmphithere.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AILandWander
    extends EntityAIWander {
        public AILandWander(EntityAmphithere amphithere, double speed) {
            super((EntityCreature)amphithere, speed, 10);
        }

        public boolean func_75250_a() {
            return EntityAmphithere.this.isOnGround() && EntityAmphithere.this.canMove() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return EntityAmphithere.this.isOnGround() && EntityAmphithere.this.canMove() && super.func_75253_b();
        }
    }

    public static enum FlightBehavior {
        CIRCLE,
        WANDER,
        NONE;

    }
}

