/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.api.IEntityEffectCapability;
import com.github.alexthe666.iceandfire.api.InFCapabilities;
import com.github.alexthe666.iceandfire.client.model.ICustomStatueModel;
import com.github.alexthe666.iceandfire.client.model.ModelGuardianStatue;
import com.github.alexthe666.iceandfire.client.model.ModelHorseStatue;
import com.github.alexthe666.iceandfire.client.texture.DesaturatedStonedTexture;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LayerStoneEntity
implements LayerRenderer<EntityLivingBase> {
    private static final ModelHorseStatue HORSE_MODEL = new ModelHorseStatue();
    private static final ModelGuardianStatue GUARDIAN_MODEL = new ModelGuardianStatue();
    private final RenderLivingBase<? extends EntityLivingBase> renderer;
    private static Method getEntityTexture;
    private static boolean reflected;
    private final Map<String, ResourceLocation> STONED_TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private ResourceLocation stoneTexture;

    public LayerStoneEntity(RenderLivingBase<? extends EntityLivingBase> renderer) {
        this.renderer = renderer;
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float f, float f1, float i, float f2, float f3, float f4, float f5) {
        IEntityEffectCapability capability;
        if (entitylivingbaseIn instanceof EntityLiving && (capability = InFCapabilities.getEntityEffectCapability(entitylivingbaseIn)) != null && capability.isStoned()) {
            ResourceLocation entityTexture = null;
            if (this.stoneTexture == null) {
                this.stoneTexture = new ResourceLocation(this.getStoneType(this.renderer.func_177087_b()));
            }
            if (IceAndFireConfig.CLIENT_SETTINGS.customStoneTexture) {
                try {
                    if (getEntityTexture == null && !reflected) {
                        reflected = true;
                        try {
                            getEntityTexture = ObfuscationReflectionHelper.findMethod(Render.class, (String)"func_110775_a", ResourceLocation.class, (Class[])new Class[]{Entity.class});
                            getEntityTexture.setAccessible(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (getEntityTexture != null) {
                        entityTexture = (ResourceLocation)getEntityTexture.invoke(this.renderer, entitylivingbaseIn);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GL11.glEnable((int)2884);
            if (entityTexture != null) {
                ResourceLocation cacheName = new ResourceLocation("iceandfire:stonecache/" + entityTexture.func_110624_b() + "/" + entityTexture.func_110623_a());
                ResourceLocation resolvedTexture = this.STONED_TEXTURE_CACHE.get(cacheName.toString());
                if (resolvedTexture == null) {
                    DesaturatedStonedTexture desat = new DesaturatedStonedTexture(entityTexture, this.stoneTexture);
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(cacheName, (ITextureObject)desat);
                    this.STONED_TEXTURE_CACHE.put(cacheName.toString(), cacheName);
                    resolvedTexture = cacheName;
                }
                entityTexture = resolvedTexture;
            }
            this.renderer.func_110776_a(entityTexture == null ? this.stoneTexture : entityTexture);
            if (this.renderer.func_177087_b() instanceof ICustomStatueModel) {
                ((ICustomStatueModel)this.renderer.func_177087_b()).renderStatue();
            } else if (entitylivingbaseIn instanceof AbstractHorse && !(entitylivingbaseIn instanceof EntityLlama)) {
                HORSE_MODEL.func_78088_a((Entity)entitylivingbaseIn, f, 0.0f, 0.0f, f3, f4, f5);
            } else if (entitylivingbaseIn instanceof EntityGuardian) {
                GUARDIAN_MODEL.func_78088_a((Entity)entitylivingbaseIn, f, 0.0f, 0.0f, f3, f4, f5);
            } else {
                this.renderer.func_177087_b().func_78088_a((Entity)entitylivingbaseIn, f, 0.0f, 0.0f, f3, f4, f5);
            }
            GL11.glDisable((int)2884);
        }
    }

    private String getStoneType(ModelBase model) {
        int sizeY;
        int sizeX = this.clampTexture(model.field_78090_t);
        if (sizeX > (sizeY = this.clampTexture(model.field_78089_u)) && sizeX / 2 != sizeY) {
            sizeY = sizeX / 2;
        }
        if (sizeY > sizeX && sizeY / 2 != sizeX) {
            sizeX = sizeY / 2;
        }
        return sizeX <= 16 && sizeY <= 16 ? "textures/blocks/stone.png" : "iceandfire:textures/models/gorgon/stone" + sizeX + "x" + sizeY + ".png";
    }

    private int clampTexture(int i) {
        if (i >= 128) {
            return 128;
        }
        if (i >= 64) {
            return 64;
        }
        if (i >= 32) {
            return 32;
        }
        return 16;
    }

    public boolean func_177142_b() {
        return true;
    }
}

