/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelStonePlayer;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderStoneStatue
extends RenderLiving<EntityStoneStatue> {
    private static final ModelStonePlayer MODEL = new ModelStonePlayer(0.0f, false);
    private static final ModelStonePlayer MODEL_SLIM = new ModelStonePlayer(0.0f, true);

    public RenderStoneStatue(RenderManager renderManager) {
        super(renderManager, (ModelBase)MODEL, 0.5f);
        this.field_177097_h.add(new LayerStonePlayerEntityCrack((RenderLivingBase<EntityStoneStatue>)this));
        LayerBipedArmor layerbipedarmor = new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelStonePlayer(0.5f, true);
                this.field_177186_d = new ModelStonePlayer(1.0f, true);
            }
        };
        this.func_177094_a((LayerRenderer)layerbipedarmor);
    }

    public ModelBase func_177087_b() {
        return MODEL;
    }

    protected void renderModel(EntityStoneStatue entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = !entity.func_82150_aj() || this.field_188301_f;
        boolean bl = flag1 = !flag && !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)entity)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            if (entity.smallArms) {
                MODEL_SLIM.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            } else {
                MODEL.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            }
            if (flag1) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    private String getStoneType(ModelBase model) {
        int sizeY;
        int sizeX = this.clampTexture(model.field_78090_t);
        if (sizeX > (sizeY = this.clampTexture(model.field_78089_u)) && sizeX / 2 != sizeY) {
            sizeY = sizeX / 2;
        }
        if (sizeY > sizeX && sizeY / 2 != sizeX) {
            sizeX = sizeY / 2;
        }
        return sizeX <= 16 && sizeY <= 16 ? "textures/blocks/stone.png" : "iceandfire:textures/models/gorgon/stone" + sizeX + "x" + sizeY + ".png";
    }

    private int clampTexture(int i) {
        if (i >= 128) {
            return 128;
        }
        if (i >= 64) {
            return 64;
        }
        if (i >= 32) {
            return 32;
        }
        return 16;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityStoneStatue entity) {
        return new ResourceLocation(this.getStoneType((ModelBase)(entity.smallArms ? MODEL : MODEL_SLIM)));
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerStonePlayerEntityCrack
    implements LayerRenderer<EntityStoneStatue> {
        private static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};
        private final RenderLivingBase<EntityStoneStatue> renderer;

        public LayerStonePlayerEntityCrack(RenderLivingBase<EntityStoneStatue> renderer) {
            this.renderer = renderer;
        }

        public void doRenderLayer(EntityStoneStatue stoneStatue, float f, float f1, float i, float f2, float f3, float f4, float f5) {
            int breakCount = stoneStatue.getCrackAmount();
            if (breakCount > 0) {
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
                GlStateManager.func_179088_q();
                GlStateManager.func_179147_l();
                GlStateManager.func_179132_a((boolean)true);
                this.renderer.func_110776_a(DESTROY_STAGES[breakCount - 1]);
                this.renderer.func_177087_b().func_78088_a((Entity)stoneStatue, f, f1, f2, f3, f4, f5);
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
            }
        }

        public boolean func_177142_b() {
            return true;
        }
    }
}

