/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle.lightning;

import com.github.alexthe666.iceandfire.client.particle.lightning.ParticleLightningVector;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;

public final class ParticleLightningQuat {
    public final double x;
    public final double y;
    public final double z;
    public final double s;
    private final int hashCode;

    public ParticleLightningQuat(double d, double d1, double d2, double d3) {
        this.x = d1;
        this.y = d2;
        this.z = d3;
        this.s = d;
        this.hashCode = Arrays.hashCode(new double[]{d, d1, d2, d3});
    }

    public static ParticleLightningQuat aroundAxis(double ax, double ay, double az, double angle) {
        double d4 = Math.sin(angle *= 0.5);
        return new ParticleLightningQuat(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public ParticleLightningVector rotate(ParticleLightningVector vec) {
        double d = -this.x * vec.x - this.y * vec.y - this.z * vec.z;
        double d1 = this.s * vec.x + this.y * vec.z - this.z * vec.y;
        double d2 = this.s * vec.y - this.x * vec.z + this.z * vec.x;
        double d3 = this.s * vec.z + this.x * vec.y - this.y * vec.x;
        double vx = d1 * this.s - d * this.x - d2 * this.z + d3 * this.y;
        double vy = d2 * this.s - d * this.y + d1 * this.z - d3 * this.x;
        double vz = d3 * this.s - d * this.z - d1 * this.y + d2 * this.x;
        return new ParticleLightningVector(vx, vy, vz);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return o instanceof ParticleLightningQuat && ((ParticleLightningQuat)o).x == this.x && ((ParticleLightningQuat)o).y == this.y && ((ParticleLightningQuat)o).z == this.z && ((ParticleLightningQuat)o).s == this.s;
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringbuilder, Locale.US);
        formatter.format("Quaternion:%n", new Object[0]);
        formatter.format("  < %f %f %f %f >%n", this.s, this.x, this.y, this.z);
        formatter.close();
        return stringbuilder.toString();
    }

    public static ParticleLightningQuat aroundAxis(ParticleLightningVector axis, double angle) {
        return ParticleLightningQuat.aroundAxis(axis.x, axis.y, axis.z, angle);
    }
}

