/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.util.IafMathHelper;
import net.ilexiconn.llibrary.client.model.ModelAnimator;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class IceAndFireTabulaModelAnimator {
    protected IceAndFireTabulaModel baseModel;

    public IceAndFireTabulaModelAnimator(IceAndFireTabulaModel baseModel) {
        this.baseModel = baseModel;
    }

    public void setRotateAngle(AdvancedModelRenderer model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += limbSwingAmount * this.distance(model.field_78795_f, x);
        model.field_78796_g += limbSwingAmount * this.distance(model.field_78796_g, y);
        model.field_78808_h += limbSwingAmount * this.distance(model.field_78808_h, z);
    }

    public void addToRotateAngle(AdvancedModelRenderer model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationX, x);
        model.field_78796_g += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationY, y);
        model.field_78808_h += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationZ, z);
    }

    public boolean isPartEqual(AdvancedModelRenderer original, AdvancedModelRenderer pose) {
        return pose != null && pose.field_78795_f == original.defaultRotationX && pose.field_78796_g == original.defaultRotationY && pose.field_78808_h == original.defaultRotationZ;
    }

    public boolean isPositionEqual(AdvancedModelRenderer original, AdvancedModelRenderer pose) {
        return pose.field_78800_c == original.defaultPositionX && pose.field_78797_d == original.defaultPositionY && pose.field_78798_e == original.defaultPositionZ;
    }

    public void transitionTo(AdvancedModelRenderer from, AdvancedModelRenderer to, float timer, float maxTime, boolean oldFashioned) {
        if (oldFashioned) {
            from.field_78795_f += (to.field_78795_f - from.field_78795_f) / maxTime * timer;
            from.field_78796_g += (to.field_78796_g - from.field_78796_g) / maxTime * timer;
            from.field_78808_h += (to.field_78808_h - from.field_78808_h) / maxTime * timer;
        } else {
            this.transitionAngles(from, to, timer, maxTime);
        }
        from.field_78800_c += (to.field_78800_c - from.field_78800_c) / maxTime * timer;
        from.field_78797_d += (to.field_78797_d - from.field_78797_d) / maxTime * timer;
        from.field_78798_e += (to.field_78798_e - from.field_78798_e) / maxTime * timer;
    }

    public void transitionAngles(AdvancedModelRenderer from, AdvancedModelRenderer to, float timer, float maxTime) {
        from.field_78795_f += this.distance(from.field_78795_f, to.field_78795_f) / maxTime * timer;
        from.field_78796_g += this.distance(from.field_78796_g, to.field_78796_g) / maxTime * timer;
        from.field_78808_h += this.distance(from.field_78808_h, to.field_78808_h) / maxTime * timer;
    }

    public float distance(float rotateAngleFrom, float rotateAngleTo) {
        return (float)IafMathHelper.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
    }

    public void rotate(ModelAnimator animator, AdvancedModelRenderer model, float x, float y, float z) {
        animator.rotate((ModelRenderer)model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void moveToPose(IceAndFireTabulaModel model, IceAndFireTabulaModel modelTo) {
        for (AdvancedModelRenderer cube : model.getCubes().values()) {
            float toZ;
            float toY;
            float toX;
            AdvancedModelRenderer cubeTo;
            AdvancedModelRenderer cubeFrom = this.baseModel.getCube(cube.field_78802_n);
            if (!this.isPartEqual(cubeFrom, cubeTo = modelTo.getCube(cube.field_78802_n))) {
                toX = cubeTo.field_78795_f;
                toY = cubeTo.field_78796_g;
                toZ = cubeTo.field_78808_h;
                model.llibAnimator.rotate((ModelRenderer)cube, this.distance(cube.field_78795_f, toX), this.distance(cube.field_78796_g, toY), this.distance(cube.field_78808_h, toZ));
            }
            if (this.isPositionEqual(cubeFrom, cubeTo)) continue;
            toX = cubeTo.field_78800_c;
            toY = cubeTo.field_78797_d;
            toZ = cubeTo.field_78798_e;
            model.llibAnimator.move((ModelRenderer)cube, this.distance(cube.field_78800_c, toX), this.distance(cube.field_78797_d, toY), this.distance(cube.field_78798_e, toZ));
        }
    }

    protected boolean isComponentOf(IceAndFireTabulaModel model, String name, AdvancedModelRenderer modelRenderer) {
        AdvancedModelRenderer cube = model.getCube(name);
        return this.isComponentOf((ModelRenderer)cube, modelRenderer);
    }

    protected boolean isComponentOf(ModelRenderer cube, AdvancedModelRenderer modelRenderer) {
        if (cube == modelRenderer) {
            return true;
        }
        if (cube.field_78805_m != null) {
            for (ModelRenderer childModel : cube.field_78805_m) {
                if (!this.isComponentOf(childModel, modelRenderer)) continue;
                return true;
            }
        }
        return false;
    }
}

