/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model;

import com.github.alexthe666.iceandfire.entity.util.IFlapable;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IFChainBuffer {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    private boolean compareDouble(double a, double b) {
        double c = a - b;
        return Math.abs(c - 1.0) <= 0.01;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityLivingBase entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_70761_aq, entity.field_70760_ar) && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += MathHelper.func_76131_a((float)((entity.field_70760_ar - entity.field_70761_aq) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > 1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainPitchBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityLivingBase entity) {
        this.prevPitchVariation = entity.field_70127_C;
        this.pitchVariation = entity.field_70125_A;
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityLivingBase entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (Math.abs(entity.field_70125_A) > maxAngle) {
            return;
        }
        if (!this.compareDouble(entity.field_70125_A, entity.field_70127_C) && MathHelper.func_76135_e((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += MathHelper.func_76131_a((float)((entity.field_70127_C - entity.field_70125_A) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > 1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, EntityLivingBase entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.field_70761_aq, entity.field_70760_ar) && MathHelper.func_76135_e((float)this.yawVariation) < maxAngle) {
            this.yawVariation += MathHelper.func_76131_a((float)((entity.field_70760_ar - entity.field_70761_aq) / divisor), (float)(-maxAngle), (float)maxAngle);
            if (entity instanceof IFlapable && (double)Math.abs(entity.field_70760_ar - entity.field_70761_aq) > 15.0) {
                ((IFlapable)entity).flapWings();
            }
        }
        if (this.yawVariation > 1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (MathHelper.func_76135_e((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, EntityLivingBase entity) {
        this.calculateChainFlapBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78796_g += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevPitchVariation, (float)this.pitchVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78795_f += rotateAmount;
        }
    }

    public void applyChainFlapBuffer(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78808_h += rotateAmount;
        }
    }

    public void applyChainFlapBufferReverse(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78808_h -= rotateAmount * 0.5f;
        }
    }

    public void applyChainSwingBufferReverse(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevYawVariation, (float)this.yawVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78796_g -= rotateAmount;
        }
    }

    public void applyChainWaveBufferReverse(ModelRenderer ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * ClientUtils.interpolate((float)this.prevPitchVariation, (float)this.pitchVariation, (float)LLibrary.PROXY.getPartialTicks()) / (float)boxes.length;
        for (ModelRenderer box : boxes) {
            box.field_78795_f -= rotateAmount;
        }
    }
}

