/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui.bestiary;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.client.StatCollector;
import com.github.alexthe666.iceandfire.client.gui.bestiary.ChangePageButton;
import com.github.alexthe666.iceandfire.client.gui.bestiary.IndexPageButton;
import com.github.alexthe666.iceandfire.enums.EnumBestiaryPages;
import com.github.alexthe666.iceandfire.enums.EnumDragonArmor;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemSummoningCrystal;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBestiary
extends GuiScreen {
    protected static final int X = 390;
    protected static final int Y = 245;
    private static final ResourceLocation TEXTURE = new ResourceLocation("iceandfire:textures/gui/bestiary/bestiary.png");
    private static final ResourceLocation DRAWINGS_0 = new ResourceLocation("iceandfire:textures/gui/bestiary/drawings_0.png");
    private static final ResourceLocation DRAWINGS_1 = new ResourceLocation("iceandfire:textures/gui/bestiary/drawings_1.png");
    private static final Map<String, ResourceLocation> PICTURE_LOCATION_CACHE = Maps.newHashMap();
    public List<EnumBestiaryPages> allPageTypes = new ArrayList<EnumBestiaryPages>();
    public EnumBestiaryPages pageType;
    public List<IndexPageButton> indexButtons = new ArrayList<IndexPageButton>();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    public int bookPages;
    public int indexPages;
    public int indexPagesTotal = 1;
    protected ItemStack book;
    protected boolean index;
    protected FontRenderer font = this.getFont();

    private FontRenderer getFont() {
        FontRenderer font = IceAndFireConfig.CLIENT_SETTINGS.useVanillaFont || !Minecraft.func_71410_x().field_71474_y.field_74363_ab.equalsIgnoreCase("en_us") ? Minecraft.func_71410_x().field_71466_p : (FontRenderer)IceAndFire.PROXY.getFontRenderer();
        font.func_78264_a(Minecraft.func_71410_x().func_135016_M().func_135042_a());
        font.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        return font;
    }

    public GuiBestiary(ItemStack book) {
        this.book = book;
        if (!book.func_190926_b() && book.func_77973_b() == IafItemRegistry.bestiary && book.func_77978_p() != null) {
            List<EnumBestiaryPages> pages = EnumBestiaryPages.containedPages(EnumBestiaryPages.toList(book.func_77978_p().func_74759_k("Pages")));
            this.allPageTypes.addAll(pages);
            this.indexPagesTotal = (int)Math.ceil((double)pages.size() / 10.0);
        }
        this.index = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int centerX = (this.field_146294_l - 390) / 2;
        int centerY = (this.field_146295_m - 245) / 2;
        this.previousPage = new ChangePageButton(0, centerX + 15, centerY + 215, false, 0);
        this.field_146292_n.add(this.previousPage);
        this.nextPage = new ChangePageButton(1, centerX + 357, centerY + 215, true, 0);
        this.field_146292_n.add(this.nextPage);
        if (!this.allPageTypes.isEmpty()) {
            for (int i = 0; i < this.allPageTypes.size(); ++i) {
                int xIndex = i % -2;
                int yIndex = i % 10;
                IndexPageButton button = new IndexPageButton(2 + i, centerX + 15 + xIndex * 200, centerY + 10 + yIndex * 20 - (xIndex == 1 ? 20 : 0), StatCollector.translateToLocal("bestiary." + EnumBestiaryPages.values()[this.allPageTypes.get(i).ordinal()].toString().toLowerCase()));
                this.indexButtons.add(button);
                this.field_146292_n.add(button);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k < 2) continue;
            button.field_146124_l = this.index;
            button.field_146125_m = this.index;
        }
        for (int i = 0; i < this.indexButtons.size(); ++i) {
            this.indexButtons.get((int)i).field_146125_m = i < 10 * (this.indexPages + 1) && i >= 10 * this.indexPages && this.index;
        }
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        int cornerX = (this.field_146294_l - 390) / 2;
        int cornerY = (this.field_146295_m - 245) / 2;
        GuiBestiary.func_146110_a((int)cornerX, (int)cornerY, (float)0.0f, (float)0.0f, (int)390, (int)245, (float)390.0f, (float)390.0f);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)cornerX, (float)cornerY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int short1 = 240;
        int short2 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)short1, (float)short2);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        if (!this.index) {
            this.drawPerPage(this.bookPages);
            int pageLeft = this.bookPages * 2 + 1;
            int pageRight = pageLeft + 1;
            this.font.func_175065_a(String.valueOf(pageLeft), 97.5f, 214.0f, 0x303030, false);
            this.font.func_175065_a(String.valueOf(pageRight), 297.0f, 214.0f, 0x303030, false);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawPerPage(int bookPages) {
        switch (this.pageType) {
            case INTRODUCTION: {
                if (bookPages == 0) {
                    this.drawItemStack(new ItemStack(IafItemRegistry.manuscript), 30, 14, 2.5f);
                    this.drawItemStack(new ItemStack(IafBlockRegistry.silverOre), 110, 15, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silverIngot), 140, 48, 2.0f);
                    int i = 133;
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_shovel), i += 16, 85, 1.51f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_pickaxe), i += 16, 85, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_axe), i += 16, 85, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_sword), i += 16, 85, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_hoe), i += 16, 85, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silverNugget), i += 16, 85, 1.5f);
                    int j = 148;
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_helmet), j += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_chestplate), j += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_leggings), j += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.silver_boots), j += 16, 100, 1.5f);
                }
                if (bookPages == 1) {
                    this.drawItemStack(new ItemStack(IafBlockRegistry.sapphireOre), 30, 20, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.sapphireGem), 40, 60, 2.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 0, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    boolean drawGold = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 20 < 10;
                    this.drawItemStack(new ItemStack(drawGold ? Items.field_151074_bl : IafItemRegistry.silverNugget), 144, 34, 1.5f);
                    this.drawItemStack(new ItemStack(drawGold ? Items.field_151074_bl : IafItemRegistry.silverNugget), 161, 34, 1.5f);
                    this.drawItemStack(new ItemStack(drawGold ? IafBlockRegistry.goldPile : IafBlockRegistry.silverPile), 151, 7, 2.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 90, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(Blocks.field_150344_f), 161, 124, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150344_f), 161, 107, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151122_aG), 161, 91, 1.5f);
                    this.drawItemStack(new ItemStack(IafBlockRegistry.lectern), 151, 78, 2.0f);
                }
                this.writeFromTxt();
                break;
            }
            case FIREDRAGON: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 20, 50, 127, 0, 88, 62);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 38, 60, 0, 0, 127, 62);
                    this.drawImage(DRAWINGS_0, 240, 5, 0, 185, 114, 62);
                    this.drawImage(DRAWINGS_0, 240, 150, 0, 62, 99, 37);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 42, 80, 0, 99, 100, 41);
                    this.drawImage(DRAWINGS_0, 44, 160, 0, 140, 95, 45);
                    GL11.glPopMatrix();
                }
                if (bookPages == 3) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 45, 50, 214, 0, 87, 63);
                    this.drawImage(DRAWINGS_0, 45, 110, 214, 62, 89, 62);
                    this.drawImage(DRAWINGS_0, 245, 10, 214, 124, 89, 63);
                    this.drawImage(DRAWINGS_0, 245, 70, 214, 184, 89, 64);
                    this.drawImage(DRAWINGS_0, 245, 130, 300, 0, 88, 62);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case FIREDRAGONEGG: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 20, 95, 327, 118, 24, 33);
                    this.drawImage(DRAWINGS_0, 60, 95, 303, 118, 24, 33);
                    this.drawImage(DRAWINGS_0, 95, 95, 351, 118, 24, 33);
                    this.drawImage(DRAWINGS_0, 135, 95, 375, 118, 24, 33);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 25, 20, 303, 62, 71, 56);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case ICEDRAGON: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 20, 50, 127, 248, 87, 62);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 38, 60, 0, 247, 126, 61);
                    this.drawImage(DRAWINGS_0, 240, 5, 0, 432, 114, 62);
                    this.drawImage(DRAWINGS_0, 240, 150, 0, 309, 99, 37);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 42, 80, 0, 346, 100, 41);
                    this.drawImage(DRAWINGS_0, 44, 160, 0, 387, 95, 45);
                    GL11.glPopMatrix();
                }
                if (bookPages == 3) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 50, 52, 214, 248, 86, 62);
                    this.drawImage(DRAWINGS_0, 50, 112, 214, 310, 87, 62);
                    this.drawImage(DRAWINGS_0, 250, 12, 214, 372, 87, 63);
                    this.drawImage(DRAWINGS_0, 250, 72, 214, 432, 87, 64);
                    this.drawImage(DRAWINGS_0, 250, 132, 300, 248, 71, 62);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case ICEDRAGONEGG: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 20, 95, 327, 366, 24, 33);
                    this.drawImage(DRAWINGS_0, 60, 95, 303, 366, 24, 33);
                    this.drawImage(DRAWINGS_0, 95, 95, 351, 366, 24, 33);
                    this.drawImage(DRAWINGS_0, 135, 95, 375, 366, 24, 33);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 25, 20, 303, 309, 71, 56);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case LIGHTNINGDRAGON: 
            case LIGHTNINGDRAGONEGG: 
            case HYDRA: 
            case DREAD_MOBS: {
                this.drawFromTxt();
                this.writeFromTxt();
                break;
            }
            case TAMEDDRAGONS: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 90, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(Items.field_151103_aS), 145, 124, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151147_al), 145, 107, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151103_aS), 145, 91, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151147_al), 161, 124, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151103_aS), 161, 107, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151147_al), 161, 91, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151103_aS), 177, 124, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151147_al), 177, 107, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151103_aS), 177, 91, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_meal), 151, 78, 2.0f);
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 0, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_skull), 161, 17, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 161, 32, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_stick), 151, 10, 2.0f);
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafBlockRegistry.fire_lily), 5, 14, 2.5f);
                    this.drawItemStack(new ItemStack(IafBlockRegistry.frost_lily), 30, 14, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 0, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    boolean drawFire = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 40 < 20;
                    this.drawItemStack(new ItemStack(drawFire ? IafBlockRegistry.fire_lily : IafBlockRegistry.frost_lily), 161, 17, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151054_z), 161, 32, 1.5f);
                    this.drawItemStack(new ItemStack(drawFire ? Items.field_151072_bj : Items.field_179563_cD), 177, 17, 1.5f);
                    this.drawItemStack(new ItemStack(drawFire ? IafItemRegistry.fire_stew : IafItemRegistry.frost_stew), 151, 10, 2.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 65, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 144, 97, 1.5f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 180, 110, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 180, 92, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 198, 92, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 198, 74, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_horn), 151, 60, 2.0f);
                }
                if (bookPages == 3) {
                    int j = 18;
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_armor_iron, 1, 0), j += 16, 60, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_armor_iron, 1, 1), j += 16, 60, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_armor_iron, 1, 2), j += 16, 60, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_armor_iron, 1, 3), j += 16, 60, 1.5f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 10, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 160, 12, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 180, 31, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151042_j), 199, 50, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_flute), 151, 18, 2.0f);
                }
                this.writeFromTxt();
                break;
            }
            case MATERIALS: {
                int j;
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonscales_red), 18, 16, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone), 70, 10, 2.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.witherbone), 112, 70, 2.5f);
                    j = 18;
                    this.drawItemStack(new ItemStack(EnumDragonArmor.armor_red.helmet), j += 16, 115, 1.5f);
                    this.drawItemStack(new ItemStack(EnumDragonArmor.armor_red.chestplate), j += 16, 115, 1.5f);
                    this.drawItemStack(new ItemStack(EnumDragonArmor.armor_red.leggings), j += 16, 115, 1.5f);
                    this.drawItemStack(new ItemStack(EnumDragonArmor.armor_red.boots), j += 16, 115, 1.5f);
                }
                if (bookPages == 1) {
                    j = 1;
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_sword), j += 16, 14, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_pickaxe), j += 16, 14, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_axe), j += 16, 14, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_shovel), j += 16, 14, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_hoe), j += 16, 14, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_bow), j += 16, 14, 1.5f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.fire_dragon_flesh), 18, 24, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.fire_dragon_heart), 70, 14, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragon_skull), 70, 39, 2.5f);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.fire_dragon_blood), 18, 24, 2.5f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case ALCHEMY: {
                int frame;
                this.writeFromTxt();
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.fire_dragon_blood), 10, 24, 1.65f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.ice_dragon_blood), 18, 24, 1.65f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.lightning_dragon_blood), 26, 24, 1.65f);
                    GL11.glPopMatrix();
                    frame = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60;
                    Item blood = IafItemRegistry.fire_dragon_blood;
                    Item sword = IafItemRegistry.dragonbone_sword_fire;
                    if (frame >= 40) {
                        blood = IafItemRegistry.lightning_dragon_blood;
                        sword = IafItemRegistry.dragonbone_sword_lightning;
                    } else if (frame >= 20) {
                        blood = IafItemRegistry.ice_dragon_blood;
                        sword = IafItemRegistry.dragonbone_sword_ice;
                    }
                    this.drawItemStack(new ItemStack(IafItemRegistry.dragonbone_sword), 161, 17, 1.5f);
                    this.drawItemStack(new ItemStack(blood), 161, 32, 1.5f);
                    this.drawItemStack(new ItemStack(sword), 151, 10, 2.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 0, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                }
                if (bookPages != 1) break;
                frame = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60;
                ItemSummoningCrystal summoningCrystal = IafItemRegistry.summoning_crystal_fire;
                Item gem = Items.field_151166_bC;
                Item blood = IafItemRegistry.fire_dragon_blood;
                if (frame >= 40) {
                    summoningCrystal = IafItemRegistry.summoning_crystal_lightning;
                    gem = IafItemRegistry.amethystGem;
                    blood = IafItemRegistry.lightning_dragon_blood;
                } else if (frame >= 20) {
                    summoningCrystal = IafItemRegistry.summoning_crystal_ice;
                    gem = IafItemRegistry.sapphireGem;
                    blood = IafItemRegistry.ice_dragon_blood;
                }
                ItemStack[] ingredients = new ItemStack[]{new ItemStack(gem), new ItemStack(Items.field_151079_bi), new ItemStack(gem), new ItemStack(Items.field_151079_bi), new ItemStack(blood), new ItemStack(Items.field_151079_bi), new ItemStack(gem), new ItemStack(Items.field_151079_bi), new ItemStack(gem)};
                RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)15.0f, (float)44.0f, (float)0.0f);
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.0f);
                this.drawRecipe(new ItemStack((Item)summoningCrystal), ingredients);
                GL11.glPopMatrix();
                break;
            }
            case VILLAGERS: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 35, 50, 388, 52, 58, 36);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.fishing_spear), 70, 2, 2.5f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case HIPPOGRYPH: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 29, 150, 303, 151, 61, 36);
                    this.drawImage(DRAWINGS_0, 91, 150, 364, 151, 61, 36);
                    this.drawImage(DRAWINGS_0, 151, 150, 425, 151, 61, 36);
                    this.drawImage(DRAWINGS_0, 29, 190, 303, 187, 61, 36);
                    this.drawImage(DRAWINGS_0, 91, 190, 364, 187, 61, 36);
                    this.drawImage(DRAWINGS_0, 151, 190, 425, 187, 61, 36);
                    this.drawImage(DRAWINGS_0, 90, 230, 425, 223, 61, 35);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_179556_br), 70, 20, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    int drawType;
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 16, 24, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 10, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_151008_G), 160, 31, 1.5f);
                    int n = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 40 ? 2 : (drawType = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 20 ? 1 : 0);
                    this.drawItemStack(new ItemStack(drawType == 0 ? Items.field_151138_bX : (drawType == 1 ? Items.field_151136_bY : Items.field_151125_bZ)), 180, 31, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151008_G), 199, 31, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(drawType == 0 ? IafItemRegistry.iron_hippogryph_armor : (drawType == 1 ? IafItemRegistry.gold_hippogryph_armor : IafItemRegistry.diamond_hippogryph_armor)), 151, 18, 2.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_179560_bq), 70, 23, 2.5f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case GORGON: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 10, 89, 473, 117, 19, 34);
                    this.drawImage(DRAWINGS_0, 50, 78, 399, 106, 28, 45);
                    this.drawImage(DRAWINGS_0, 100, 89, 455, 117, 18, 34);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 70, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_151007_F), 160, 97, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151116_aA), 180, 97, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151007_F), 199, 97, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.blindfold), 171, 65, 2.0f);
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.gorgon_head), 16, 12, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 37, 95, 473, 117, 19, 34);
                    this.drawImage(DRAWINGS_0, 60, 95, 455, 117, 18, 34);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case PIXIE: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_0, 20, 60, 371, 258, 47, 35);
                    this.drawImage(DRAWINGS_0, 42, 95, 416, 258, 45, 35);
                    this.drawImage(DRAWINGS_0, 67, 60, 462, 258, 47, 35);
                    this.drawImage(DRAWINGS_0, 88, 95, 370, 293, 47, 35);
                    this.drawImage(DRAWINGS_0, 110, 60, 416, 293, 47, 35);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.pixie_dust), 70, 10, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    GL11.glTranslatef((float)20.0f, (float)24.0f, (float)0.0f);
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 100, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 160, 113, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 199, 113, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150344_f), 180, 113, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 160, 131, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 199, 131, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 180, 150, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 160, 150, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150359_w), 199, 150, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafBlockRegistry.jar_empty), 171, 85, 2.0f);
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.ambrosia), 19, 22, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 100, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.pixie_dust), 180, 131, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151150_bK), 160, 131, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151060_bw), 199, 131, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151054_z), 180, 150, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.ambrosia), 171, 85, 2.0f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case CYCLOPS: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                    this.drawImage(DRAWINGS_0, 185, 8, 399, 328, 24, 63);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                    this.drawImage(DRAWINGS_0, 50, 35, 423, 328, 24, 63);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 50, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack((Item)Items.field_151024_Q), 180, 76, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 160, 76, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 199, 76, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 160, 57, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 180, 57, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 199, 57, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.sheep_helmet), 165, 45, 2.0f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 144, 95, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack((Item)Items.field_151027_R), 180, 126, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 160, 126, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 199, 126, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 160, 107, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 199, 107, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 160, 145, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 180, 145, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 199, 145, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.sheep_chestplate), 165, 95, 2.0f);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
                    this.drawImage(DRAWINGS_0, 185, 30, 447, 328, 24, 63);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 13, 24, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack((Item)Items.field_151026_S), 34, 46, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 14, 46, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 53, 46, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 14, 27, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 34, 27, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 53, 27, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 14, 65, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 53, 65, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.sheep_leggings), 64, 27, 2.0f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 13, 84, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack((Item)Items.field_151021_T), 34, 94, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 14, 113, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 53, 113, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 14, 94, 1.5f);
                    this.drawItemStack(new ItemStack(Blocks.field_150325_L), 53, 94, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.sheep_boots), 64, 73, 2.0f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case SIREN: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                    this.drawImage(DRAWINGS_1, 190, 25, 0, 0, 25, 42);
                    this.drawImage(DRAWINGS_1, 220, 15, 25, 0, 25, 42);
                    this.drawImage(DRAWINGS_1, 255, 25, 50, 0, 25, 42);
                    this.drawImage(DRAWINGS_1, 190, 135, 0, 42, 26, 28);
                    this.drawImage(DRAWINGS_1, 220, 125, 26, 42, 26, 28);
                    this.drawImage(DRAWINGS_1, 255, 135, 52, 42, 26, 28);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.earplugs), 18, 40, 2.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    GL11.glPushMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 160, 0, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_150471_bO)), 180, 20, 1.5f);
                    this.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_150471_bO)), 215, 20, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.earplugs), 170, 10, 2.0f);
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.shiny_scales), 123, 75, 1.5f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case HIPPOCAMPUS: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_1, 210, 25, 0, 70, 57, 49);
                    this.drawImage(DRAWINGS_1, 265, 25, 57, 70, 57, 49);
                    this.drawImage(DRAWINGS_1, 320, 25, 0, 119, 57, 49);
                    this.drawImage(DRAWINGS_1, 210, 80, 57, 119, 57, 49);
                    this.drawImage(DRAWINGS_1, 265, 80, 0, 168, 57, 49);
                    this.drawImage(DRAWINGS_1, 320, 80, 57, 168, 57, 49);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Blocks.field_150360_v), 37, 33, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_179563_cD), 37, 73, 1.5f);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 35, 25, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.shiny_scales), 35, 75, 1.5f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case DEATHWORM: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_1, 230, 25, 0, 217, 133, 16);
                    this.drawImage(DRAWINGS_1, 230, 50, 0, 233, 133, 16);
                    this.drawImage(DRAWINGS_1, 230, 75, 0, 249, 133, 16);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    this.drawImage(DRAWINGS_1, 25, 95, 0, 265, 148, 44);
                    this.drawImage(DRAWINGS_1, 250, 5, 0, 309, 81, 162);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    int drawType = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 40 ? 2 : (Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 20 ? 1 : 0);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)2.5f, (float)2.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.deathworm_chitin, 1, drawType), 17, 30, 1.5f);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(drawType == 2 ? IafItemRegistry.deathworm_red_helmet : (drawType == 1 ? IafItemRegistry.deathworm_white_helmet : IafItemRegistry.deathworm_yellow_helmet)), 92, 8, 1.5f);
                    this.drawItemStack(new ItemStack(drawType == 2 ? IafItemRegistry.deathworm_red_chestplate : (drawType == 1 ? IafItemRegistry.deathworm_white_chestplate : IafItemRegistry.deathworm_yellow_chestplate)), 112, 8, 1.5f);
                    this.drawItemStack(new ItemStack(drawType == 2 ? IafItemRegistry.deathworm_red_leggings : (drawType == 1 ? IafItemRegistry.deathworm_white_leggings : IafItemRegistry.deathworm_yellow_leggings)), 132, 8, 1.5f);
                    this.drawItemStack(new ItemStack(drawType == 2 ? IafItemRegistry.deathworm_red_boots : (drawType == 1 ? IafItemRegistry.deathworm_white_boots : IafItemRegistry.deathworm_yellow_boots)), 152, 8, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.deathworm_egg), 125, 42, 1.5f);
                    GL11.glPopMatrix();
                }
                if (bookPages == 3) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.deathworm_egg, 1, 1), 125, 4, 1.5f);
                    this.drawItemStack(new ItemStack((Item)Items.field_151112_aM), 115, 55, 1.5f);
                    this.drawItemStack(new ItemStack((Item)Items.field_151112_aM), 135, 55, 1.5f);
                    GL11.glPopMatrix();
                }
                this.writeFromTxt();
                break;
            }
            case COCKATRICE: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_1, 155, 10, 114, 0, 88, 36);
                    this.drawImage(DRAWINGS_1, 155, 45, 114, 36, 88, 36);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 18, 10, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_151007_F), 20, 30, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151116_aA), 40, 30, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151007_F), 59, 30, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.blindfold), 60, 18, 2.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.witherbone), 30, 58, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.rotten_egg), 109, 18, 2.5f);
                }
                this.writeFromTxt();
                break;
            }
            case STYMPHALIANBIRD: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_1, 34, 46, 114, 72, 59, 37);
                    this.drawImage(DRAWINGS_1, 155, 35, 114, 109, 67, 35);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.stymphalian_bird_feather), 109, 60, 2.5f);
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 18, 10, 389, 1, 50, 50);
                    GL11.glPopMatrix();
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.9f, (float)0.9f, (float)1.0f);
                    this.drawItemStack(new ItemStack(Items.field_151145_ak), 40, 13, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 40, 30, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.stymphalian_bird_feather), 40, 49, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.stymphalian_arrow), 60, 18, 2.0f);
                }
                this.writeFromTxt();
                break;
            }
            case TROLL: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_1, 15, 60, 156, 211, 25, 58);
                    this.drawImage(DRAWINGS_1, 50, 55, 181, 211, 25, 58);
                    this.drawImage(DRAWINGS_1, 85, 60, 206, 211, 25, 58);
                    this.drawImage(DRAWINGS_1, 155, 22, 114, 145, 24, 66);
                    this.drawImage(DRAWINGS_1, 190, 19, 188, 142, 47, 69);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    int i = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumTroll.Weapon.values().length * 20) / 20;
                    this.drawItemStack(new ItemStack(EnumTroll.Weapon.values()[i].item), 30, 7, 2.5f);
                    int j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumTroll.values().length * 20) / 20;
                    this.drawItemStack(new ItemStack(EnumTroll.values()[j].leather), 100, 30, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.troll_tusk), 120, 30, 2.5f);
                }
                if (bookPages == 2) {
                    int j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumTroll.values().length * 20) / 20;
                    this.drawItemStack(new ItemStack(EnumTroll.values()[j].helmet), 27, 15, 1.5f);
                    this.drawItemStack(new ItemStack(EnumTroll.values()[j].chestplate), 47, 15, 1.5f);
                    this.drawItemStack(new ItemStack(EnumTroll.values()[j].leggings), 67, 15, 1.5f);
                    this.drawItemStack(new ItemStack(EnumTroll.values()[j].boots), 87, 15, 1.5f);
                }
                this.writeFromTxt();
                break;
            }
            case MYRMEX: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.51f, (float)1.51f, (float)1.0f);
                    this.drawImage(DRAWINGS_1, 137, 10, 202, 16, 57, 21);
                    this.drawImage(DRAWINGS_1, 195, 10, 278, 16, 57, 21);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.51f, (float)1.51f, (float)1.0f);
                    this.drawImage(DRAWINGS_1, 7, 17, 202, 37, 59, 21);
                    this.drawImage(DRAWINGS_1, 65, 17, 278, 37, 59, 21);
                    this.drawImage(DRAWINGS_1, 7, 77, 202, 58, 59, 21);
                    this.drawImage(DRAWINGS_1, 65, 77, 278, 58, 59, 21);
                    this.drawImage(DRAWINGS_1, 145, 20, 278, 103, 43, 45);
                    this.drawImage(DRAWINGS_1, 195, 20, 321, 103, 43, 45);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.51f, (float)1.51f, (float)1.0f);
                    this.drawImage(DRAWINGS_1, 25, 13, 202, 79, 76, 24);
                    this.drawImage(DRAWINGS_1, 25, 40, 278, 79, 76, 24);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_desert_chitin), 125, 43, 2.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_jungle_chitin), 155, 43, 2.0f);
                    int i = 133;
                    boolean jungle = Minecraft.func_71410_x().field_71439_g.field_70173_aa % 60 > 30;
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_shovel : IafItemRegistry.myrmex_desert_shovel), i += 16, 100, 1.51f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_pickaxe : IafItemRegistry.myrmex_desert_pickaxe), i += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_axe : IafItemRegistry.myrmex_desert_axe), i += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_sword : IafItemRegistry.myrmex_desert_sword), i += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_sword_venom : IafItemRegistry.myrmex_desert_sword_venom), i += 16, 100, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_hoe : IafItemRegistry.myrmex_desert_hoe), i += 16, 100, 1.5f);
                    int j = 148;
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_helmet : IafItemRegistry.myrmex_desert_helmet), j += 16, 115, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_chestplate : IafItemRegistry.myrmex_desert_chestplate), j += 16, 115, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_leggings : IafItemRegistry.myrmex_desert_leggings), j += 16, 115, 1.5f);
                    this.drawItemStack(new ItemStack(jungle ? IafItemRegistry.myrmex_jungle_boots : IafItemRegistry.myrmex_desert_boots), j += 16, 115, 1.5f);
                }
                if (bookPages == 3) {
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_stinger), 35, 22, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_desert_resin), 25, 64, 2.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_jungle_resin), 55, 64, 2.0f);
                }
                if (bookPages == 4) {
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_desert_staff), 25, 73, 2.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_jungle_staff), 55, 73, 2.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_desert_egg), 125, 90, 2.0f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.myrmex_jungle_egg), 155, 90, 2.0f);
                }
                this.writeFromTxt();
                break;
            }
            case AMPHITHERE: {
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                    this.drawImage(DRAWINGS_1, 70, 97, 257, 163, 136, 93);
                    this.drawImage(DRAWINGS_1, 270, 50, 148, 267, 120, 51);
                    this.drawImage(DRAWINGS_1, 380, 50, 148, 318, 120, 51);
                    this.drawImage(DRAWINGS_1, 270, 100, 148, 369, 120, 51);
                    this.drawImage(DRAWINGS_1, 380, 100, 148, 420, 120, 51);
                    this.drawImage(DRAWINGS_1, 330, 150, 268, 267, 120, 51);
                    GL11.glPopMatrix();
                }
                if (bookPages == 2) {
                    this.drawItemStack(new ItemStack(IafItemRegistry.amphithere_feather), 30, 20, 2.5f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 18, 70, 389, 1, 50, 50);
                    GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
                    this.drawItemStack(new ItemStack(Items.field_151145_ak), 36, 73, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 36, 89, 1.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.amphithere_feather), 36, 106, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.amphithere_arrow), 60, 65, 2.0f);
                }
                this.writeFromTxt();
                break;
            }
            case SEASERPENT: {
                int j;
                if (bookPages == 0) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                    this.drawImage(DRAWINGS_1, 290, 5, 422, 0, 90, 64);
                    this.drawImage(DRAWINGS_1, 380, 5, 422, 64, 90, 64);
                    this.drawImage(DRAWINGS_1, 290, 70, 422, 128, 90, 64);
                    this.drawImage(DRAWINGS_1, 380, 70, 422, 192, 90, 64);
                    this.drawImage(DRAWINGS_1, 290, 140, 422, 256, 90, 64);
                    this.drawImage(DRAWINGS_1, 380, 140, 422, 320, 90, 64);
                    this.drawImage(DRAWINGS_1, 345, 210, 422, 384, 90, 64);
                    GL11.glPopMatrix();
                }
                if (bookPages == 1) {
                    this.drawImage(DRAWINGS_1, 60, 90, 337, 0, 70, 83);
                    j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumSeaSerpent.values().length * 20) / 20;
                    this.drawItemStack(new ItemStack(EnumSeaSerpent.values()[j].scale), 130, 40, 2.5f);
                    this.drawItemStack(new ItemStack(IafItemRegistry.sea_serpent_fang), 90, 40, 2.5f);
                }
                if (bookPages == 2) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
                    this.drawImage(DRAWINGS_0, 18, 30, 389, 1, 50, 50);
                    GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
                    j = Minecraft.func_71410_x().field_71439_g.field_70173_aa % (EnumSeaSerpent.values().length * 20) / 20;
                    this.drawItemStack(new ItemStack(IafItemRegistry.sea_serpent_fang), 36, 32, 1.5f);
                    this.drawItemStack(new ItemStack(Items.field_151055_y), 36, 48, 1.5f);
                    this.drawItemStack(new ItemStack(EnumSeaSerpent.values()[j].scale), 36, 66, 1.5f);
                    this.drawItemStack(new ItemStack(EnumSeaSerpent.values()[j].helmet), 34, 125, 1.5f);
                    this.drawItemStack(new ItemStack(EnumSeaSerpent.values()[j].chestplate), 50, 125, 1.5f);
                    this.drawItemStack(new ItemStack(EnumSeaSerpent.values()[j].leggings), 66, 125, 1.5f);
                    this.drawItemStack(new ItemStack(EnumSeaSerpent.values()[j].boots), 82, 125, 1.5f);
                    GL11.glPopMatrix();
                    this.drawItemStack(new ItemStack(IafItemRegistry.sea_serpent_arrow), 60, 33, 2.0f);
                }
                this.writeFromTxt();
            }
        }
    }

    public void writeFromTxt() {
        String currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale().toString();
        String filePath = "assets/iceandfire/lang/bestiary/" + currentLanguage + "/";
        String fileName = this.pageType.toString().toLowerCase() + "_" + this.bookPages + ".txt";
        InputStream fileReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath + fileName);
        if (fileReader == null) {
            IceAndFire.logger.warn("The Bestiary translation at " + fileName + " is missing for " + currentLanguage);
            filePath = "assets/iceandfire/lang/bestiary/en_US/";
            fileReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath + fileName);
        }
        if (fileReader == null) {
            IceAndFire.logger.warn("The Bestiary translation " + fileName + " is missing.");
            return;
        }
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileReader));
            int linenumber = 0;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains("<") || line.contains(">")) continue;
                GL11.glPushMatrix();
                if (this.usingVanillaFont()) {
                    GL11.glScalef((float)0.945f, (float)0.945f, (float)0.945f);
                    GL11.glTranslatef((float)0.0f, (float)5.5f, (float)0.0f);
                }
                if (linenumber <= 19) {
                    this.font.func_175065_a(line, 15.0f, (float)(20 + linenumber * 10), 0x303030, false);
                } else {
                    this.font.func_175065_a(line, 220.0f, (float)((linenumber - 19) * 10), 0x303030, false);
                }
                ++linenumber;
                GL11.glPopMatrix();
            }
            fileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.font.func_175065_a(StatCollector.translateToLocal("bestiary." + this.pageType.toString().toLowerCase()), 10.0f, 2.0f, 8025450, false);
        GL11.glPopMatrix();
    }

    private boolean usingVanillaFont() {
        return this.font == Minecraft.func_71410_x().field_71466_p;
    }

    public void drawFromTxt() {
        String currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale().toString();
        String filePath = "assets/iceandfire/lang/bestiary/" + currentLanguage + "/";
        String fileName = this.pageType.toString().toLowerCase() + "_" + this.bookPages + ".txt";
        InputStream fileReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath + fileName);
        if (fileReader == null) {
            IceAndFire.logger.warn("The Bestiary translation at " + fileName + " is missing for " + currentLanguage);
            filePath = "assets/iceandfire/lang/bestiary/en_US/";
            fileReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath + fileName);
        }
        if (fileReader == null) {
            IceAndFire.logger.warn("The Bestiary translation " + fileName + " is missing.");
            return;
        }
        ArrayList<String[]> images = new ArrayList<String[]>();
        ArrayList<String[]> itemStacks = new ArrayList<String[]>();
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileReader));
            while ((line = bufferedReader.readLine()) != null) {
                if (((line = line.trim()).contains("<") || line.contains(">")) && line.contains("<image>")) {
                    line = line.substring(8, line.length() - 1);
                    String[] image = line.split(" ");
                    images.add(image);
                }
                if (line.contains("<item>")) {
                    line = line.substring(7, line.length() - 1);
                    String[] itemStack = line.split(" ");
                    itemStacks.add(itemStack);
                }
                if (!line.contains("<recipe>")) continue;
                line = line.substring(9, line.length() - 1);
                String[] split = line.split(" ");
                RenderHelper.func_74520_c();
                float scale = Float.parseFloat(split[split.length - 1]);
                int x = Integer.parseInt(split[split.length - 3]);
                int y = Integer.parseInt(split[split.length - 2]);
                ItemStack result = new ItemStack(GuiBestiary.getItemByRegistryName(split[0]), 1, Integer.parseInt(split[1]));
                ItemStack[] ingredients = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                int j = 8;
                for (int i = split.length - 5; i >= 2; i -= 2) {
                    ingredients[j] = new ItemStack(GuiBestiary.getItemByRegistryName(split[i]), 1, Integer.parseInt(split[i + 1]));
                    --j;
                }
                RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)x, (float)y, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)0.0f);
                this.drawRecipe(result, ingredients);
                GL11.glPopMatrix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!images.isEmpty()) {
            for (String[] image : images) {
                float scale = Float.parseFloat(image[7]);
                GL11.glPushMatrix();
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                String texture = "iceandfire:textures/gui/bestiary/" + image[0];
                ResourceLocation resourcelocation = PICTURE_LOCATION_CACHE.get(texture);
                if (resourcelocation == null) {
                    resourcelocation = new ResourceLocation(texture);
                    PICTURE_LOCATION_CACHE.put(texture, resourcelocation);
                }
                this.drawImage(resourcelocation, Integer.parseInt(image[1]), Integer.parseInt(image[2]), Integer.parseInt(image[3]), Integer.parseInt(image[4]), Integer.parseInt(image[5]), Integer.parseInt(image[6]));
                GL11.glPopMatrix();
            }
        }
        if (!itemStacks.isEmpty()) {
            for (String[] itemStack : itemStacks) {
                this.drawItemStack(new ItemStack(GuiBestiary.getItemByRegistryName(itemStack[0]), 1), Integer.parseInt(itemStack[2]), Integer.parseInt(itemStack[3]), Float.parseFloat(itemStack[4]) * 2.0f);
            }
        }
    }

    private void drawRecipe(ItemStack result, ItemStack[] ingredients) {
        this.drawItemStack(result, 62, 17, 2.0f);
        for (int i = 0; i < 9; ++i) {
            this.drawItemStack(ingredients[i], i % 3 * 22 + 30, i / 3 * 22 + 10, 1.25f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)37.0f, (float)13.0f, (float)1.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
        this.drawImage(DRAWINGS_0, 0, 0, 389, 1, 50, 50);
        GL11.glPopMatrix();
    }

    private static Item getItemByRegistryName(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }

    public void drawImage(ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        GuiBestiary.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (float)512.0f, (float)512.0f);
    }

    private void drawItemStack(ItemStack stack, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, null);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GL11.glPopMatrix();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && (this.index ? this.indexPages > 0 : this.pageType != null && this.bookPages > 0)) {
            if (this.index) {
                --this.indexPages;
            } else {
                --this.bookPages;
            }
        }
        if (button.field_146127_k == 1 && (this.index ? this.indexPages < this.indexPagesTotal - 1 : this.pageType != null && this.bookPages < this.pageType.pages)) {
            if (this.index) {
                ++this.indexPages;
            } else {
                ++this.bookPages;
            }
        }
        if (button.field_146127_k >= 2 && this.indexButtons.get(button.field_146127_k - 2) != null && this.allPageTypes.get(button.field_146127_k - 2) != null && button instanceof IndexPageButton) {
            this.index = false;
            this.indexPages = 0;
            this.bookPages = 0;
            this.pageType = this.allPageTypes.get(button.field_146127_k - 2);
        }
    }
}

