/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.IceAndFireConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockReturningState
extends Block {
    private final IBlockState returnState;
    public static final PropertyBool REVERTS = PropertyBool.func_177716_a((String)"revert");

    public BlockReturningState(Material materialIn, String gameName, String name, String toolUsed, int toolStrength, float hardness, float resistance, SoundType sound, IBlockState returnToState) {
        this(materialIn, gameName, name, toolUsed, toolStrength, hardness, resistance, sound, false, returnToState);
    }

    public BlockReturningState(Material materialIn, String gameName, String name, String toolUsed, int toolStrength, float hardness, float resistance, SoundType sound, boolean slippery, IBlockState returnToState) {
        super(materialIn);
        this.func_149663_c(name);
        this.setHarvestLevel(toolUsed, toolStrength);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(sound);
        this.func_149647_a(IceAndFire.TAB_BLOCKS);
        if (slippery) {
            this.setDefaultSlipperiness(0.98f);
        }
        this.setRegistryName("iceandfire", gameName);
        this.returnState = returnToState;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)REVERTS, (Comparable)Boolean.FALSE));
        this.func_149675_a(IceAndFireConfig.DRAGON_SETTINGS.dragonAffectedBlocksRevert);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (IceAndFireConfig.DRAGON_SETTINGS.dragonAffectedBlocksRevert && !worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)REVERTS)).booleanValue() && rand.nextInt(3) == 0 && worldIn.func_175697_a(pos, 3)) {
            worldIn.func_175656_a(pos, this.returnState);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)REVERTS, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)REVERTS) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{REVERTS});
    }
}

