/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component;

import com.fantasticsource.tools.component.Component;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class CStringUTF8
extends Component {
    public String value;

    public CStringUTF8 set(String value) {
        this.value = value;
        return this;
    }

    @Override
    public CStringUTF8 write(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.value);
        return this;
    }

    @Override
    public CStringUTF8 read(ByteBuf buf) {
        this.value = ByteBufUtils.readUTF8String((ByteBuf)buf);
        return this;
    }

    @Override
    public CStringUTF8 save(OutputStream stream) {
        try {
            byte[] bytes = this.value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            stream.write(new byte[]{(byte)(length >>> 24), (byte)(length >>> 16), (byte)(length >>> 8), (byte)length});
            stream.write(bytes);
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CStringUTF8 load(InputStream stream) {
        try {
            byte[] bytes = new byte[4];
            if (stream.read(bytes) < 4) {
                throw new IOException("Reached end of file while reading!");
            }
            int length = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            if (stream.read(bytes = new byte[length]) < length) {
                throw new IOException("Reached end of file while reading!");
            }
            this.value = new String(bytes, StandardCharsets.UTF_8);
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

