/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.other;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.other.GUIGradientBorder;
import com.fantasticsource.mctools.gui.element.view.GUIScrollView;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;

public class GUIVerticalScrollbar
extends GUIGradientBorder {
    private GUIGradientBorder slider;
    private GUIScrollView scrollView;

    public GUIVerticalScrollbar(GUIScreen screen, double width, double height, Color backgroundBorder, Color backgroundCenter, Color sliderBorder, Color sliderCenter, GUIScrollView scrollView) {
        super(screen, width, height, 0.3333333333333333, backgroundBorder, backgroundCenter);
        this.scrollView = scrollView;
        this.slider = new GUIGradientBorder(screen, 0.0, -9999.0, 1.0, 0.1, 0.3333333333333333, sliderBorder, sliderCenter);
        this.add(this.slider);
    }

    public GUIVerticalScrollbar(GUIScreen screen, double x, double y, double width, double height, Color backgroundBorder, Color backgroundCenter, Color sliderBorder, Color sliderCenter, GUIScrollView scrollView) {
        super(screen, x, y, width, height, 0.3333333333333333, backgroundBorder, backgroundCenter);
        this.scrollView = scrollView;
        this.slider = new GUIGradientBorder(screen, 0.0, -9999.0, 1.0, 0.1, 0.3333333333333333, sliderBorder, sliderCenter);
        this.add(this.slider);
    }

    @Override
    public void draw() {
        this.slider.y = this.scrollView.progress >= 0.0 && this.scrollView.progress <= 1.0 ? (1.0 - this.slider.height) * this.scrollView.progress : -99999.0;
        super.draw();
    }

    @Override
    public void mouseWheel(int delta) {
        if (this.scrollView.progress != -1.0 && (this.isMouseWithin() || this.scrollView.isMouseWithin())) {
            if (delta < 0) {
                this.scrollView.progress += 0.25 / this.scrollView.internalHeight;
                if (this.scrollView.progress > 1.0) {
                    this.scrollView.progress = 1.0;
                }
            } else {
                this.scrollView.progress -= 0.25 / this.scrollView.internalHeight;
                if (this.scrollView.progress < 0.0) {
                    this.scrollView.progress = 0.0;
                }
            }
        }
    }

    @Override
    public boolean mousePressed(int button) {
        boolean result = super.mousePressed(button);
        this.setActive(result);
        if (this.active && this.scrollView.progress != -1.0) {
            this.scrollView.progress = Tools.min(Tools.max((this.mouseY() - this.absoluteY() - this.slider.absoluteHeight() * 0.5) / (this.absoluteHeight() - this.slider.absoluteHeight()), 0.0), 1.0);
        }
        return result;
    }

    @Override
    public void mouseDrag(int button) {
        if (this.active && button == 0) {
            if (this.scrollView.progress == -1.0) {
                this.setActive(false);
            } else {
                this.scrollView.progress = Tools.min(Tools.max((this.mouseY() - this.absoluteY() - this.slider.absoluteHeight() * 0.5) / (this.absoluteHeight() - this.slider.absoluteHeight()), 0.0), 1.0);
            }
        }
    }
}

