/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.event;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GametypeChangedEvent
extends Event {
    public static final HashMap<Pair<UUID, Boolean>, GameType> PLAYER_GAMETYPES = new HashMap();
    public final EntityPlayer player;
    public final GameType oldGameType;
    public final GameType newGameType;

    public GametypeChangedEvent(EntityPlayer player, GameType oldGameType, GameType newGameType) {
        this.player = player;
        this.oldGameType = oldGameType;
        this.newGameType = newGameType;
    }

    @SubscribeEvent
    public static void playerLogoffServer(PlayerEvent.PlayerLoggedOutEvent event) {
        GameType oldGameType = PLAYER_GAMETYPES.remove(new Pair<UUID, Boolean>(event.player.getPersistentID(), event.player instanceof EntityPlayerMP));
        if (oldGameType != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GametypeChangedEvent(event.player, oldGameType, null));
        }
    }

    public static void serverStopped(FMLServerStoppedEvent event) {
        PLAYER_GAMETYPES.clear();
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        GameType newGameType;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        Pair<UUID, Boolean> pair = new Pair<UUID, Boolean>(player.getPersistentID(), player instanceof EntityPlayerMP);
        GameType oldGameType = PLAYER_GAMETYPES.get(pair);
        if (oldGameType != (newGameType = MCTools.getGameType(player))) {
            PLAYER_GAMETYPES.put(pair, newGameType);
            MinecraftForge.EVENT_BUS.post((Event)new GametypeChangedEvent(player, oldGameType, newGameType));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void playerLogoffClient(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GameType oldGameType = PLAYER_GAMETYPES.remove(new Pair<UUID, Boolean>(player.getPersistentID(), false));
        if (oldGameType != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GametypeChangedEvent((EntityPlayer)player, oldGameType, null));
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(GametypeChangedEvent.class);
    }
}

