/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.ai.utils;

import funwayguy.epicsiegemod.core.ESM;
import java.lang.reflect.Field;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;

public class CreeperHooks {
    private static final DataParameter<Boolean> POWERED;
    private static Field blastSize;
    private EntityCreeper creeper;

    public CreeperHooks(EntityCreeper creeper) {
        this.creeper = creeper;
    }

    public EntityCreeper getCreeper() {
        return this.creeper;
    }

    public boolean isPowered() {
        return (Boolean)this.creeper.func_184212_Q().func_187225_a(POWERED);
    }

    public void setPowered(boolean state) {
        this.creeper.func_184212_Q().func_187227_b(POWERED, (Object)state);
    }

    public int getExplosionSize() {
        try {
            return blastSize.getInt(this.creeper);
        }
        catch (Exception e) {
            ESM.logger.log(Level.ERROR, "Unable to get creeper blast radius", (Throwable)e);
            return 3;
        }
    }

    public void setExplosionSize(int value) {
        try {
            blastSize.setInt(this.creeper, value);
        }
        catch (Exception e) {
            ESM.logger.log(Level.ERROR, "Unable to set creeper blast radius", (Throwable)e);
        }
    }

    static {
        blastSize = null;
        POWERED = (DataParameter)ObfuscationReflectionHelper.getPrivateValue(EntityCreeper.class, null, (String[])new String[]{"field_184714_b", "POWERED"});
        try {
            blastSize = EntityCreeper.class.getDeclaredField("field_82226_g");
            blastSize.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                blastSize = EntityCreeper.class.getDeclaredField("explosionRadius");
                blastSize.setAccessible(true);
            }
            catch (Exception e2) {
                ESM.logger.log(Level.ERROR, "Unable to set Creeper hooks");
            }
        }
    }
}

