/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.LongStream;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.integration.Hats;
import meldexun.entityculling.util.CachedBlockAccess;
import meldexun.entityculling.util.ICullable;
import meldexun.entityculling.util.function.DoubleDoubleDouble2BooleanFunction;
import meldexun.entityculling.util.function.IntIntInt2BooleanFunction;
import meldexun.entityculling.util.raytracing.RaytracingEngine;
import meldexun.renderlib.api.IBoundingBoxCache;
import meldexun.renderlib.api.IEntityRendererCache;
import meldexun.renderlib.api.ILoadable;
import meldexun.renderlib.api.ITileEntityRendererCache;
import meldexun.renderlib.config.RenderLibConfig;
import meldexun.renderlib.integration.Optifine;
import meldexun.renderlib.util.MutableAABB;
import meldexun.renderlib.util.timer.CPUTimer;
import meldexun.renderlib.util.timer.ITimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CullingThread
extends Thread {
    private final CachedBlockAccess cachedBlockAccess = new CachedBlockAccess();
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final RaytracingEngine engine = new RaytracingEngine(EntityCullingConfig.cacheSize, (x, y, z) -> this.cachedBlockAccess.func_180495_p((BlockPos)this.mutablePos.func_181079_c(x, y, z)).func_185914_p(), () -> Minecraft.func_71410_x().field_71474_y.field_151451_c);
    private double sleepOverhead = 0.0;
    public final ITimer timer = new ITimer(){
        private final ITimer timer = new CPUTimer("CPU (Cull Async)", 100);
        private volatile String avgString = "0.0ms";
        private volatile String minString = "0.0ms";
        private volatile String maxString = "0.0ms";

        public void update() {
            if (RenderLibConfig.showFrameTimes) {
                this.avgString = this.timer.avgString();
                this.minString = this.timer.minString();
                this.maxString = this.timer.maxString();
            }
            this.timer.update();
        }

        public void stop() {
            this.timer.stop();
        }

        public void start() {
            this.timer.start();
        }

        public LongStream results() {
            return this.timer.results();
        }

        public String getName() {
            return this.timer.getName();
        }

        public String avgString() {
            return this.avgString;
        }

        public String minString() {
            return this.minString;
        }

        public String maxString() {
            return this.maxString;
        }
    };
    private boolean spectator;
    private double camX;
    private double camY;
    private double camZ;
    private double x;
    private double y;
    private double z;

    public CullingThread() {
        this.setName("Culling Thread");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Minecraft mc = Minecraft.func_71410_x();
        while (true) {
            long t;
            block14: {
                t = System.nanoTime();
                this.timer.update();
                this.timer.start();
                try {
                    WorldClient world = mc.field_71441_e;
                    EntityPlayerSP player = mc.field_71439_g;
                    Entity renderViewEntity = mc.func_175606_aa();
                    if (world == null || player == null || renderViewEntity == null) break block14;
                    this.cachedBlockAccess.setupCached((World)world);
                    this.spectator = player.func_175149_v();
                    float partialTicks = mc.func_184121_ak();
                    this.x = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
                    this.y = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
                    this.z = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
                    Vec3d cameraPosition = ActiveRenderInfo.getCameraPosition();
                    this.camX = this.x + cameraPosition.field_72450_a;
                    this.camY = this.y + cameraPosition.field_72448_b;
                    this.camZ = this.z + cameraPosition.field_72449_c;
                    this.engine.setup(this.camX, this.camY, this.camZ);
                    Iterator entityIterator = world.field_72996_f.iterator();
                    while (entityIterator.hasNext()) {
                        Entity entity;
                        try {
                            entity = (Entity)entityIterator.next();
                        }
                        catch (ConcurrentModificationException | NoSuchElementException e) {
                            break;
                        }
                        if (entity == null) continue;
                        this.updateEntityCullingState(entity);
                    }
                    Iterator tileEntityIterator = world.field_147482_g.iterator();
                    while (tileEntityIterator.hasNext()) {
                        TileEntity tileEntity;
                        try {
                            tileEntity = (TileEntity)tileEntityIterator.next();
                        }
                        catch (ConcurrentModificationException | NoSuchElementException e) {
                            break;
                        }
                        if (tileEntity == null) continue;
                        this.updateTileEntityCullingState(tileEntity);
                    }
                }
                catch (Throwable e) {
                    mc.func_71404_a(new CrashReport("Culling Thread crashed!", e));
                }
                finally {
                    this.cachedBlockAccess.clearCache();
                    this.engine.clearCache();
                }
            }
            this.timer.stop();
            double d = (double)(System.nanoTime() - t) / 1000000.0 + this.sleepOverhead;
            this.sleepOverhead = d % 1.0;
            long sleepTime = 10L - (long)d;
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void updateEntityCullingState(Entity entity) {
        if (!EntityCulling.useOpenGlBasedCulling()) {
            ((ICullable)entity).setCulled(!this.checkEntityVisibility(entity));
        }
        if (Optifine.isOptifineDetected()) {
            ((ICullable)entity).setShadowCulled(!this.checkEntityShadowVisibility(entity));
        }
    }

    private void updateTileEntityCullingState(TileEntity tileEntity) {
        if (!EntityCulling.useOpenGlBasedCulling()) {
            ((ICullable)tileEntity).setCulled(!this.checkTileEntityVisibility(tileEntity));
        }
        if (Optifine.isOptifineDetected()) {
            ((ICullable)tileEntity).setShadowCulled(!this.checkTileEntityShadowVisibility(tileEntity));
        }
    }

    private boolean checkEntityVisibility(Entity entity) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (EntityCullingConfig.disabledInSpectator && this.spectator) {
            return true;
        }
        if (!EntityCullingConfig.entity.skipHiddenEntityRendering) {
            return true;
        }
        if (EntityCulling.isHatsInstalled && Hats.isHat(entity)) {
            return false;
        }
        if (EntityCullingConfig.entity.alwaysRenderBosses && !entity.func_184222_aU()) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderEntitiesWithName && entity.func_94059_bO()) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderPlayers && entity instanceof EntityPlayer) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderViewEntity && entity == Minecraft.func_71410_x().func_175606_aa()) {
            return true;
        }
        if (EntityCullingConfig.entity.ignoreEndCrystalsWithBeam && entity instanceof EntityEnderCrystal && ((EntityEnderCrystal)entity).func_184518_j() != null) {
            return true;
        }
        if (((Boolean)EntityCullingConfig.entity.skipHiddenEntityRenderingBlacklistImpl.get((Object)entity)).booleanValue()) {
            return true;
        }
        if (!((IEntityRendererCache)entity).hasRenderer()) {
            return true;
        }
        if (!((ILoadable)entity).isChunkLoaded()) {
            return true;
        }
        MutableAABB aabb = ((IBoundingBoxCache)entity).getCachedBoundingBox();
        if (aabb.sizeX() > EntityCullingConfig.entity.skipHiddenEntityRenderingSize || aabb.sizeY() > EntityCullingConfig.entity.skipHiddenEntityRenderingSize || aabb.sizeZ() > EntityCullingConfig.entity.skipHiddenEntityRenderingSize) {
            return true;
        }
        if (!((ICullable)entity).canBeOcclusionCulled()) {
            return true;
        }
        return this.checkBox(aabb.minX(), aabb.minY(), aabb.minZ(), aabb.maxX(), aabb.maxY(), aabb.maxZ());
    }

    private boolean checkTileEntityVisibility(TileEntity tileEntity) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (EntityCullingConfig.disabledInSpectator && this.spectator) {
            return true;
        }
        if (!EntityCullingConfig.tileEntity.skipHiddenTileEntityRendering) {
            return true;
        }
        if (((Boolean)EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingBlacklistImpl.get((Object)tileEntity)).booleanValue()) {
            return true;
        }
        if (!((ITileEntityRendererCache)tileEntity).hasRenderer()) {
            return true;
        }
        if (!((ILoadable)tileEntity).isChunkLoaded()) {
            return true;
        }
        MutableAABB aabb = ((IBoundingBoxCache)tileEntity).getCachedBoundingBox();
        if (aabb.sizeX() > EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingSize || aabb.sizeY() > EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingSize || aabb.sizeZ() > EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingSize) {
            return true;
        }
        if (!((ICullable)tileEntity).canBeOcclusionCulled()) {
            return true;
        }
        return this.checkBox(aabb.minX(), aabb.minY(), aabb.minZ(), aabb.maxX(), aabb.maxY(), aabb.maxZ());
    }

    private boolean checkEntityShadowVisibility(Entity entity) {
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsCulling) {
            return true;
        }
        if (!EntityCulling.useOpenGlBasedCulling()) {
            if (!((ICullable)entity).isCulled()) {
                return true;
            }
            if (!EntityCullingConfig.optifineShaderOptions.entityShadowsCullingLessAggressiveMode) {
                return false;
            }
        } else {
            if (!EntityCullingConfig.enabled) {
                return true;
            }
            if (EntityCullingConfig.disabledInSpectator && this.spectator) {
                return true;
            }
            if (!EntityCullingConfig.entity.skipHiddenEntityRendering) {
                return true;
            }
            if (EntityCullingConfig.entity.alwaysRenderBosses && !entity.func_184222_aU()) {
                return true;
            }
            if (EntityCullingConfig.entity.alwaysRenderEntitiesWithName && entity.func_94059_bO()) {
                return true;
            }
            if (EntityCullingConfig.entity.alwaysRenderPlayers && entity instanceof EntityPlayer) {
                return true;
            }
            if (EntityCullingConfig.entity.alwaysRenderViewEntity && entity == Minecraft.func_71410_x().func_175606_aa()) {
                return true;
            }
            if (EntityCullingConfig.entity.ignoreEndCrystalsWithBeam && entity instanceof EntityEnderCrystal && ((EntityEnderCrystal)entity).func_184518_j() != null) {
                return true;
            }
            if (((Boolean)EntityCullingConfig.entity.skipHiddenEntityRenderingBlacklistImpl.get((Object)entity)).booleanValue()) {
                return true;
            }
            if (!((IEntityRendererCache)entity).hasRenderer()) {
                return true;
            }
            if (!((ILoadable)entity).isChunkLoaded()) {
                return true;
            }
            if (!((ICullable)entity).canBeOcclusionCulled()) {
                return true;
            }
        }
        return this.engine.raytraceUncachedThreshold(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v, EntityCullingConfig.optifineShaderOptions.entityShadowsCullingLessAggressiveModeDiff);
    }

    private boolean checkTileEntityShadowVisibility(TileEntity tileEntity) {
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCulling) {
            return true;
        }
        if (!EntityCulling.useOpenGlBasedCulling()) {
            if (!((ICullable)tileEntity).isCulled()) {
                return true;
            }
            if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveMode) {
                return false;
            }
        } else {
            if (!EntityCullingConfig.enabled) {
                return true;
            }
            if (EntityCullingConfig.disabledInSpectator && this.spectator) {
                return true;
            }
            if (!EntityCullingConfig.tileEntity.skipHiddenTileEntityRendering) {
                return true;
            }
            if (((Boolean)EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingBlacklistImpl.get((Object)tileEntity)).booleanValue()) {
                return true;
            }
            if (!((ITileEntityRendererCache)tileEntity).hasRenderer()) {
                return true;
            }
            if (!((ILoadable)tileEntity).isChunkLoaded()) {
                return true;
            }
            if (!((ICullable)tileEntity).canBeOcclusionCulled()) {
                return true;
            }
        }
        BlockPos pos = tileEntity.func_174877_v();
        return this.engine.raytraceUncachedThreshold((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveModeDiff);
    }

    private boolean checkBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (EntityCullingConfig.enableRaytraceCache) {
            return this.checkBoxCached(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return this.checkBoxUncached(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private boolean checkBoxCached(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int x1;
        int x0;
        int startX = MathHelper.func_76128_c((double)minX);
        int startY = MathHelper.func_76128_c((double)minY);
        int startZ = MathHelper.func_76128_c((double)minZ);
        int endX = MathHelper.func_76143_f((double)maxX);
        int endY = MathHelper.func_76143_f((double)maxY);
        int endZ = MathHelper.func_76143_f((double)maxZ);
        if (this.camX >= (double)startX && this.camX <= (double)endX && this.camY >= (double)startY && this.camY <= (double)endY && this.camZ >= (double)startZ && this.camZ <= (double)endZ) {
            return true;
        }
        if (this.camX < (double)startX ? CullingThread.checkRectangleCached(startY, endY, startZ, endZ, startX, this::raytraceCachedYZX) : this.camX > (double)endX && CullingThread.checkRectangleCached(startY, endY, startZ, endZ, endX, this::raytraceCachedYZX)) {
            return true;
        }
        if (this.camY < (double)startY) {
            x0 = this.camX < (double)startX ? startX + 1 : startX;
            int n = x1 = this.camX > (double)endX ? endX - 1 : endX;
            if (CullingThread.checkRectangleCached(x0, x1, startZ, endZ, startY, this::raytraceCachedXZY)) {
                return true;
            }
        } else if (this.camY > (double)endY) {
            x0 = this.camX < (double)startX ? startX + 1 : startX;
            int n = x1 = this.camX > (double)endX ? endX - 1 : endX;
            if (CullingThread.checkRectangleCached(x0, x1, startZ, endZ, endY, this::raytraceCachedXZY)) {
                return true;
            }
        }
        if (this.camZ < (double)startZ) {
            int y1;
            x0 = this.camX < (double)startX ? startX + 1 : startX;
            x1 = this.camX > (double)endX ? endX - 1 : endX;
            int y0 = this.camY < (double)startY ? startY + 1 : startY;
            int n = y1 = this.camY > (double)endY ? endY - 1 : endY;
            if (CullingThread.checkRectangleCached(x0, x1, y0, y1, startZ, this::raytraceCachedXYZ)) {
                return true;
            }
        } else if (this.camZ > (double)endZ) {
            int y1;
            x0 = this.camX < (double)startX ? startX + 1 : startX;
            x1 = this.camX > (double)endX ? endX - 1 : endX;
            int y0 = this.camY < (double)startY ? startY + 1 : startY;
            int n = y1 = this.camY > (double)endY ? endY - 1 : endY;
            if (CullingThread.checkRectangleCached(x0, x1, y0, y1, endZ, this::raytraceCachedXYZ)) {
                return true;
            }
        }
        return false;
    }

    private boolean raytraceCachedYZX(int y, int z, int x) {
        return this.engine.raytraceCachedThreshold(x, y, z, EntityCullingConfig.raytraceThreshold);
    }

    private boolean raytraceCachedXZY(int x, int z, int y) {
        return this.engine.raytraceCachedThreshold(x, y, z, EntityCullingConfig.raytraceThreshold);
    }

    private boolean raytraceCachedXYZ(int x, int y, int z) {
        return this.engine.raytraceCachedThreshold(x, y, z, EntityCullingConfig.raytraceThreshold);
    }

    private static boolean checkRectangleCached(int minX, int maxX, int minY, int maxY, int z, IntIntInt2BooleanFunction f) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                if (!f.applyAsBool(x, y, z)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkBoxUncached(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        int x1;
        int x0;
        if (this.camX >= minX && this.camX <= maxX && this.camY >= minY && this.camY <= maxY && this.camZ >= minZ && this.camZ <= maxZ) {
            return true;
        }
        double deltaX = maxX - minX;
        double deltaY = maxY - minY;
        double deltaZ = maxZ - minZ;
        int stepsX = MathHelper.func_76143_f((double)deltaX);
        int stepsY = MathHelper.func_76143_f((double)deltaY);
        int stepsZ = MathHelper.func_76143_f((double)deltaZ);
        double dx = deltaX / (double)stepsX;
        double dy = deltaY / (double)stepsY;
        double dz = deltaZ / (double)stepsZ;
        if (this.camX < minX ? CullingThread.checkRectangleUncached(0, stepsY, minY, dy, 0, stepsZ, minZ, dz, minX, this::raytraceUncachedYZX) : this.camX > maxX && CullingThread.checkRectangleUncached(0, stepsY, minY, dy, 0, stepsZ, minZ, dz, maxX, this::raytraceUncachedYZX)) {
            return true;
        }
        if (this.camY < minY) {
            x0 = this.camX < minX ? 1 : 0;
            int n = x1 = this.camX > maxX ? stepsX - 1 : stepsX;
            if (CullingThread.checkRectangleUncached(x0, x1, minX, dx, 0, stepsZ, minZ, dz, minY, this::raytraceUncachedXZY)) {
                return true;
            }
        } else if (this.camY > maxY) {
            x0 = this.camX < minX ? 1 : 0;
            int n = x1 = this.camX > maxX ? stepsX - 1 : stepsX;
            if (CullingThread.checkRectangleUncached(x0, x1, minX, dx, 0, stepsZ, minZ, dz, maxY, this::raytraceUncachedXZY)) {
                return true;
            }
        }
        if (this.camZ < minZ) {
            int y1;
            x0 = this.camX < minX ? 1 : 0;
            x1 = this.camX > maxX ? stepsX - 1 : stepsX;
            int y0 = this.camY < minY ? 1 : 0;
            int n = y1 = this.camY > maxY ? stepsY - 1 : stepsY;
            if (CullingThread.checkRectangleUncached(x0, x1, minX, dx, y0, y1, minY, dy, minZ, this::raytraceUncachedXYZ)) {
                return true;
            }
        } else if (this.camZ > maxZ) {
            int y1;
            x0 = this.camX < minX ? 1 : 0;
            x1 = this.camX > maxX ? stepsX - 1 : stepsX;
            int y0 = this.camY < minY ? 1 : 0;
            int n = y1 = this.camY > maxY ? stepsY - 1 : stepsY;
            if (CullingThread.checkRectangleUncached(x0, x1, minX, dx, y0, y1, minY, dy, maxZ, this::raytraceUncachedXYZ)) {
                return true;
            }
        }
        return false;
    }

    private boolean raytraceUncachedYZX(double y, double z, double x) {
        return this.engine.raytraceUncachedThreshold(x, y, z, EntityCullingConfig.raytraceThreshold);
    }

    private boolean raytraceUncachedXZY(double x, double z, double y) {
        return this.engine.raytraceUncachedThreshold(x, y, z, EntityCullingConfig.raytraceThreshold);
    }

    private boolean raytraceUncachedXYZ(double x, double y, double z) {
        return this.engine.raytraceUncachedThreshold(x, y, z, EntityCullingConfig.raytraceThreshold);
    }

    private static boolean checkRectangleUncached(int x0, int x1, double minX, double dx, int y0, int y1, double minY, double dy, double z, DoubleDoubleDouble2BooleanFunction f) {
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                if (!f.applyAsBool(minX + (double)x * dx, minY + (double)y * dy, z)) continue;
                return true;
            }
        }
        return false;
    }
}

