/*
 * Decompiled with CFR 0.152.
 */
package editableedibles.handlers;

import editableedibles.EditableEdibles;
import editableedibles.util.FoodEffectEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

@Config(modid="editableedibles")
public class ForgeConfigHandler {
    private static Object2ObjectArrayMap<Item, Int2ObjectArrayMap<FoodEffectEntry>> foodEffectMap = null;
    @Config.Comment(value={"Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Mod Compat Options"})
    @Config.Name(value="Compat Options")
    public static final CompatConfig compat = new CompatConfig();

    public static Object2ObjectArrayMap<Item, Int2ObjectArrayMap<FoodEffectEntry>> getFoodEffectMap() {
        if (foodEffectMap == null) {
            ForgeConfigHandler.parseItemEntries();
        }
        return foodEffectMap;
    }

    private static void parseItemEntries() {
        foodEffectMap = new Object2ObjectArrayMap();
        ForgeConfigHandler.parseFoodEffectArray();
        ForgeConfigHandler.parseFoodCancelArray();
        ForgeConfigHandler.parseFoodCureEffectArray();
        ForgeConfigHandler.parseFoodCureTypeArray();
        ForgeConfigHandler.parseAlwaysEdiblerray();
        ForgeConfigHandler.parseMistyWorldCompatArray();
    }

    private static void parseFoodEffectArray() {
        for (String string : ForgeConfigHandler.server.foodEffectArray) {
            try {
                FoodEffectEntry entry;
                Int2ObjectArrayMap metaMap;
                String[] arr = string.split(",");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                int meta = Integer.parseInt(arr[1].trim());
                Potion potion = Potion.func_180142_b((String)arr[2].trim());
                if (potion == null) {
                    EditableEdibles.LOGGER.log(Level.WARN, "Defined potion effect not found: " + arr[2].trim() + ", skipping");
                    continue;
                }
                int duration = Integer.parseInt(arr[3].trim());
                int amplifier = Integer.parseInt(arr[4].trim());
                boolean show = Boolean.parseBoolean(arr[5].trim());
                float chance = Float.parseFloat(arr[6].trim());
                boolean additiveDuration = false;
                int maxDuration = -1;
                boolean additiveAmplifier = false;
                int maxAmplifier = -1;
                if (arr.length > 7) {
                    try {
                        additiveDuration = Boolean.parseBoolean(arr[7].trim());
                        maxDuration = Integer.parseInt(arr[8].trim());
                        additiveAmplifier = Boolean.parseBoolean(arr[9].trim());
                        maxAmplifier = Integer.parseInt(arr[10].trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item)) == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.addEffect(new PotionEffect(potion, duration, amplifier, false, show), chance, additiveDuration, maxDuration, additiveAmplifier, maxAmplifier);
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse food effect entry: " + string);
            }
        }
    }

    private static void parseFoodCancelArray() {
        for (String string : ForgeConfigHandler.server.foodCancelArray) {
            try {
                FoodEffectEntry entry;
                String[] arr = string.split(",");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                int meta = Integer.parseInt(arr[1].trim());
                boolean cancel = Boolean.parseBoolean(arr[2].trim());
                Int2ObjectArrayMap metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item);
                if (metaMap == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.setCancelsDefault(cancel);
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse food default effect override entry: " + string);
            }
        }
    }

    private static void parseFoodCureEffectArray() {
        for (String string : ForgeConfigHandler.server.foodCureEffectArray) {
            try {
                FoodEffectEntry entry;
                String[] arr = string.split(",");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                int meta = Integer.parseInt(arr[1].trim());
                Potion potion = Potion.func_180142_b((String)arr[2].trim());
                if (potion == null) {
                    EditableEdibles.LOGGER.log(Level.WARN, "Defined potion effect not found: " + arr[2].trim() + ", skipping");
                    continue;
                }
                int duration = Integer.parseInt(arr[3].trim());
                int amplifier = Integer.parseInt(arr[4].trim());
                float chance = Float.parseFloat(arr[5].trim());
                Int2ObjectArrayMap metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item);
                if (metaMap == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.addCureEffect(new PotionEffect(potion, duration, amplifier), chance);
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse food cure effect entry: " + string);
            }
        }
    }

    private static void parseFoodCureTypeArray() {
        for (String string : ForgeConfigHandler.server.foodCureTypeArray) {
            try {
                FoodEffectEntry entry;
                String[] arr = string.split(",");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                int meta = Integer.parseInt(arr[1].trim());
                FoodEffectEntry.CureType cureType = FoodEffectEntry.CureType.valueOf(arr[2].trim());
                float chance = Float.parseFloat(arr[3].trim());
                Int2ObjectArrayMap metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item);
                if (metaMap == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.addCureType(cureType, chance);
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse food cure type entry: " + string);
            }
        }
    }

    private static void parseAlwaysEdiblerray() {
        for (String string : ForgeConfigHandler.server.alwaysEdibleArray) {
            try {
                FoodEffectEntry entry;
                String[] arr = string.split(",");
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                int meta = Integer.parseInt(arr[1].trim());
                Int2ObjectArrayMap metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item);
                if (metaMap == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.setAlwaysEdible();
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse always edible entry: " + string);
            }
        }
    }

    private static void parseMistyWorldCompatArray() {
        FoodEffectEntry entry;
        Int2ObjectArrayMap metaMap;
        float chance;
        int addValue;
        int meta;
        Item item;
        String[] arr;
        for (String string : ForgeConfigHandler.compat.mistyWorldFoodIntox) {
            try {
                arr = string.split(",");
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                meta = Integer.parseInt(arr[1].trim());
                addValue = Integer.parseInt(arr[2].trim());
                chance = Float.parseFloat(arr[3].trim());
                metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item);
                if (metaMap == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.setIntoxicationPair(addValue, Float.valueOf(chance));
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse MistyWorld intoxication entry: " + string);
            }
        }
        for (String string : ForgeConfigHandler.compat.mistyWorldFoodPollu) {
            try {
                arr = string.split(",");
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(arr[0].trim()));
                meta = Integer.parseInt(arr[1].trim());
                addValue = Integer.parseInt(arr[2].trim());
                chance = Float.parseFloat(arr[3].trim());
                metaMap = (Int2ObjectArrayMap)foodEffectMap.get((Object)item);
                if (metaMap == null) {
                    metaMap = new Int2ObjectArrayMap();
                }
                if ((entry = (FoodEffectEntry)metaMap.get(meta)) == null) {
                    entry = new FoodEffectEntry();
                }
                entry.setPollutionPair(addValue, Float.valueOf(chance));
                metaMap.put(meta, (Object)entry);
                foodEffectMap.put((Object)item, (Object)metaMap);
            }
            catch (Exception ex) {
                EditableEdibles.LOGGER.log(Level.WARN, "Failed to parse MistyWorld pollution entry: " + string);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="editableedibles")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("editableedibles")) {
                foodEffectMap = null;
                ConfigManager.sync((String)"editableedibles", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class CompatConfig {
        @Config.Comment(value={"List of food items with value to be added to intoxication and the chance to add it \nIntoxication is between 0 and 10000, values added can be negative \nFormat: String itemid, Int metadata (-1 for any), Int intoxicationAddValue, Float chance \nExample: minecraft:poisonous_potato, -1, -2000, 0.75"})
        @Config.Name(value="MistyWorld Food Intoxication and Chances")
        public String[] mistyWorldFoodIntox = new String[0];
        @Config.Comment(value={"List of food items with value to be added to pollution and the chance to add it \nPollution is between 0 and 10000, values added can be negative \nFormat: String itemid, Int metadata (-1 for any), Int pollutionAddValue, Float chance \nExample: minecraft:apple, -1, 1000, 0.5"})
        @Config.Name(value="MistyWorld Food Pollution and Chances")
        public String[] mistyWorldFoodPollu = new String[0];
    }

    public static class ServerConfig {
        @Config.Comment(value={"List of food items with their effects and chance to be applied when eaten \nFormat: String itemid, Int metadata (-1 for any), String potionid, Int duration, Int amplifier, Boolean showparticles, Float chance \nOptional Additional Args, allows for modifying application rules of custom effects: Boolean additiveDuration, Int maxDuration (-1 for any), Boolean additiveAmplifier, Int maxAmplifier (-1 for any)\nExample: minecraft:chicken, -1, minecraft:hunger, 120, 0, false, 0.25 \nExample (Additional): minecraft:steak, -1, minecraft:strength, 30, 0, false, 1.0, true, 120, false, -1"})
        @Config.Name(value="Food Effects and Chances")
        public String[] foodEffectArray = new String[0];
        @Config.Comment(value={"List of food items and if their default onFoodEaten handling should be cancelled \nFormat: String itemid, Int metadata (-1 for any), Boolean shouldcancel \nExample: minecraft:chicken, -1, true"})
        @Config.Name(value="Food Default Effect Override")
        public String[] foodCancelArray = new String[0];
        @Config.Comment(value={"List of food items with an effect to be cured and the chance to cure it \nFormat: String itemid, Int metadata (-1 for any), String potionid, Int maxDuration (-1 for any), Int maxAmplifier (-1 for any), Float chance \nExample: minecraft:carrot, -1, minecraft:blindness, -1, -1, 1.0"})
        @Config.Name(value="Food Cure Effects and Chances")
        public String[] foodCureEffectArray = new String[0];
        @Config.Comment(value={"List of food items with overall cure type to be cured and the chance to cure it \nFormat: String itemid, Int metadata (-1 for any), CureType cureType (ALL, POSITIVE, NEGATIVE), Float chance \nExample: minecraft:poisonous_potato, -1, POSITIVE, 0.25"})
        @Config.Name(value="Food Cure Types and Chances")
        public String[] foodCureTypeArray = new String[0];
        @Config.Comment(value={"List of food items that should always be edible \nFormat: String itemid, Int metadata (-1 for any) \nExample: minecraft:apple, -1"})
        @Config.Name(value="Always Edible Food Items")
        public String[] alwaysEdibleArray = new String[0];
        @Config.Comment(value={"If food items should always be edible, overrides the list"})
        @Config.Name(value="Override Always Edible")
        public boolean overrideAlwaysEdible = false;
    }
}

