/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPMushroom;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenBush;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesMegaOakConifer
extends Species {
    public SpeciesMegaOakConifer(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "megaoakconifer"), treeFamily, ModContent.leaves.get("oakconifer"));
        this.setBasicGrowingParameters(0.3f, 32.0f, 7, 7, 1.0f);
        this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic().setHeightVariation(8));
        this.setSoilLongevity(14);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
        this.envFactor(BiomeDictionary.Type.PLAINS, 1.05f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.setupStandardSeedDropping();
        this.setRequiresTileEntity(true);
        this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
        this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
        this.addGenFeature((IGenFeature)new FeatureGenMound(999));
        this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
        this.addGenFeature((IGenFeature)new FeatureGenBush(), 4);
    }

    public boolean isBiomePerfect(Biome biome) {
        return biome == BOPBiomes.temperate_rainforest.orNull();
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
        if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
            if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                world.func_175656_a(pos, BOPBlocks.mushroom.func_176223_P().func_177226_a((IProperty)BlockBOPMushroom.VARIANT, (Comparable)BlockBOPMushroom.MushroomType.BLUE_MILK_CAP));
            }
            return true;
        }
        return false;
    }

    public boolean isThick() {
        return true;
    }
}

