/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenBush;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import dynamictreesbop.ModContent;
import dynamictreesbop.cells.DTBOPLeafClusters;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeEucalyptus
extends TreeFamily {
    public TreeEucalyptus() {
        super(new ResourceLocation("dynamictreesbop", "eucalyptus"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.EUCALYPTUS);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.EUCALYPTUS));
        this.hasConiferVariants = true;
        ModContent.leaves.get("eucalyptus").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.EUCALYPTUS);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesEucalyptus(this));
    }

    public BlockBranch createBranch() {
        return new BlockBranchBasic(this.getName() + "branch"){

            /*
             * Enabled aggressive block sorting
             */
            public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
                if (signal.step()) {
                    Species species = signal.getSpecies();
                    EnumFacing originDir = signal.dir.func_176734_d();
                    EnumFacing prevDir = signal.dir;
                    EnumFacing targetDir = species.selectNewDirection(world, pos, (BlockBranch)this, signal);
                    signal.doTurn(targetDir);
                    BlockPos deltaPos = pos.func_177972_a(targetDir);
                    EnumFacing[] blockState = world.func_180495_p(deltaPos);
                    ITreePart treepart = TreeHelper.getTreePart((IBlockState)blockState);
                    if (treepart != TreeHelper.nullTreePart) {
                        if (signal.numTurns >= 2 && treepart.getTreePartType() != ITreePart.TreePartType.BRANCH) {
                            signal.success = false;
                            return signal;
                        }
                        signal = treepart.growSignal(world, deltaPos, signal);
                    } else if (world.func_175623_d(deltaPos)) {
                        if (!signal.isInTrunk() && prevDir == targetDir) {
                            signal.success = false;
                            return signal;
                        }
                        signal = this.growIntoAir(world, deltaPos, signal, this.getRadius((IBlockState)blockState));
                    }
                    if (signal.isInTrunk()) {
                        float areaAccum = signal.radius * signal.radius;
                        for (EnumFacing dir : EnumFacing.field_82609_l) {
                            BlockPos deltaPos2;
                            IBlockState blockState2;
                            ITreePart treepart2;
                            if (dir.equals((Object)originDir) || dir.equals((Object)targetDir) || !this.isSameTree(treepart2 = TreeHelper.getTreePart((IBlockState)(blockState2 = world.func_180495_p(deltaPos2 = pos.func_177972_a(dir)))))) continue;
                            int branchRadius = treepart2.getRadius(blockState2);
                            areaAccum += (float)(branchRadius * branchRadius);
                        }
                        IBlockState currBlockState = world.func_180495_p(pos);
                        signal.radius = MathHelper.func_76131_a((float)((float)Math.sqrt(areaAccum) + species.getTapering()), (float)this.getRadius(currBlockState), (float)8.0f);
                        this.setRadius(world, pos, (int)Math.floor(signal.radius), null);
                    }
                }
                return signal;
            }

            public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
                Species species = signal.getSpecies();
                BlockDynamicLeaves leaves = TreeHelper.getLeaves((IBlockState)species.getLeavesProperties().getDynamicLeavesState());
                if (leaves != null && signal.energy > 0.0f) {
                    if (fromRadius == 1) {
                        signal.success = leaves.growLeavesIfLocationIsSuitable(world, species.getLeavesProperties(), pos, 0);
                    } else {
                        if (signal.numTurns < 2) {
                            return leaves.branchOut(world, pos, signal);
                        }
                        signal.success = leaves.growLeavesIfLocationIsSuitable(world, species.getLeavesProperties(), pos, 0);
                    }
                }
                return signal;
            }
        };
    }

    public class NodeInflatorEucalyptus
    implements INodeInspector {
        private float radius;
        private BlockPos last;
        Species species;
        SimpleVoxmap leafMap;

        public NodeInflatorEucalyptus(Species species, SimpleVoxmap leafMap) {
            this.species = species;
            this.leafMap = leafMap;
            this.last = BlockPos.field_177992_a;
        }

        public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)blockState);
            if (branch != null) {
                this.radius = this.species.getFamily().getPrimaryThickness();
            }
            return false;
        }

        public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
            BlockBranch branch = TreeHelper.getBranch((IBlockState)blockState);
            if (branch != null) {
                SimpleVoxmap leafCluster;
                float areaAccum = this.radius * this.radius;
                boolean isTwig = true;
                boolean isTop = world.func_180495_p(pos.func_177977_b()).func_177230_c() == branch;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (dir.equals((Object)fromDir)) continue;
                    BlockPos dPos = pos.func_177972_a(dir);
                    if (dPos.equals((Object)this.last)) {
                        isTwig = false;
                        isTop = false;
                        continue;
                    }
                    IBlockState deltaBlockState = world.func_180495_p(dPos);
                    ITreePart treepart = TreeHelper.getTreePart((IBlockState)deltaBlockState);
                    if (!branch.isSameTree(treepart)) continue;
                    int branchRadius = treepart.getRadius(deltaBlockState);
                    areaAccum += (float)(branchRadius * branchRadius);
                }
                if (isTop) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = DTBOPLeafClusters.eucalyptusTop;
                    this.leafMap.blitMax(pos, leafCluster);
                } else if (isTwig) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                    this.leafMap.setVoxel(pos.func_177972_a(fromDir.func_176734_d()), (byte)0);
                } else {
                    float secondaryThickness;
                    this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                    int maxRadius = this.species.maxBranchRadius();
                    if (this.radius > (float)maxRadius) {
                        this.radius = maxRadius;
                    }
                    if (this.radius < (secondaryThickness = this.species.getFamily().getSecondaryThickness())) {
                        this.radius = secondaryThickness;
                    }
                    branch.setRadius(world, pos, (int)Math.floor(this.radius), null);
                    this.leafMap.setVoxel(pos, (byte)32);
                    if (Math.floor(this.radius) <= 3.0) {
                        SimpleVoxmap leafCluster2 = DTBOPLeafClusters.eucalyptusTrunk;
                        this.leafMap.blitMax(pos, leafCluster2);
                    }
                }
                this.last = pos;
            }
            return false;
        }
    }

    public class SpeciesEucalyptus
    extends Species {
        public SpeciesEucalyptus(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("eucalyptus"));
            this.setBasicGrowingParameters(0.25f, 15.0f, 5, 11, 0.9f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.15f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.2f);
            this.envFactor(BiomeDictionary.Type.HOT, 1.1f);
            this.envFactor(BiomeDictionary.Type.WET, 1.1f);
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenBush(), 4);
        }

        public boolean isBiomePerfect(Biome biome) {
            return biome == BOPBiomes.eucalyptus_forest.orNull();
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = signal.isInTrunk() ? 0 : 1;
            probMap[1] = signal.isInTrunk() ? 5 : 1;
            probMap[5] = (signal.isInTrunk() && signal.numSteps % 2 == 0 && signal.energy > 2.0f || !signal.isInTrunk()) && signal.energy < 12.0f ? 1 : 0;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            probMap[originDir.ordinal()] = 0;
            if (!signal.isInTrunk()) {
                probMap[signal.dir.ordinal()] = 0;
            }
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                signal.energy = 1.2f;
            } else if (!signal.isInTrunk()) {
                if (signal.delta.func_177958_n() > 0 && newDir == EnumFacing.EAST) {
                    signal.energy = 0.0f;
                } else if (signal.delta.func_177958_n() < 0 && newDir == EnumFacing.WEST) {
                    signal.energy = 0.0f;
                } else if (signal.delta.func_177952_p() > 0 && newDir == EnumFacing.SOUTH) {
                    signal.energy = 0.0f;
                } else if (signal.delta.func_177952_p() < 0 && newDir == EnumFacing.NORTH) {
                    signal.energy = 0.0f;
                }
            }
            return newDir;
        }

        public float getEnergy(World world, BlockPos pos) {
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(this.coordHashCode(pos) % 16);
        }

        public int getLowestBranchHeight(World world, BlockPos pos) {
            return this.getLowestBranchHeight() + (int)((float)(this.coordHashCode(pos) % 16) * 0.625f);
        }

        public INodeInspector getNodeInflator(SimpleVoxmap leafMap) {
            return new NodeInflatorEucalyptus(this, leafMap);
        }

        public int getWorldGenLeafMapHeight() {
            return 36;
        }
    }
}

