/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.featuregen;

import com.ferreusveritas.dynamictrees.api.IFullGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenBrushBush
implements IFullGenFeature,
IPostGenFeature {
    private Predicate<Biome> biomePredicate = i -> true;
    private IBlockState state;
    protected int generationAttempts = 16;

    public FeatureGenBrushBush setBlockState(IBlockState state) {
        this.state = state;
        return this;
    }

    public FeatureGenBrushBush setBiomePredicate(Predicate<Biome> biomePredicate) {
        this.biomePredicate = biomePredicate;
        return this;
    }

    public boolean generate(World world, BlockPos rootPos, Species species, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        this.commonGen(world, rootPos, species, random, radius, safeBounds);
        return true;
    }

    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (safeBounds != SafeChunkBounds.ANY && this.biomePredicate.test(biome)) {
            this.commonGen(world, rootPos, species, world.field_73012_v, radius, safeBounds);
            return true;
        }
        return false;
    }

    protected void commonGen(World world, BlockPos rootPos, Species species, Random random, int radius, SafeChunkBounds safeBounds) {
        Block block = this.state.func_177230_c();
        int rad = 12;
        int yOff = 4;
        for (int i = 0; i < this.generationAttempts; ++i) {
            int x = rootPos.func_177958_n() + rad - random.nextInt(rad * 2 + 1);
            int z = rootPos.func_177952_p() + rad - random.nextInt(rad * 2 + 1);
            BlockPos.MutableBlockPos genPos = new BlockPos.MutableBlockPos(x, rootPos.func_177956_o() + 1 - yOff, z);
            if (!safeBounds.inBounds((BlockPos)genPos, true)) continue;
            for (int y = 0; y <= yOff * 2 && !world.func_175623_d((BlockPos)genPos); ++y) {
                genPos.func_189536_c(EnumFacing.UP);
            }
            if (!species.isAcceptableSoil(world, genPos.func_177977_b(), world.func_180495_p(genPos.func_177977_b())) || !world.func_175623_d((BlockPos)genPos) || world.func_189509_E((BlockPos)genPos) || !block.func_176196_c(world, (BlockPos)genPos)) continue;
            world.func_180501_a((BlockPos)genPos, this.state, 2);
        }
    }
}

